/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml;

import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.dataformat.xml.XmlAnnotationIntrospector;
import com.fasterxml.jackson.dataformat.xml.XmlTypeResolverBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;

public class JacksonXmlAnnotationIntrospector
extends JacksonAnnotationIntrospector
implements XmlAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    public static final boolean DEFAULT_USE_WRAPPER = true;
    protected final boolean _cfgDefaultUseWrapper;

    public JacksonXmlAnnotationIntrospector() {
        this(true);
    }

    public JacksonXmlAnnotationIntrospector(boolean defaultUseWrapper) {
        this._cfgDefaultUseWrapper = defaultUseWrapper;
    }

    public PropertyName findWrapperName(Annotated ann) {
        JacksonXmlElementWrapper w = (JacksonXmlElementWrapper)ann.getAnnotation(JacksonXmlElementWrapper.class);
        if (w != null) {
            if (!w.useWrapping()) {
                return PropertyName.NO_NAME;
            }
            String localName = w.localName();
            if (localName == null || localName.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return PropertyName.construct((String)w.localName(), (String)w.namespace());
        }
        if (this._cfgDefaultUseWrapper) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    public PropertyName findRootName(AnnotatedClass ac) {
        JacksonXmlRootElement root = (JacksonXmlRootElement)ac.getAnnotation(JacksonXmlRootElement.class);
        if (root != null) {
            String local = root.localName();
            String ns = root.namespace();
            if (local.length() == 0 && ns.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return new PropertyName(local, ns);
        }
        return super.findRootName(ac);
    }

    @Override
    public String findNamespace(Annotated ann) {
        JacksonXmlProperty prop = (JacksonXmlProperty)ann.getAnnotation(JacksonXmlProperty.class);
        if (prop != null) {
            return prop.namespace();
        }
        return null;
    }

    @Override
    public Boolean isOutputAsAttribute(Annotated ann) {
        JacksonXmlProperty prop = (JacksonXmlProperty)ann.getAnnotation(JacksonXmlProperty.class);
        if (prop != null) {
            return prop.isAttribute() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public Boolean isOutputAsText(Annotated ann) {
        JacksonXmlText prop = (JacksonXmlText)ann.getAnnotation(JacksonXmlText.class);
        if (prop != null) {
            return prop.value() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public PropertyName findNameForSerialization(Annotated a) {
        PropertyName name = this._findXmlName(a);
        if (name == null && (name = super.findNameForSerialization(a)) == null && a.hasAnnotation(JacksonXmlText.class)) {
            return PropertyName.USE_DEFAULT;
        }
        return name;
    }

    @Deprecated
    public String findSerializationName(AnnotatedField a) {
        PropertyName pname = this._findXmlName((Annotated)a);
        if (pname != null) {
            return pname.getSimpleName();
        }
        String name = super.findSerializationName(a);
        if (name == null && a.hasAnnotation(JacksonXmlText.class)) {
            return "";
        }
        return name;
    }

    @Deprecated
    public String findSerializationName(AnnotatedMethod a) {
        PropertyName pname = this._findXmlName((Annotated)a);
        if (pname != null) {
            return pname.getSimpleName();
        }
        String name = super.findSerializationName(a);
        if (name == null && a.hasAnnotation(JacksonXmlText.class)) {
            return "";
        }
        return name;
    }

    public PropertyName findNameForDeserialization(Annotated a) {
        PropertyName name = this._findXmlName(a);
        if (name == null && (name = super.findNameForDeserialization(a)) == null && a.hasAnnotation(JacksonXmlText.class)) {
            return PropertyName.USE_DEFAULT;
        }
        return name;
    }

    @Deprecated
    public String findDeserializationName(AnnotatedField a) {
        PropertyName pname = this._findXmlName((Annotated)a);
        if (pname != null) {
            return pname.getSimpleName();
        }
        String name = super.findDeserializationName(a);
        if (name == null && a.hasAnnotation(JacksonXmlText.class)) {
            return "";
        }
        return name;
    }

    @Deprecated
    public String findDeserializationName(AnnotatedMethod a) {
        PropertyName pname = this._findXmlName((Annotated)a);
        if (pname != null) {
            return pname.getSimpleName();
        }
        String name = super.findDeserializationName(a);
        if (name == null && a.hasAnnotation(JacksonXmlText.class)) {
            return "";
        }
        return name;
    }

    @Deprecated
    public String findDeserializationName(AnnotatedParameter a) {
        String local;
        PropertyName pname = this._findXmlName((Annotated)a);
        if (pname != null && (local = pname.getSimpleName()) != null && local.length() > 0) {
            return local;
        }
        String name = super.findDeserializationName(a);
        if (name == null && a.hasAnnotation(JacksonXmlText.class)) {
            return "";
        }
        return super.findDeserializationName(a);
    }

    protected StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new XmlTypeResolverBuilder();
    }

    protected PropertyName _findXmlName(Annotated a) {
        JacksonXmlProperty pann = (JacksonXmlProperty)a.getAnnotation(JacksonXmlProperty.class);
        if (pann != null) {
            return PropertyName.construct((String)pann.localName(), (String)pann.namespace());
        }
        return null;
    }
}

