/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.util;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.dataformat.xml.XmlAnnotationIntrospector;
import javax.xml.namespace.QName;

public class XmlRootNameLookup {
    protected final LRUMap<ClassKey, QName> _rootNames = new LRUMap(40, 200);

    public QName findRootName(JavaType rootType, MapperConfig<?> config) {
        return this.findRootName(rootType.getRawClass(), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QName findRootName(Class<?> rootType, MapperConfig<?> config) {
        QName name;
        ClassKey key = new ClassKey(rootType);
        LRUMap<ClassKey, QName> lRUMap = this._rootNames;
        synchronized (lRUMap) {
            name = (QName)this._rootNames.get((Object)key);
            if (name == null) {
                BeanDescription beanDesc = config.introspectClassAnnotations(rootType);
                AnnotationIntrospector intr = config.getAnnotationIntrospector();
                AnnotatedClass ac = beanDesc.getClassInfo();
                String localName = null;
                String ns = null;
                QName root = this.findRootElement(intr, ac);
                if (root != null) {
                    localName = root.getLocalPart();
                    ns = root.getNamespaceURI();
                }
                if (localName == null || localName.length() == 0) {
                    localName = intr.findRootName(ac);
                }
                if (localName == null || localName.length() == 0) {
                    localName = rootType.getSimpleName();
                    name = new QName("", localName);
                } else if (ns == null || ns.length() == 0) {
                    ns = this.findNamespace(intr, ac);
                }
                if (ns == null) {
                    ns = "";
                }
                name = new QName(ns, localName);
                this._rootNames.put((Object)key, (Object)name);
            }
        }
        return name;
    }

    private String findNamespace(AnnotationIntrospector ai, AnnotatedClass ann) {
        for (AnnotationIntrospector intr : ai.allIntrospectors()) {
            String ns;
            if (!(intr instanceof XmlAnnotationIntrospector) || (ns = ((XmlAnnotationIntrospector)intr).findNamespace((Annotated)ann)) == null) continue;
            return ns;
        }
        return null;
    }

    private QName findRootElement(AnnotationIntrospector ai, AnnotatedClass ann) {
        for (AnnotationIntrospector intr : ai.allIntrospectors()) {
            QName elem;
            if (!(intr instanceof XmlAnnotationIntrospector) || (elem = ((XmlAnnotationIntrospector)intr).findRootElement((Annotated)ann)) == null) continue;
            return elem;
        }
        return null;
    }
}

