/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml;

import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.dataformat.xml.XmlAnnotationIntrospector;
import com.fasterxml.jackson.dataformat.xml.XmlTypeResolverBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import javax.xml.namespace.QName;

public class JacksonXmlAnnotationIntrospector
extends JacksonAnnotationIntrospector
implements XmlAnnotationIntrospector {
    @Override
    public String findNamespace(Annotated ann) {
        JacksonXmlProperty prop = (JacksonXmlProperty)ann.getAnnotation(JacksonXmlProperty.class);
        if (prop != null) {
            return prop.namespace();
        }
        return null;
    }

    @Override
    public QName findWrapperElement(Annotated ann) {
        JacksonXmlElementWrapper w = (JacksonXmlElementWrapper)ann.getAnnotation(JacksonXmlElementWrapper.class);
        if (w != null) {
            return new QName(w.namespace(), w.localName());
        }
        return null;
    }

    @Override
    public QName findRootElement(Annotated ann) {
        JacksonXmlRootElement root = (JacksonXmlRootElement)ann.getAnnotation(JacksonXmlRootElement.class);
        if (root != null) {
            return new QName(root.namespace(), root.localName());
        }
        return null;
    }

    @Override
    public Boolean isOutputAsAttribute(Annotated ann) {
        JacksonXmlProperty prop = (JacksonXmlProperty)ann.getAnnotation(JacksonXmlProperty.class);
        if (prop != null) {
            return prop.isAttribute() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public Boolean isOutputAsText(Annotated ann) {
        JacksonXmlText prop = (JacksonXmlText)ann.getAnnotation(JacksonXmlText.class);
        if (prop != null) {
            return prop.value() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public String findSerializationName(AnnotatedField af) {
        String name = this._findXmlName((Annotated)af);
        if (name != null) {
            return name;
        }
        return super.findSerializationName(af);
    }

    public String findSerializationName(AnnotatedMethod am) {
        String name = this._findXmlName((Annotated)am);
        if (name != null) {
            return name;
        }
        return super.findSerializationName(am);
    }

    public String findDeserializationName(AnnotatedField af) {
        String name = this._findXmlName((Annotated)af);
        if (name != null) {
            return name;
        }
        return super.findDeserializationName(af);
    }

    public String findDeserializationName(AnnotatedMethod am) {
        String name = this._findXmlName((Annotated)am);
        if (name != null) {
            return name;
        }
        return super.findDeserializationName(am);
    }

    public String findDeserializationName(AnnotatedParameter ap) {
        String name = this._findXmlName((Annotated)ap);
        if (name != null && name.length() > 0) {
            return name;
        }
        return super.findDeserializationName(ap);
    }

    protected String _findXmlName(Annotated a) {
        JacksonXmlProperty pann = (JacksonXmlProperty)a.getAnnotation(JacksonXmlProperty.class);
        if (pann != null) {
            return pann.localName();
        }
        return null;
    }

    protected StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new XmlTypeResolverBuilder();
    }
}

