/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.ser;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.dataformat.xml.ser.XmlBeanPropertyWriter;
import com.fasterxml.jackson.dataformat.xml.ser.XmlBeanSerializer;
import com.fasterxml.jackson.dataformat.xml.util.AnnotationUtil;
import com.fasterxml.jackson.dataformat.xml.util.XmlInfo;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class XmlBeanSerializerModifier
extends BeanSerializerModifier {
    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        int len = beanProperties.size();
        for (int i = 0; i < len; ++i) {
            BeanPropertyWriter bpw = beanProperties.get(i);
            AnnotatedMember member = bpw.getMember();
            String ns = AnnotationUtil.findNamespaceAnnotation(intr, member);
            Boolean isAttribute = AnnotationUtil.findIsAttributeAnnotation(intr, member);
            bpw.setInternalSetting((Object)XmlBeanSerializer.KEY_XML_INFO, (Object)new XmlInfo(isAttribute, ns));
            if (!XmlBeanSerializerModifier._isContainerType(bpw.getType())) continue;
            String localName = null;
            String wrapperNs = null;
            QName wrappedName = new QName(ns, bpw.getName());
            QName wrapperName = AnnotationUtil.findWrapperName(intr, member);
            if (wrapperName != null) {
                localName = wrapperName.getLocalPart();
                wrapperNs = wrapperName.getNamespaceURI();
            }
            wrapperName = localName == null || localName.length() == 0 ? wrappedName : new QName(wrapperNs == null ? "" : wrapperNs, localName);
            beanProperties.set(i, new XmlBeanPropertyWriter(bpw, wrapperName, wrappedName));
        }
        return beanProperties;
    }

    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        if (!(serializer instanceof BeanSerializerBase)) {
            return serializer;
        }
        return new XmlBeanSerializer((BeanSerializerBase)serializer);
    }

    private static boolean _isContainerType(JavaType type) {
        if (type.isContainerType()) {
            Class cls = type.getRawClass();
            if (cls == byte[].class || cls == byte[].class) {
                return false;
            }
            return !Map.class.isAssignableFrom(cls);
        }
        return false;
    }
}

