/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.toml;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.dataformat.toml.PackageVersion;
import com.fasterxml.jackson.dataformat.toml.StringOutputUtil;
import com.fasterxml.jackson.dataformat.toml.TomlStreamWriteException;
import com.fasterxml.jackson.dataformat.toml.TomlWriteContext;
import com.fasterxml.jackson.dataformat.toml.TomlWriteFeature;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;

final class TomlGenerator
extends GeneratorBase {
    protected static final int SHORT_WRITE = 100;
    protected final IOContext _ioContext;
    protected final Writer _out;
    private final int _tomlFeatures;
    protected TomlWriteContext _streamWriteContext;
    protected char[] _outputBuffer;
    protected int _outputTail = 0;
    protected final int _outputEnd;
    protected final StringBuilder _basePath = new StringBuilder(50);

    public TomlGenerator(IOContext ioCtxt, int stdFeatures, int tomlFeatures, ObjectCodec codec, Writer out) {
        super(stdFeatures, codec);
        this._ioContext = ioCtxt;
        this._tomlFeatures = tomlFeatures;
        this._streamWriteContext = TomlWriteContext.createRootContext();
        this._out = out;
        this._outputBuffer = ioCtxt.allocConcatBuffer();
        this._outputEnd = this._outputBuffer.length;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public void close() throws IOException {
        super.close();
        this._flushBuffer();
        this._outputTail = 0;
        if (this._out != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(StreamWriteFeature.AUTO_CLOSE_TARGET)) {
                this._out.close();
            } else if (this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM)) {
                this._out.flush();
            }
        }
        this._releaseBuffers();
    }

    public void flush() throws IOException {
        this._flushBuffer();
        if (this._out != null && this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM)) {
            this._out.flush();
        }
    }

    protected void _releaseBuffers() {
        char[] buf = this._outputBuffer;
        if (buf != null) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(buf);
        }
    }

    protected void _flushBuffer() throws IOException {
        if (this._outputTail > 0) {
            this._out.write(this._outputBuffer, 0, this._outputTail);
            this._outputTail = 0;
        }
    }

    protected void _writeRaw(char c) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c;
    }

    protected void _writeRaw(String text) throws IOException {
        int len = text.length();
        int room = this._outputEnd - this._outputTail;
        if (room == 0) {
            this._flushBuffer();
            room = this._outputEnd - this._outputTail;
        }
        if (room >= len) {
            text.getChars(0, len, this._outputBuffer, this._outputTail);
            this._outputTail += len;
        } else {
            this._writeRawLong(text);
        }
    }

    protected void _writeRaw(StringBuilder text) throws IOException {
        int len = text.length();
        int room = this._outputEnd - this._outputTail;
        if (room == 0) {
            this._flushBuffer();
            room = this._outputEnd - this._outputTail;
        }
        if (room >= len) {
            text.getChars(0, len, this._outputBuffer, this._outputTail);
            this._outputTail += len;
        } else {
            this._writeRawLong(text);
        }
    }

    protected void _writeRaw(char[] text, int offset, int len) throws IOException {
        if (len < 100) {
            int room = this._outputEnd - this._outputTail;
            if (len > room) {
                this._flushBuffer();
            }
            System.arraycopy(text, offset, this._outputBuffer, this._outputTail, len);
            this._outputTail += len;
            return;
        }
        this._flushBuffer();
        this._out.write(text, offset, len);
    }

    protected void _writeRawLong(String text) throws IOException {
        int len;
        int amount;
        int room = this._outputEnd - this._outputTail;
        text.getChars(0, room, this._outputBuffer, this._outputTail);
        this._outputTail += room;
        this._flushBuffer();
        int offset = room;
        for (len = text.length() - room; len > this._outputEnd; len -= amount) {
            amount = this._outputEnd;
            text.getChars(offset, offset + amount, this._outputBuffer, 0);
            this._outputTail = amount;
            this._flushBuffer();
            offset += amount;
        }
        text.getChars(offset, offset + len, this._outputBuffer, 0);
        this._outputTail = len;
    }

    protected void _writeRawLong(StringBuilder text) throws IOException {
        int len;
        int amount;
        int room = this._outputEnd - this._outputTail;
        text.getChars(0, room, this._outputBuffer, this._outputTail);
        this._outputTail += room;
        this._flushBuffer();
        int offset = room;
        for (len = text.length() - room; len > this._outputEnd; len -= amount) {
            amount = this._outputEnd;
            text.getChars(offset, offset + amount, this._outputBuffer, 0);
            this._outputTail = amount;
            this._flushBuffer();
            offset += amount;
        }
        text.getChars(offset, offset + len, this._outputBuffer, 0);
        this._outputTail = len;
    }

    public Object getCurrentValue() {
        return this._streamWriteContext.getCurrentValue();
    }

    public void setCurrentValue(Object v) {
        this._streamWriteContext.setCurrentValue(v);
    }

    public boolean canWriteObjectId() {
        return false;
    }

    public boolean canWriteTypeId() {
        return false;
    }

    public void writeFieldName(String name) throws IOException {
        if (!this._streamWriteContext.writeName(name)) {
            this._reportError("Cannot write a property name, expecting a value");
        }
        if (this._streamWriteContext._inline) {
            if (this._streamWriteContext.hasCurrentIndex()) {
                this._writeRaw(", ");
            }
            this._writeStringImpl(-1, name);
        } else {
            this._streamWriteContext.truncatePath(this._basePath);
            if (this._basePath.length() > 0) {
                this._basePath.append('.');
            }
            this._appendPropertyName(this._basePath, name);
        }
    }

    public void writeStartArray() throws IOException {
        this.writeStartArray(null);
    }

    public void writeStartArray(Object currValue) throws IOException {
        this._verifyValueWrite("start an array", true);
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(currValue, this._basePath.length());
        if (this._streamWriteContext._inline) {
            this._writeRaw('[');
        }
    }

    public void writeEndArray() throws IOException {
        if (!this._streamWriteContext.inArray()) {
            this._reportError("Current context not an Array but " + this._streamWriteContext.typeDesc());
        }
        if (this._streamWriteContext._inline) {
            this._writeRaw(']');
        } else if (!this._streamWriteContext.hasCurrentIndex()) {
            VersionUtil.throwInternal();
        }
        this._streamWriteContext = this._streamWriteContext.getParent();
        this.writeValueEnd();
    }

    public void writeStartObject() throws IOException {
        this.writeStartObject(null);
    }

    public void writeStartObject(Object forValue) throws IOException {
        this._verifyValueWrite("start an object", false);
        this._streamWriteContext = this._streamWriteContext.createChildObjectContext(forValue, this._basePath.length());
        if (this._streamWriteContext._inline) {
            this.writeRaw('{');
        }
    }

    public void writeEndObject() throws IOException {
        if (!this._streamWriteContext.inObject()) {
            this._reportError("Current context not an Object but " + this._streamWriteContext.typeDesc());
        }
        if (this._streamWriteContext._inline) {
            this.writeRaw('}');
            this._streamWriteContext = this._streamWriteContext.getParent();
            this.writeValueEnd();
        } else {
            if (!this._streamWriteContext.hasCurrentIndex()) {
                this.writeCurrentPath();
                this._writeRaw("{}");
                this.writeValueEnd();
            }
            this._streamWriteContext = this._streamWriteContext.getParent();
        }
    }

    public void writeString(String text) throws IOException {
        if (text == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        this._writeStringImpl(-2, text);
        this.writeValueEnd();
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        this._verifyValueWrite("write String value");
        this._writeStringImpl(-2, text, offset, len);
        this.writeValueEnd();
    }

    public void writeRawUTF8String(byte[] text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeUTF8String(byte[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len, StandardCharsets.UTF_8));
        this.writeValueEnd();
    }

    public void writeRaw(String text) throws IOException {
        this._writeRaw(text);
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        this._writeRaw(text.substring(offset, offset + len));
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        this._writeRaw(text, offset, len);
    }

    public void writeRaw(char c) throws IOException {
        this._writeRaw(c);
    }

    public void writeRaw(SerializableString text) throws IOException {
        this.writeRaw(text.toString());
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        if (data == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (offset > 0 || offset + len != data.length) {
            data = Arrays.copyOfRange(data, offset, offset + len);
        }
        String encoded = b64variant.encode(data);
        this._writeRaw('\'');
        this._writeRaw(encoded);
        this._writeRaw('\'');
        this.writeValueEnd();
    }

    public void writeBoolean(boolean state) throws IOException {
        this._verifyValueWrite("write boolean value");
        this._writeRaw(state ? "true" : "false");
        this.writeValueEnd();
    }

    public void writeNumber(short v) throws IOException {
        this.writeNumber((int)v);
        this.writeValueEnd();
    }

    public void writeNumber(int i) throws IOException {
        this._verifyValueWrite("write number");
        this._writeRaw(String.valueOf(i));
        this.writeValueEnd();
    }

    public void writeNumber(long l) throws IOException {
        this._verifyValueWrite("write number");
        this._writeRaw(String.valueOf(l));
        this.writeValueEnd();
    }

    public void writeNumber(BigInteger v) throws IOException {
        if (v == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeRaw(String.valueOf(v));
        this.writeValueEnd();
    }

    public void writeNumber(double d) throws IOException {
        this._verifyValueWrite("write number");
        this._writeRaw(String.valueOf(d));
        this.writeValueEnd();
    }

    public void writeNumber(float f) throws IOException {
        this._verifyValueWrite("write number");
        this._writeRaw(String.valueOf(f));
        this.writeValueEnd();
    }

    public void writeNumber(BigDecimal dec) throws IOException {
        if (dec == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        String str = this.isEnabled(StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN) ? dec.toPlainString() : dec.toString();
        this._writeRaw(str);
        this.writeValueEnd();
    }

    public void writeNumber(String encodedValue) throws IOException {
        if (encodedValue == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeRaw(encodedValue);
        this.writeValueEnd();
    }

    public void writeNull() throws IOException {
        if (TomlWriteFeature.FAIL_ON_NULL_WRITE.enabledIn(this._tomlFeatures)) {
            throw new TomlStreamWriteException("TOML null writing disabled (TomlWriteFeature.FAIL_ON_NULL_WRITE)", (JsonGenerator)this);
        }
        this._verifyValueWrite("write null value");
        this._writeStringImpl(-2, "");
        this.writeValueEnd();
    }

    protected void _verifyValueWrite(String typeMsg) throws IOException {
        this._verifyValueWrite(typeMsg, true);
    }

    protected void _verifyValueWrite(String typeMsg, boolean forceMaterializeKey) throws IOException {
        if (!this._streamWriteContext.writeValue()) {
            this._reportError("Cannot " + typeMsg + ", expecting a property name");
        }
        if (this._streamWriteContext._inline) {
            if (this._streamWriteContext.inArray()) {
                if (this._streamWriteContext.getCurrentIndex() != 0) {
                    this._writeRaw(", ");
                }
            } else {
                this._writeRaw(" = ");
            }
        } else if (forceMaterializeKey) {
            this.writeCurrentPath();
        }
    }

    private void writeCurrentPath() throws IOException {
        this._writeRaw(this._basePath);
        this._writeRaw(" = ");
    }

    private void writeValueEnd() throws IOException {
        if (!this._streamWriteContext._inline) {
            this.writeRaw('\n');
        }
    }

    private void _appendPropertyName(StringBuilder path, String name) throws IOException {
        int cat = StringOutputUtil.categorize(name) & 0xFFFFFFFF;
        if ((cat & 1) != 0) {
            path.append(name);
        } else if ((cat & 2) != 0) {
            path.append('\'').append(name).append('\'');
        } else if ((cat & 8) != 0) {
            path.append('\"').append(name).append('\"');
        } else if ((cat & 4) != 0) {
            path.append('\"');
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                String escape = StringOutputUtil.getBasicStringEscape(c);
                if (escape == null) {
                    path.append(c);
                    continue;
                }
                path.append(escape);
            }
            path.append('\"');
        } else {
            throw new TomlStreamWriteException("Key contains unsupported characters", (JsonGenerator)this);
        }
    }

    private void _writeStringImpl(int categoryMask, String name) throws IOException {
        int cat = StringOutputUtil.categorize(name) & categoryMask;
        if ((cat & 1) != 0) {
            this._writeRaw(name);
        } else if ((cat & 2) != 0) {
            this._writeRaw('\'');
            this._writeRaw(name);
            this._writeRaw('\'');
        } else if ((cat & 8) != 0) {
            this._writeRaw('\"');
            this._writeRaw(name);
            this._writeRaw('\"');
        } else if ((cat & 4) != 0) {
            this._writeRaw('\"');
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                String escape = StringOutputUtil.getBasicStringEscape(c);
                if (escape == null) {
                    this._writeRaw(c);
                    continue;
                }
                this._writeRaw(escape);
            }
            this._writeRaw('\"');
        } else {
            throw new TomlStreamWriteException("Key contains unsupported characters", (JsonGenerator)this);
        }
    }

    private void _writeStringImpl(int categoryMask, char[] text, int offset, int len) throws IOException {
        int cat = StringOutputUtil.categorize(text, offset, len) & categoryMask;
        if ((cat & 1) != 0) {
            this._writeRaw(text, offset, len);
        } else if ((cat & 2) != 0) {
            this._writeRaw('\'');
            this._writeRaw(text, offset, len);
            this._writeRaw('\'');
        } else if ((cat & 8) != 0) {
            this._writeRaw('\"');
            this._writeRaw(text, offset, len);
            this._writeRaw('\"');
        } else if ((cat & 4) != 0) {
            this._writeRaw('\"');
            for (int i = 0; i < len; ++i) {
                char c = text[offset + len];
                String escape = StringOutputUtil.getBasicStringEscape(c);
                if (escape == null) {
                    this._writeRaw(c);
                    continue;
                }
                this._writeRaw(escape);
            }
            this._writeRaw('\"');
        } else {
            throw new TomlStreamWriteException("Key contains unsupported characters", (JsonGenerator)this);
        }
    }

    public void writeObject(Object value) throws IOException {
        if (value == null) {
            this.writeNull();
        } else if (value instanceof LocalDate || value instanceof LocalTime || value instanceof LocalDateTime || value instanceof OffsetDateTime) {
            this._verifyValueWrite("write local date");
            this._writeRaw(value.toString());
            this.writeValueEnd();
        } else {
            this._objectCodec.writeValue((JsonGenerator)this, value);
        }
    }
}

