/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.smile;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.fasterxml.jackson.dataformat.smile.PackageVersion;
import com.fasterxml.jackson.dataformat.smile.SmileBufferRecycler;
import com.fasterxml.jackson.dataformat.smile.SmileConstants;
import com.fasterxml.jackson.dataformat.smile.SmileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class SmileParser
extends ParserBase {
    private static final int[] NO_INTS = new int[0];
    private static final String[] NO_STRINGS = new String[0];
    protected ObjectCodec _objectCodec;
    protected boolean _mayContainRawBinary;
    protected final SmileBufferRecycler<String> _smileBufferRecycler;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected int _formatFeatures;
    protected boolean _bufferRecyclable;
    protected boolean _tokenIncomplete = false;
    protected int _typeAsInt;
    protected boolean _got32BitFloat;
    protected int _tokenOffsetForTotal;
    protected final ByteQuadsCanonicalizer _symbols;
    protected int[] _quadBuffer = NO_INTS;
    protected int _quad1;
    protected int _quad2;
    protected int _quad3;
    protected String[] _seenNames = NO_STRINGS;
    protected int _seenNameCount = 0;
    protected String[] _seenStringValues = null;
    protected int _seenStringValueCount = -1;
    protected static final ThreadLocal<SoftReference<SmileBufferRecycler<String>>> _smileRecyclerRef = new ThreadLocal();

    public SmileParser(IOContext ctxt, int parserFeatures, int smileFeatures, ObjectCodec codec, ByteQuadsCanonicalizer sym, InputStream in, byte[] inputBuffer, int start, int end, boolean bufferRecyclable) {
        super(ctxt, parserFeatures);
        this._objectCodec = codec;
        this._symbols = sym;
        this._formatFeatures = smileFeatures;
        this._inputStream = in;
        this._inputBuffer = inputBuffer;
        this._inputPtr = start;
        this._inputEnd = end;
        this._bufferRecyclable = bufferRecyclable;
        this._tokenInputRow = -1;
        this._tokenInputCol = -1;
        this._smileBufferRecycler = SmileParser._smileBufferRecycler();
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    protected boolean handleSignature(boolean consumeFirstByte, boolean throwException) throws IOException {
        byte ch;
        int versionBits;
        if (consumeFirstByte) {
            ++this._inputPtr;
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (this._inputBuffer[this._inputPtr] != 41) {
            if (throwException) {
                this._reportError("Malformed content: signature not valid, starts with 0x3a but followed by 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr]) + ", not 0x29");
            }
            return false;
        }
        if (++this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (this._inputBuffer[this._inputPtr] != 10) {
            if (throwException) {
                this._reportError("Malformed content: signature not valid, starts with 0x3a, 0x29, but followed by 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr]) + ", not 0xA");
            }
            return false;
        }
        if (++this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((versionBits = (ch = this._inputBuffer[this._inputPtr++]) >> 4 & 0xF) != 0) {
            this._reportError("Header version number bits (0x" + Integer.toHexString(versionBits) + ") indicate unrecognized version; only 0x0 handled by parser");
        }
        if ((ch & 1) == 0) {
            this._seenNames = null;
            this._seenNameCount = -1;
        }
        if ((ch & 2) != 0) {
            this._seenStringValues = NO_STRINGS;
            this._seenStringValueCount = 0;
        }
        this._mayContainRawBinary = (ch & 4) != 0;
        return true;
    }

    protected static final SmileBufferRecycler<String> _smileBufferRecycler() {
        SmileBufferRecycler<String> br;
        SoftReference<SmileBufferRecycler<String>> ref = _smileRecyclerRef.get();
        SmileBufferRecycler<String> smileBufferRecycler = br = ref == null ? null : ref.get();
        if (br == null) {
            br = new SmileBufferRecycler();
            _smileRecyclerRef.set(new SoftReference<SmileBufferRecycler<String>>(br));
        }
        return br;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    public JsonParser overrideFormatFeatures(int values, int mask) {
        this._formatFeatures = this._formatFeatures & ~mask | values & mask;
        return this;
    }

    public int releaseBuffered(OutputStream out) throws IOException {
        int count = this._inputEnd - this._inputPtr;
        if (count < 1) {
            return 0;
        }
        int origPtr = this._inputPtr;
        out.write(this._inputBuffer, origPtr, count);
        return count;
    }

    public Object getInputSource() {
        return this._inputStream;
    }

    public JsonLocation getTokenLocation() {
        long total = this._currInputProcessed + (long)this._tokenOffsetForTotal;
        return new JsonLocation(this._ioContext.getSourceReference(), total, -1L, -1, (int)total);
    }

    public JsonLocation getCurrentLocation() {
        long offset = this._currInputProcessed + (long)this._inputPtr;
        return new JsonLocation(this._ioContext.getSourceReference(), offset, -1L, -1, (int)offset);
    }

    protected final boolean loadMore() throws IOException {
        if (this._inputStream != null) {
            int count = this._inputStream.read(this._inputBuffer, 0, this._inputBuffer.length);
            this._currInputProcessed += (long)this._inputEnd;
            this._inputPtr = 0;
            if (count > 0) {
                this._inputEnd = count;
                return true;
            }
            this._inputEnd = 0;
            this._closeInput();
            if (count == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    protected final void _loadToHaveAtLeast(int minAvailable) throws IOException {
        if (this._inputStream == null) {
            throw this._constructError("Needed to read " + minAvailable + " bytes, reached end-of-input");
        }
        int amount = this._inputEnd - this._inputPtr;
        this._currInputProcessed += (long)this._inputPtr;
        if (amount > 0 && this._inputPtr > 0) {
            System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, amount);
            this._inputEnd = amount;
        } else {
            this._inputEnd = 0;
        }
        this._inputPtr = 0;
        while (this._inputEnd < minAvailable) {
            int count = this._inputStream.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (count < 1) {
                this._closeInput();
                if (count == 0) {
                    throw new IOException("InputStream.read() returned 0 characters when trying to read " + amount + " bytes");
                }
                throw this._constructError("Needed to read " + minAvailable + " bytes, missed " + minAvailable + " before end-of-input");
            }
            this._inputEnd += count;
        }
    }

    protected void _closeInput() throws IOException {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    protected void _finishString() throws IOException {
        this._throwInternal();
    }

    public void close() throws IOException {
        super.close();
        this._symbols.release();
    }

    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.hasTextAsCharacters();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    protected void _releaseBuffers() throws IOException {
        Object[] valueBuf;
        Object[] nameBuf;
        byte[] buf;
        super._releaseBuffers();
        if (this._bufferRecyclable && (buf = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer(buf);
        }
        if ((nameBuf = this._seenNames) != null && nameBuf.length > 0) {
            this._seenNames = null;
            if (this._seenNameCount > 0) {
                Arrays.fill(nameBuf, 0, this._seenNameCount, null);
            }
            this._smileBufferRecycler.releaseSeenNamesBuffer((String[])nameBuf);
        }
        if ((valueBuf = this._seenStringValues) != null && valueBuf.length > 0) {
            this._seenStringValues = null;
            if (this._seenStringValueCount > 0) {
                Arrays.fill(valueBuf, 0, this._seenStringValueCount, null);
            }
            this._smileBufferRecycler.releaseSeenStringValuesBuffer((String[])valueBuf);
        }
    }

    public boolean mayContainRawBinary() {
        return this._mayContainRawBinary;
    }

    public JsonToken nextToken() throws IOException {
        int ch;
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipIncomplete();
        }
        this._tokenOffsetForTotal = this._inputPtr;
        this._binaryValue = null;
        if (this._currToken != JsonToken.FIELD_NAME && this._parsingContext.inObject()) {
            this._currToken = this._handleFieldName();
            return this._currToken;
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return this._eofAsNextToken();
        }
        this._typeAsInt = ch = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (ch >> 5) {
            case 0: {
                if (ch == 0) break;
                return this._handleSharedString(ch - 1);
            }
            case 1: {
                int typeBits = ch & 0x1F;
                if (typeBits < 4) {
                    switch (typeBits) {
                        case 0: {
                            this._textBuffer.resetWithEmpty();
                            this._currToken = JsonToken.VALUE_STRING;
                            return this._currToken;
                        }
                        case 1: {
                            this._currToken = JsonToken.VALUE_NULL;
                            return this._currToken;
                        }
                        case 2: {
                            this._currToken = JsonToken.VALUE_FALSE;
                            return this._currToken;
                        }
                    }
                    this._currToken = JsonToken.VALUE_TRUE;
                    return this._currToken;
                }
                if (typeBits == 4) {
                    this._finishInt();
                    this._currToken = JsonToken.VALUE_NUMBER_INT;
                    return this._currToken;
                }
                if (typeBits <= 6) {
                    this._tokenIncomplete = true;
                    this._currToken = JsonToken.VALUE_NUMBER_INT;
                    return this._currToken;
                }
                if (typeBits < 11 && typeBits != 7) {
                    this._got32BitFloat = typeBits == 8;
                    this._tokenIncomplete = true;
                    this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
                    return this._currToken;
                }
                if (typeBits != 26) break;
                if (this.handleSignature(false, false)) {
                    if (this._currToken == null) {
                        return this.nextToken();
                    }
                    this._currToken = null;
                    return null;
                }
                this._reportError("Unrecognized token byte 0x3A (malformed segment header?");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this._seenStringValueCount >= 0) {
                    return this._addSeenStringValue();
                }
                this._tokenIncomplete = true;
                this._currToken = JsonToken.VALUE_STRING;
                return this._currToken;
            }
            case 6: {
                this._numberInt = SmileUtil.zigzagDecode(ch & 0x1F);
                this._numTypesValid = 1;
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return this._currToken;
            }
            case 7: {
                switch (ch & 0x1F) {
                    case 0: 
                    case 4: {
                        this._tokenIncomplete = true;
                        this._currToken = JsonToken.VALUE_STRING;
                        return this._currToken;
                    }
                    case 8: {
                        this._tokenIncomplete = true;
                        this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                        return this._currToken;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        return this._handleSharedString(((ch & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF));
                    }
                    case 24: {
                        this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
                        this._currToken = JsonToken.START_ARRAY;
                        return this._currToken;
                    }
                    case 25: {
                        if (!this._parsingContext.inArray()) {
                            this._reportMismatchedEndMarker(93, '}');
                        }
                        this._parsingContext = this._parsingContext.getParent();
                        this._currToken = JsonToken.END_ARRAY;
                        return this._currToken;
                    }
                    case 26: {
                        this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                        this._currToken = JsonToken.START_OBJECT;
                        return this._currToken;
                    }
                    case 27: {
                        this._reportError("Invalid type marker byte 0xFB in value mode (would be END_OBJECT in key mode)");
                    }
                    case 29: {
                        this._tokenIncomplete = true;
                        this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                        return this._currToken;
                    }
                    case 31: {
                        this._currToken = null;
                        return null;
                    }
                }
            }
        }
        this._reportError("Invalid type marker byte 0x" + Integer.toHexString(ch & 0xFF) + " for expected value token");
        return null;
    }

    private final JsonToken _handleSharedString(int index) throws IOException {
        if (index >= this._seenStringValueCount) {
            this._reportInvalidSharedStringValue(index);
        }
        this._textBuffer.resetWithString(this._seenStringValues[index]);
        this._currToken = JsonToken.VALUE_STRING;
        return this._currToken;
    }

    private final JsonToken _addSeenStringValue() throws IOException {
        this._finishToken();
        String v = this._textBuffer.contentsAsString();
        if (this._seenStringValueCount < this._seenStringValues.length) {
            this._seenStringValues[this._seenStringValueCount++] = v;
        } else {
            this._expandSeenStringValues(v);
        }
        this._currToken = JsonToken.VALUE_STRING;
        return this._currToken;
    }

    private final void _expandSeenStringValues(String newText) {
        String[] newShared;
        String[] oldShared = this._seenStringValues;
        int len = oldShared.length;
        if (len == 0) {
            newShared = this._smileBufferRecycler.allocSeenStringValuesBuffer();
            if (newShared == null) {
                newShared = new String[64];
            }
        } else if (len == 1024) {
            newShared = oldShared;
            this._seenStringValueCount = 0;
        } else {
            int newSize = len == 64 ? 256 : 1024;
            newShared = Arrays.copyOf(oldShared, newSize);
        }
        this._seenStringValues = newShared;
        this._seenStringValues[this._seenStringValueCount++] = newText;
    }

    public JsonParser.NumberType getNumberType() throws IOException {
        if (this._got32BitFloat && this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return JsonParser.NumberType.FLOAT;
        }
        return super.getNumberType();
    }

    public boolean nextFieldName(SerializableString str) throws IOException {
        if (this._currToken != JsonToken.FIELD_NAME && this._parsingContext.inObject()) {
            this._numTypesValid = 0;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            this._tokenOffsetForTotal = this._inputPtr;
            this._binaryValue = null;
            byte[] nameBytes = str.asQuotedUTF8();
            int byteLen = nameBytes.length;
            if (this._inputPtr + byteLen + 1 < this._inputEnd) {
                int ch;
                int ptr = this._inputPtr;
                this._typeAsInt = ch = this._inputBuffer[ptr++] & 0xFF;
                block0 : switch (ch >> 6) {
                    case 0: {
                        switch (ch) {
                            case 32: {
                                this._currToken = JsonToken.FIELD_NAME;
                                this._inputPtr = ptr;
                                this._parsingContext.setCurrentName("");
                                return byteLen == 0;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: {
                                int index = ((ch & 3) << 8) + (this._inputBuffer[ptr++] & 0xFF);
                                if (index >= this._seenNameCount) {
                                    this._reportInvalidSharedName(index);
                                }
                                String name = this._seenNames[index];
                                this._parsingContext.setCurrentName(name);
                                this._inputPtr = ptr;
                                this._currToken = JsonToken.FIELD_NAME;
                                return name.equals(str.getValue());
                            }
                        }
                        break;
                    }
                    case 1: {
                        int index = ch & 0x3F;
                        if (index >= this._seenNameCount) {
                            this._reportInvalidSharedName(index);
                        }
                        this._parsingContext.setCurrentName(this._seenNames[index]);
                        String name = this._seenNames[index];
                        this._parsingContext.setCurrentName(name);
                        this._inputPtr = ptr;
                        this._currToken = JsonToken.FIELD_NAME;
                        return name.equals(str.getValue());
                    }
                    case 2: {
                        int len = 1 + (ch & 0x3F);
                        if (len != byteLen) break;
                        for (int i = 0; i < len; ++i) {
                            if (nameBytes[i] != this._inputBuffer[ptr + i]) break block0;
                        }
                        this._inputPtr = ptr + len;
                        String name = str.getValue();
                        if (this._seenNames != null) {
                            if (this._seenNameCount >= this._seenNames.length) {
                                this._seenNames = this._expandSeenNames(this._seenNames);
                            }
                            this._seenNames[this._seenNameCount++] = name;
                        }
                        this._parsingContext.setCurrentName(name);
                        this._currToken = JsonToken.FIELD_NAME;
                        return true;
                    }
                    case 3: {
                        int len = ch & 0x3F;
                        if (len > 55) {
                            if (len != 59) break;
                            this._currToken = JsonToken.END_OBJECT;
                            if (!this._parsingContext.inObject()) {
                                this._reportMismatchedEndMarker(125, ']');
                            }
                            this._inputPtr = ptr;
                            this._parsingContext = this._parsingContext.getParent();
                            return false;
                        }
                        if ((len += 2) != byteLen) break;
                        for (int i = 0; i < len; ++i) {
                            if (nameBytes[i] != this._inputBuffer[ptr + i]) break block0;
                        }
                        this._inputPtr = ptr + len;
                        String name = str.getValue();
                        if (this._seenNames != null) {
                            if (this._seenNameCount >= this._seenNames.length) {
                                this._seenNames = this._expandSeenNames(this._seenNames);
                            }
                            this._seenNames[this._seenNameCount++] = name;
                        }
                        this._parsingContext.setCurrentName(name);
                        this._currToken = JsonToken.FIELD_NAME;
                        return true;
                    }
                }
            }
        }
        return this.nextToken() == JsonToken.FIELD_NAME && str.getValue().equals(this.getCurrentName());
    }

    public String nextFieldName() throws IOException {
        if (this._currToken != JsonToken.FIELD_NAME && this._parsingContext.inObject()) {
            int ch;
            this._numTypesValid = 0;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            this._tokenOffsetForTotal = this._inputPtr;
            this._binaryValue = null;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            this._typeAsInt = ch = this._inputBuffer[this._inputPtr++] & 0xFF;
            switch (ch >> 6) {
                case 0: {
                    switch (ch) {
                        case 32: {
                            this._parsingContext.setCurrentName("");
                            return "";
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: {
                            int index;
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((index = ((ch & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF)) >= this._seenNameCount) {
                                this._reportInvalidSharedName(index);
                            }
                            String name = this._seenNames[index];
                            this._parsingContext.setCurrentName(name);
                            this._currToken = JsonToken.FIELD_NAME;
                            return name;
                        }
                        case 52: {
                            this._handleLongFieldName();
                            return this.getCurrentName();
                        }
                    }
                    break;
                }
                case 1: {
                    int index = ch & 0x3F;
                    if (index >= this._seenNameCount) {
                        this._reportInvalidSharedName(index);
                    }
                    String name = this._seenNames[index];
                    this._parsingContext.setCurrentName(name);
                    this._currToken = JsonToken.FIELD_NAME;
                    return name;
                }
                case 2: {
                    int len = 1 + (ch & 0x3F);
                    String name = this._findDecodedFromSymbols(len);
                    if (name != null) {
                        this._inputPtr += len;
                    } else {
                        name = this._decodeShortAsciiName(len);
                        name = this._addDecodedToSymbols(len, name);
                    }
                    if (this._seenNames != null) {
                        if (this._seenNameCount >= this._seenNames.length) {
                            this._seenNames = this._expandSeenNames(this._seenNames);
                        }
                        this._seenNames[this._seenNameCount++] = name;
                    }
                    this._parsingContext.setCurrentName(name);
                    this._currToken = JsonToken.FIELD_NAME;
                    return name;
                }
                case 3: {
                    if ((ch &= 0x3F) > 55) {
                        if (ch != 59) break;
                        if (!this._parsingContext.inObject()) {
                            this._reportMismatchedEndMarker(125, ']');
                        }
                        this._parsingContext = this._parsingContext.getParent();
                        this._currToken = JsonToken.END_OBJECT;
                        return null;
                    }
                    int len = ch + 2;
                    String name = this._findDecodedFromSymbols(len);
                    if (name != null) {
                        this._inputPtr += len;
                    } else {
                        name = this._decodeShortUnicodeName(len);
                        name = this._addDecodedToSymbols(len, name);
                    }
                    if (this._seenNames != null) {
                        if (this._seenNameCount >= this._seenNames.length) {
                            this._seenNames = this._expandSeenNames(this._seenNames);
                        }
                        this._seenNames[this._seenNameCount++] = name;
                    }
                    this._parsingContext.setCurrentName(name);
                    this._currToken = JsonToken.FIELD_NAME;
                    return name;
                }
            }
            this._reportError("Invalid type marker byte 0x" + Integer.toHexString(this._typeAsInt) + " for expected field name (or END_OBJECT marker)");
            return null;
        }
        return this.nextToken() == JsonToken.FIELD_NAME ? this.getCurrentName() : null;
    }

    public String nextTextValue() throws IOException {
        if (!this._parsingContext.inObject() || this._currToken == JsonToken.FIELD_NAME) {
            int ch;
            int ptr;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            if ((ptr = this._inputPtr) >= this._inputEnd) {
                if (!this.loadMore()) {
                    this._eofAsNextToken();
                    return null;
                }
                ptr = this._inputPtr;
            }
            this._tokenOffsetForTotal = ptr;
            this._typeAsInt = ch = this._inputBuffer[ptr++] & 0xFF;
            this._binaryValue = null;
            switch (ch >> 5) {
                case 0: {
                    if (ch != 0) {
                        if (--ch >= this._seenStringValueCount) {
                            this._reportInvalidSharedStringValue(ch);
                        }
                        this._inputPtr = ptr;
                        String text = this._seenStringValues[ch];
                        this._textBuffer.resetWithString(text);
                        this._currToken = JsonToken.VALUE_STRING;
                        return text;
                    }
                    this._reportError("Invalid token byte 0x00");
                }
                case 1: {
                    int typeBits = ch & 0x1F;
                    if (typeBits != 0) break;
                    this._inputPtr = ptr;
                    this._textBuffer.resetWithEmpty();
                    this._currToken = JsonToken.VALUE_STRING;
                    return "";
                }
                case 2: 
                case 3: {
                    this._currToken = JsonToken.VALUE_STRING;
                    this._inputPtr = ptr;
                    String text = this._decodeShortAsciiValue(1 + (ch & 0x3F));
                    if (this._seenStringValueCount >= 0) {
                        if (this._seenStringValueCount < this._seenStringValues.length) {
                            this._seenStringValues[this._seenStringValueCount++] = text;
                        } else {
                            this._expandSeenStringValues(text);
                        }
                    }
                    return text;
                }
                case 4: 
                case 5: {
                    this._currToken = JsonToken.VALUE_STRING;
                    this._inputPtr = ptr;
                    String text = this._decodeShortUnicodeValue(2 + (ch & 0x3F));
                    if (this._seenStringValueCount >= 0) {
                        if (this._seenStringValueCount < this._seenStringValues.length) {
                            this._seenStringValues[this._seenStringValueCount++] = text;
                        } else {
                            this._expandSeenStringValues(text);
                        }
                    }
                    return text;
                }
                case 6: {
                    break;
                }
            }
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    public int nextIntValue(int defaultValue) throws IOException {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getIntValue();
        }
        return defaultValue;
    }

    public long nextLongValue(long defaultValue) throws IOException {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getLongValue();
        }
        return defaultValue;
    }

    public Boolean nextBooleanValue() throws IOException {
        switch (this.nextToken()) {
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public String getText() throws IOException {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            int tb = this._typeAsInt;
            int type = tb >> 5;
            if (type == 2 || type == 3) {
                return this._decodeShortAsciiValue(1 + (tb & 0x3F));
            }
            if (type == 4 || type == 5) {
                return this._decodeShortUnicodeValue(2 + (tb & 0x3F));
            }
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        JsonToken t = this._currToken;
        if (t == null) {
            return null;
        }
        if (t == JsonToken.FIELD_NAME) {
            return this._parsingContext.getCurrentName();
        }
        if (t.isNumeric()) {
            return this.getNumberValue().toString();
        }
        return this._currToken.asString();
    }

    public char[] getTextCharacters() throws IOException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            if (this._currToken == JsonToken.VALUE_STRING) {
                return this._textBuffer.getTextBuffer();
            }
            if (this._currToken == JsonToken.FIELD_NAME) {
                if (!this._nameCopied) {
                    String name = this._parsingContext.getCurrentName();
                    int nameLen = name.length();
                    if (this._nameCopyBuffer == null) {
                        this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(nameLen);
                    } else if (this._nameCopyBuffer.length < nameLen) {
                        this._nameCopyBuffer = new char[nameLen];
                    }
                    name.getChars(0, nameLen, this._nameCopyBuffer, 0);
                    this._nameCopied = true;
                }
                return this._nameCopyBuffer;
            }
            if (this._currToken.isNumeric()) {
                return this.getNumberValue().toString().toCharArray();
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    public int getTextLength() throws IOException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            if (this._currToken == JsonToken.VALUE_STRING) {
                return this._textBuffer.size();
            }
            switch (this._currToken) {
                case FIELD_NAME: {
                    return this._parsingContext.getCurrentName().length();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getNumberValue().toString().length();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    public int getTextOffset() throws IOException {
        return 0;
    }

    public String getValueAsString() throws IOException {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            int tb = this._typeAsInt;
            int type = tb >> 5;
            if (type == 2 || type == 3) {
                return this._decodeShortAsciiValue(1 + (tb & 0x3F));
            }
            if (type == 4 || type == 5) {
                return this._decodeShortUnicodeValue(2 + (tb & 0x3F));
            }
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
            return null;
        }
        return this.getText();
    }

    public String getValueAsString(String defaultValue) throws IOException {
        if (!(this._currToken == JsonToken.VALUE_STRING || this._currToken != null && this._currToken != JsonToken.VALUE_NULL && this._currToken.isScalarValue())) {
            return defaultValue;
        }
        return this.getText();
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + this._currToken + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        return this._binaryValue;
    }

    public Object getEmbeddedObject() throws IOException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBinaryValue(Base64Variant b64variant, OutputStream out) throws IOException {
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + this._currToken + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (!this._tokenIncomplete) {
            if (this._binaryValue == null) {
                return 0;
            }
            int len = this._binaryValue.length;
            out.write(this._binaryValue, 0, len);
            return len;
        }
        if (this._typeAsInt == 253) {
            int totalCount;
            int count;
            for (int left = totalCount = this._readUnsignedVInt(); left > 0; left -= count) {
                int avail = this._inputEnd - this._inputPtr;
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    avail = this._inputEnd - this._inputPtr;
                }
                count = Math.min(avail, left);
                out.write(this._inputBuffer, this._inputPtr, count);
                this._inputPtr += count;
            }
            this._tokenIncomplete = false;
            return totalCount;
        }
        if (this._typeAsInt != 232) {
            this._throwInternal();
        }
        int totalCount = this._readUnsignedVInt();
        byte[] encodingBuffer = this._ioContext.allocBase64Buffer();
        try {
            this._readBinaryEncoded(out, totalCount, encodingBuffer);
        }
        finally {
            this._ioContext.releaseBase64Buffer(encodingBuffer);
        }
        this._tokenIncomplete = false;
        return totalCount;
    }

    private void _readBinaryEncoded(OutputStream out, int length, byte[] buffer) throws IOException {
        int outPtr = 0;
        int lastSafeOut = buffer.length - 7;
        while (length > 7) {
            if (this._inputEnd - this._inputPtr < 8) {
                this._loadToHaveAtLeast(8);
            }
            int i1 = (this._inputBuffer[this._inputPtr++] << 25) + (this._inputBuffer[this._inputPtr++] << 18) + (this._inputBuffer[this._inputPtr++] << 11) + (this._inputBuffer[this._inputPtr++] << 4);
            byte x = this._inputBuffer[this._inputPtr++];
            int i2 = ((x & 7) << 21) + (this._inputBuffer[this._inputPtr++] << 14) + (this._inputBuffer[this._inputPtr++] << 7) + this._inputBuffer[this._inputPtr++];
            buffer[outPtr++] = (byte)((i1 += x >> 3) >> 24);
            buffer[outPtr++] = (byte)(i1 >> 16);
            buffer[outPtr++] = (byte)(i1 >> 8);
            buffer[outPtr++] = (byte)i1;
            buffer[outPtr++] = (byte)(i2 >> 16);
            buffer[outPtr++] = (byte)(i2 >> 8);
            buffer[outPtr++] = (byte)i2;
            length -= 7;
            if (outPtr <= lastSafeOut) continue;
            out.write(buffer, 0, outPtr);
            outPtr = 0;
        }
        if (length > 0) {
            if (this._inputEnd - this._inputPtr < length + 1) {
                this._loadToHaveAtLeast(length + 1);
            }
            int value = this._inputBuffer[this._inputPtr++];
            for (int i = 1; i < length; ++i) {
                value = (value << 7) + this._inputBuffer[this._inputPtr++];
                buffer[outPtr++] = (byte)(value >> 7 - i);
            }
            buffer[outPtr++] = (byte)((value <<= length) + this._inputBuffer[this._inputPtr++]);
        }
        if (outPtr > 0) {
            out.write(buffer, 0, outPtr);
        }
    }

    protected final JsonToken _handleFieldName() throws IOException {
        int ch;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        this._typeAsInt = ch = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (ch >> 6) {
            case 0: {
                switch (ch) {
                    case 32: {
                        this._parsingContext.setCurrentName("");
                        return JsonToken.FIELD_NAME;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        int index;
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((index = ((ch & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF)) >= this._seenNameCount) {
                            this._reportInvalidSharedName(index);
                        }
                        this._parsingContext.setCurrentName(this._seenNames[index]);
                        return JsonToken.FIELD_NAME;
                    }
                    case 52: {
                        this._handleLongFieldName();
                        return JsonToken.FIELD_NAME;
                    }
                }
                break;
            }
            case 1: {
                int index = ch & 0x3F;
                if (index >= this._seenNameCount) {
                    this._reportInvalidSharedName(index);
                }
                this._parsingContext.setCurrentName(this._seenNames[index]);
                return JsonToken.FIELD_NAME;
            }
            case 2: {
                int len = 1 + (ch & 0x3F);
                String name = this._findDecodedFromSymbols(len);
                if (name != null) {
                    this._inputPtr += len;
                } else {
                    name = this._decodeShortAsciiName(len);
                    name = this._addDecodedToSymbols(len, name);
                }
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = name;
                }
                this._parsingContext.setCurrentName(name);
                return JsonToken.FIELD_NAME;
            }
            case 3: {
                if ((ch &= 0x3F) > 55) {
                    if (ch != 59) break;
                    if (!this._parsingContext.inObject()) {
                        this._reportMismatchedEndMarker(125, ']');
                    }
                    this._parsingContext = this._parsingContext.getParent();
                    return JsonToken.END_OBJECT;
                }
                int len = ch + 2;
                String name = this._findDecodedFromSymbols(len);
                if (name != null) {
                    this._inputPtr += len;
                } else {
                    name = this._decodeShortUnicodeName(len);
                    name = this._addDecodedToSymbols(len, name);
                }
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = name;
                }
                this._parsingContext.setCurrentName(name);
                return JsonToken.FIELD_NAME;
            }
        }
        this._reportError("Invalid type marker byte 0x" + Integer.toHexString(this._typeAsInt) + " for expected field name (or END_OBJECT marker)");
        return null;
    }

    private final String[] _expandSeenNames(String[] oldShared) {
        String[] newShared;
        int len = oldShared.length;
        if (len == 0) {
            newShared = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (newShared == null) {
                newShared = new String[64];
            }
        } else if (len == 1024) {
            newShared = oldShared;
            this._seenNameCount = 0;
        } else {
            int newSize = len == 64 ? 256 : 1024;
            newShared = Arrays.copyOf(oldShared, newSize);
        }
        return newShared;
    }

    private final String _addDecodedToSymbols(int len, String name) {
        if (len < 5) {
            return this._symbols.addName(name, this._quad1);
        }
        if (len < 9) {
            return this._symbols.addName(name, this._quad1, this._quad2);
        }
        if (len < 13) {
            return this._symbols.addName(name, this._quad1, this._quad2, this._quad3);
        }
        int qlen = len + 3 >> 2;
        return this._symbols.addName(name, this._quadBuffer, qlen);
    }

    private final String _decodeShortAsciiName(int len) throws IOException {
        int inPtr;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        byte[] inBuf = this._inputBuffer;
        int inEnd = inPtr + len;
        for (inPtr = this._inputPtr; inPtr < inEnd; ++inPtr) {
            outBuf[outPtr++] = (char)inBuf[inPtr];
        }
        this._inputPtr = inPtr;
        return this._textBuffer.setCurrentAndReturn(len);
    }

    private final String _decodeShortUnicodeName(int len) throws IOException {
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int inPtr = this._inputPtr;
        this._inputPtr += len;
        int[] codes = SmileConstants.sUtf8UnitLengths;
        byte[] inBuf = this._inputBuffer;
        int end = inPtr + len;
        while (inPtr < end) {
            int i;
            int code;
            if ((code = codes[i = inBuf[inPtr++] & 0xFF]) != 0) {
                switch (code) {
                    case 1: {
                        i = (i & 0x1F) << 6 | inBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 2: {
                        i = (i & 0xF) << 12 | (inBuf[inPtr++] & 0x3F) << 6 | inBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 3: {
                        i = (i & 7) << 18 | (inBuf[inPtr++] & 0x3F) << 12 | (inBuf[inPtr++] & 0x3F) << 6 | inBuf[inPtr++] & 0x3F;
                        outBuf[outPtr++] = (char)(0xD800 | (i -= 65536) >> 10);
                        i = 0xDC00 | i & 0x3FF;
                        break;
                    }
                    default: {
                        this._reportError("Invalid byte " + Integer.toHexString(i) + " in short Unicode text block");
                    }
                }
            }
            outBuf[outPtr++] = (char)i;
        }
        return this._textBuffer.setCurrentAndReturn(outPtr);
    }

    private final String _decodeLongUnicodeName(int[] quads, int byteLen, int quadLen) throws IOException {
        int lastQuad;
        int lastQuadBytes = byteLen & 3;
        if (lastQuadBytes < 4) {
            lastQuad = quads[quadLen - 1];
            quads[quadLen - 1] = lastQuad << (4 - lastQuadBytes << 3);
        } else {
            lastQuad = 0;
        }
        char[] cbuf = this._textBuffer.emptyAndGetCurrentSegment();
        int cix = 0;
        int ix = 0;
        while (ix < byteLen) {
            int ch = quads[ix >> 2];
            int byteIx = ix & 3;
            ch = ch >> (3 - byteIx << 3) & 0xFF;
            ++ix;
            if (ch > 127) {
                int needed;
                if ((ch & 0xE0) == 192) {
                    ch &= 0x1F;
                    needed = 1;
                } else if ((ch & 0xF0) == 224) {
                    ch &= 0xF;
                    needed = 2;
                } else if ((ch & 0xF8) == 240) {
                    ch &= 7;
                    needed = 3;
                } else {
                    this._reportInvalidInitial(ch);
                    ch = 1;
                    needed = 1;
                }
                if (ix + needed > byteLen) {
                    this._reportInvalidEOF(" in long field name");
                }
                int ch2 = quads[ix >> 2];
                byteIx = ix & 3;
                ++ix;
                if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(ch2);
                }
                ch = ch << 6 | ch2 & 0x3F;
                if (needed > 1) {
                    ch2 = quads[ix >> 2];
                    byteIx = ix & 3;
                    ++ix;
                    if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(ch2);
                    }
                    ch = ch << 6 | ch2 & 0x3F;
                    if (needed > 2) {
                        ch2 = quads[ix >> 2];
                        byteIx = ix & 3;
                        ++ix;
                        if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(ch2 & 0xFF);
                        }
                        ch = ch << 6 | ch2 & 0x3F;
                    }
                }
                if (needed > 2) {
                    ch -= 65536;
                    if (cix >= cbuf.length) {
                        cbuf = this._textBuffer.expandCurrentSegment();
                    }
                    cbuf[cix++] = (char)(55296 + (ch >> 10));
                    ch = 0xDC00 | ch & 0x3FF;
                }
            }
            if (cix >= cbuf.length) {
                cbuf = this._textBuffer.expandCurrentSegment();
            }
            cbuf[cix++] = (char)ch;
        }
        String baseName = new String(cbuf, 0, cix);
        if (lastQuadBytes < 4) {
            quads[quadLen - 1] = lastQuad;
        }
        return this._symbols.addName(baseName, quads, quadLen);
    }

    private final void _handleLongFieldName() throws IOException {
        String name;
        byte[] inBuf = this._inputBuffer;
        int quads = 0;
        int bytes = 0;
        int q = 0;
        while (true) {
            byte b;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 0;
                break;
            }
            q = b & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 1;
                break;
            }
            q = q << 8 | b & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 2;
                break;
            }
            q = q << 8 | b & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 3;
                break;
            }
            q = q << 8 | b & 0xFF;
            if (quads >= this._quadBuffer.length) {
                this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            this._quadBuffer[quads++] = q;
        }
        int byteLen = quads << 2;
        if (bytes > 0) {
            if (quads >= this._quadBuffer.length) {
                this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            this._quadBuffer[quads++] = q;
            byteLen += bytes;
        }
        if ((name = this._symbols.findName(this._quadBuffer, quads)) == null) {
            name = this._decodeLongUnicodeName(this._quadBuffer, byteLen, quads);
        }
        if (this._seenNames != null) {
            if (this._seenNameCount >= this._seenNames.length) {
                this._seenNames = this._expandSeenNames(this._seenNames);
            }
            this._seenNames[this._seenNameCount++] = name;
        }
        this._parsingContext.setCurrentName(name);
    }

    private final String _findDecodedFromSymbols(int len) throws IOException {
        if (this._inputEnd - this._inputPtr < len) {
            this._loadToHaveAtLeast(len);
        }
        if (len < 5) {
            int inPtr = this._inputPtr;
            byte[] inBuf = this._inputBuffer;
            int q = inBuf[inPtr] & 0xFF;
            if (len > 0) {
                q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                if (len > 1) {
                    q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                    if (len > 2) {
                        q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                    }
                }
            }
            this._quad1 = q;
            return this._symbols.findName(q);
        }
        byte[] inBuf = this._inputBuffer;
        int inPtr = this._inputPtr;
        int q1 = inBuf[inPtr++] & 0xFF;
        q1 = q1 << 8 | inBuf[inPtr++] & 0xFF;
        q1 = q1 << 8 | inBuf[inPtr++] & 0xFF;
        q1 = q1 << 8 | inBuf[inPtr++] & 0xFF;
        if (len < 9) {
            int q2 = inBuf[inPtr++] & 0xFF;
            int left = len - 5;
            if (left > 0) {
                q2 = (q2 << 8) + (inBuf[inPtr++] & 0xFF);
                if (left > 1) {
                    q2 = (q2 << 8) + (inBuf[inPtr++] & 0xFF);
                    if (left > 2) {
                        q2 = (q2 << 8) + (inBuf[inPtr++] & 0xFF);
                    }
                }
            }
            this._quad1 = q1;
            this._quad2 = q2;
            return this._symbols.findName(q1, q2);
        }
        int q2 = inBuf[inPtr++] & 0xFF;
        q2 = q2 << 8 | inBuf[inPtr++] & 0xFF;
        q2 = q2 << 8 | inBuf[inPtr++] & 0xFF;
        q2 = q2 << 8 | inBuf[inPtr++] & 0xFF;
        if (len < 13) {
            int q3 = inBuf[inPtr++] & 0xFF;
            int left = len - 9;
            if (left > 0) {
                q3 = (q3 << 8) + (inBuf[inPtr++] & 0xFF);
                if (left > 1) {
                    q3 = (q3 << 8) + (inBuf[inPtr++] & 0xFF);
                    if (left > 2) {
                        q3 = (q3 << 8) + (inBuf[inPtr++] & 0xFF);
                    }
                }
            }
            this._quad1 = q1;
            this._quad2 = q2;
            this._quad3 = q3;
            return this._symbols.findName(q1, q2, q3);
        }
        return this._findDecodedLong(len, q1, q2);
    }

    private final String _findDecodedLong(int len, int q1, int q2) throws IOException {
        int q;
        int bufLen = len + 3 >> 2;
        if (bufLen > this._quadBuffer.length) {
            this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, bufLen);
        }
        this._quadBuffer[0] = q1;
        this._quadBuffer[1] = q2;
        int offset = 2;
        int inPtr = this._inputPtr + 8;
        len -= 8;
        byte[] inBuf = this._inputBuffer;
        do {
            q = inBuf[inPtr++] & 0xFF;
            q = q << 8 | inBuf[inPtr++] & 0xFF;
            q = q << 8 | inBuf[inPtr++] & 0xFF;
            q = q << 8 | inBuf[inPtr++] & 0xFF;
            this._quadBuffer[offset++] = q;
        } while ((len -= 4) > 3);
        if (len > 0) {
            q = inBuf[inPtr] & 0xFF;
            if (len > 1) {
                q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                if (len > 2) {
                    q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                }
            }
            this._quadBuffer[offset++] = q;
        }
        return this._symbols.findName(this._quadBuffer, offset);
    }

    private static int[] _growArrayTo(int[] arr, int minSize) {
        int size = minSize + 4;
        if (arr == null) {
            return new int[size];
        }
        return Arrays.copyOf(arr, size);
    }

    protected void _parseNumericValue(int expType) throws IOException {
        if (this._tokenIncomplete) {
            int tb = this._typeAsInt;
            if (tb >> 5 != 1) {
                this._reportError("Current token (" + this._currToken + ") not numeric, can not use numeric value accessors");
            }
            this._tokenIncomplete = false;
            this._finishNumberToken(tb);
        }
    }

    protected int _parseIntValue() throws IOException {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            if ((this._typeAsInt & 0x1F) == 4) {
                this._finishInt();
                return this._numberInt;
            }
            this._finishNumberToken(this._typeAsInt);
        }
        if ((this._numTypesValid & 1) == 0) {
            this.convertNumberToInt();
        }
        return this._numberInt;
    }

    protected final void _finishToken() throws IOException {
        this._tokenIncomplete = false;
        int tb = this._typeAsInt;
        int type = tb >> 5;
        if (type == 1) {
            this._finishNumberToken(tb);
            return;
        }
        if (type <= 3) {
            this._decodeShortAsciiValue(1 + (tb & 0x3F));
            return;
        }
        if (type <= 5) {
            this._decodeShortUnicodeValue(2 + (tb & 0x3F));
            return;
        }
        if (type == 7) {
            switch ((tb &= 0x1F) >> 2) {
                case 0: {
                    this._decodeLongAscii();
                    return;
                }
                case 1: {
                    this._decodeLongUnicode();
                    return;
                }
                case 2: {
                    this._binaryValue = this._read7BitBinaryWithLength();
                    return;
                }
                case 7: {
                    this._finishRawBinary();
                    return;
                }
            }
        }
        this._throwInternal();
    }

    protected final void _finishNumberToken(int tb) throws IOException {
        switch (tb & 0x1F) {
            case 4: {
                this._finishInt();
                return;
            }
            case 5: {
                this._finishLong();
                return;
            }
            case 6: {
                this._finishBigInteger();
                return;
            }
            case 8: {
                this._finishFloat();
                return;
            }
            case 9: {
                this._finishDouble();
                return;
            }
            case 10: {
                this._finishBigDecimal();
                return;
            }
        }
        this._throwInternal();
    }

    private final void _finishInt() throws IOException {
        int value;
        int ptr = this._inputPtr;
        if (ptr + 5 >= this._inputEnd) {
            this._finishIntSlow();
            return;
        }
        if ((value = this._inputBuffer[ptr++]) < 0) {
            value &= 0x3F;
        } else {
            byte i;
            if ((i = this._inputBuffer[ptr++]) >= 0) {
                value = (value << 7) + i;
                if ((i = this._inputBuffer[ptr++]) >= 0) {
                    value = (value << 7) + i;
                    if ((i = this._inputBuffer[ptr++]) >= 0) {
                        value = (value << 7) + i;
                        if ((i = this._inputBuffer[ptr++]) >= 0) {
                            this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
                        }
                    }
                }
            }
            value = (value << 6) + (i & 0x3F);
        }
        this._inputPtr = ptr;
        this._numberInt = SmileUtil.zigzagDecode(value);
        this._numTypesValid = 1;
    }

    private final void _finishIntSlow() throws IOException {
        int value;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((value = this._inputBuffer[this._inputPtr++]) < 0) {
            value &= 0x3F;
        } else {
            byte i;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((i = this._inputBuffer[this._inputPtr++]) >= 0) {
                value = (value << 7) + i;
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((i = this._inputBuffer[this._inputPtr++]) >= 0) {
                    value = (value << 7) + i;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((i = this._inputBuffer[this._inputPtr++]) >= 0) {
                        value = (value << 7) + i;
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((i = this._inputBuffer[this._inputPtr++]) >= 0) {
                            this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
                        }
                    }
                }
            }
            value = (value << 6) + (i & 0x3F);
        }
        this._numberInt = SmileUtil.zigzagDecode(value);
        this._numTypesValid = 1;
    }

    private final void _finishLong() throws IOException {
        int ptr = this._inputPtr;
        int maxEnd = ptr + 11;
        if (maxEnd >= this._inputEnd) {
            this._finishLongSlow();
            return;
        }
        int i = this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        long l = i;
        do {
            byte value;
            if ((value = this._inputBuffer[ptr++]) < 0) {
                l = (l << 6) + (long)(value & 0x3F);
                this._inputPtr = ptr;
                this._numberLong = SmileUtil.zigzagDecode(l);
                this._numTypesValid = 2;
                return;
            }
            l = (l << 7) + (long)value;
        } while (ptr < maxEnd);
        this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
    }

    private final void _finishLongSlow() throws IOException {
        long l = this._fourBytesToInt();
        while (true) {
            byte value;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((value = this._inputBuffer[this._inputPtr++]) < 0) {
                l = (l << 6) + (long)(value & 0x3F);
                this._numberLong = SmileUtil.zigzagDecode(l);
                this._numTypesValid = 2;
                return;
            }
            l = (l << 7) + (long)value;
        }
    }

    private final int _fourBytesToInt() throws IOException {
        int ptr = this._inputPtr;
        if (ptr + 3 >= this._inputEnd) {
            return this._fourBytesToIntSlow();
        }
        int i = this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        this._inputPtr = ptr;
        return i;
    }

    private final int _fourBytesToIntSlow() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int i = this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        i = (i << 7) + this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        i = (i << 7) + this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return (i << 7) + this._inputBuffer[this._inputPtr++];
    }

    private final void _finishBigInteger() throws IOException {
        byte[] raw = this._read7BitBinaryWithLength();
        this._numberBigInt = new BigInteger(raw);
        this._numTypesValid = 4;
    }

    private final void _finishFloat() throws IOException {
        int i = this._fourBytesToInt();
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        i = (i << 7) + this._inputBuffer[this._inputPtr++];
        float f = Float.intBitsToFloat(i);
        this._numberDouble = f;
        this._numTypesValid = 8;
    }

    private final void _finishDouble() throws IOException {
        long hi = this._fourBytesToInt();
        long value = (hi << 28) + (long)this._fourBytesToInt();
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        value = (value << 7) + (long)this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        value = (value << 7) + (long)this._inputBuffer[this._inputPtr++];
        this._numberDouble = Double.longBitsToDouble(value);
        this._numTypesValid = 8;
    }

    private final void _finishBigDecimal() throws IOException {
        int scale = SmileUtil.zigzagDecode(this._readUnsignedVInt());
        byte[] raw = this._read7BitBinaryWithLength();
        this._numberBigDecimal = new BigDecimal(new BigInteger(raw), scale);
        this._numTypesValid = 16;
    }

    private final int _readUnsignedVInt() throws IOException {
        int value = 0;
        while (true) {
            byte i;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((i = this._inputBuffer[this._inputPtr++]) < 0) {
                value = (value << 6) + (i & 0x3F);
                return value;
            }
            value = (value << 7) + i;
        }
    }

    private final byte[] _read7BitBinaryWithLength() throws IOException {
        int byteLen = this._readUnsignedVInt();
        byte[] result = new byte[byteLen];
        int ptr = 0;
        int lastOkPtr = byteLen - 7;
        while (ptr <= lastOkPtr) {
            if (this._inputEnd - this._inputPtr < 8) {
                this._loadToHaveAtLeast(8);
            }
            int i1 = (this._inputBuffer[this._inputPtr++] << 25) + (this._inputBuffer[this._inputPtr++] << 18) + (this._inputBuffer[this._inputPtr++] << 11) + (this._inputBuffer[this._inputPtr++] << 4);
            byte x = this._inputBuffer[this._inputPtr++];
            int i2 = ((x & 7) << 21) + (this._inputBuffer[this._inputPtr++] << 14) + (this._inputBuffer[this._inputPtr++] << 7) + this._inputBuffer[this._inputPtr++];
            result[ptr++] = (byte)((i1 += x >> 3) >> 24);
            result[ptr++] = (byte)(i1 >> 16);
            result[ptr++] = (byte)(i1 >> 8);
            result[ptr++] = (byte)i1;
            result[ptr++] = (byte)(i2 >> 16);
            result[ptr++] = (byte)(i2 >> 8);
            result[ptr++] = (byte)i2;
        }
        int toDecode = result.length - ptr;
        if (toDecode > 0) {
            if (this._inputEnd - this._inputPtr < toDecode + 1) {
                this._loadToHaveAtLeast(toDecode + 1);
            }
            int value = this._inputBuffer[this._inputPtr++];
            for (int i = 1; i < toDecode; ++i) {
                value = (value << 7) + this._inputBuffer[this._inputPtr++];
                result[ptr++] = (byte)(value >> 7 - i);
            }
            result[ptr] = (byte)((value <<= toDecode) + this._inputBuffer[this._inputPtr++]);
        }
        return result;
    }

    protected final String _decodeShortAsciiValue(int len) throws IOException {
        int inPtr;
        if (this._inputEnd - this._inputPtr < len) {
            this._loadToHaveAtLeast(len);
        }
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        byte[] inBuf = this._inputBuffer;
        int end = inPtr + len;
        for (inPtr = this._inputPtr; inPtr < end; ++inPtr) {
            outBuf[outPtr++] = (char)inBuf[inPtr];
        }
        this._inputPtr = inPtr;
        return this._textBuffer.setCurrentAndReturn(len);
    }

    protected final String _decodeShortUnicodeValue(int len) throws IOException {
        if (this._inputEnd - this._inputPtr < len) {
            this._loadToHaveAtLeast(len);
        }
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int inPtr = this._inputPtr;
        this._inputPtr += len;
        int[] codes = SmileConstants.sUtf8UnitLengths;
        byte[] inputBuf = this._inputBuffer;
        int end = inPtr + len;
        while (inPtr < end) {
            int i;
            int code;
            if ((code = codes[i = inputBuf[inPtr++] & 0xFF]) != 0) {
                switch (code) {
                    case 1: {
                        i = (i & 0x1F) << 6 | inputBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 2: {
                        i = (i & 0xF) << 12 | (inputBuf[inPtr++] & 0x3F) << 6 | inputBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 3: {
                        i = (i & 7) << 18 | (inputBuf[inPtr++] & 0x3F) << 12 | (inputBuf[inPtr++] & 0x3F) << 6 | inputBuf[inPtr++] & 0x3F;
                        outBuf[outPtr++] = (char)(0xD800 | (i -= 65536) >> 10);
                        i = 0xDC00 | i & 0x3FF;
                        break;
                    }
                    default: {
                        this._reportError("Invalid byte " + Integer.toHexString(i) + " in short Unicode text block");
                    }
                }
            }
            outBuf[outPtr++] = (char)i;
        }
        return this._textBuffer.setCurrentAndReturn(outPtr);
    }

    private final void _decodeLongAscii() throws IOException {
        int inPtr;
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        block0: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            inPtr = this._inputPtr;
            int left = this._inputEnd - inPtr;
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            left = Math.min(left, outBuf.length - outPtr);
            do {
                byte b;
                if ((b = this._inputBuffer[inPtr++]) == -4) break block0;
                outBuf[outPtr++] = (char)b;
            } while (--left > 0);
            this._inputPtr = inPtr;
        }
        this._inputPtr = inPtr;
        this._textBuffer.setCurrentLength(outPtr);
    }

    private final void _decodeLongUnicode() throws IOException {
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int[] codes = SmileConstants.sUtf8UnitLengths;
        byte[] inputBuffer = this._inputBuffer;
        while (true) {
            int c;
            int ptr;
            block14: {
                int max;
                int max2;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outBuf.length) {
                    outBuf = this._textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outBuf.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (codes[c = inputBuffer[ptr++] & 0xFF] == 0) {
                        outBuf[outPtr++] = (char)c;
                        continue;
                    }
                    break block14;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            if (c == 252) break;
            switch (codes[c]) {
                case 1: {
                    c = this._decodeUtf8_2(c);
                    break;
                }
                case 2: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        c = this._decodeUtf8_3fast(c);
                        break;
                    }
                    c = this._decodeUtf8_3(c);
                    break;
                }
                case 3: {
                    c = this._decodeUtf8_4(c);
                    outBuf[outPtr++] = (char)(0xD800 | c >> 10);
                    if (outPtr >= outBuf.length) {
                        outBuf = this._textBuffer.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 0xDC00 | c & 0x3FF;
                    break;
                }
                default: {
                    this._reportInvalidChar(c);
                }
            }
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            outBuf[outPtr++] = (char)c;
        }
        this._textBuffer.setCurrentLength(outPtr);
    }

    private final void _finishRawBinary() throws IOException {
        int byteLen = this._readUnsignedVInt();
        this._binaryValue = new byte[byteLen];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int ptr = 0;
        while (true) {
            int toAdd = Math.min(byteLen, this._inputEnd - this._inputPtr);
            System.arraycopy(this._inputBuffer, this._inputPtr, this._binaryValue, ptr, toAdd);
            this._inputPtr += toAdd;
            ptr += toAdd;
            if ((byteLen -= toAdd) <= 0) {
                return;
            }
            this.loadMoreGuaranteed();
        }
    }

    protected void _skipIncomplete() throws IOException {
        this._tokenIncomplete = false;
        int tb = this._typeAsInt;
        switch (tb >> 5) {
            case 1: {
                switch ((tb &= 0x1F) >> 2) {
                    case 1: {
                        switch (tb & 3) {
                            case 1: {
                                this._skipBytes(4);
                            }
                            case 0: {
                                while (true) {
                                    int end = this._inputEnd;
                                    byte[] buf = this._inputBuffer;
                                    while (this._inputPtr < end) {
                                        if (buf[this._inputPtr++] >= 0) continue;
                                        return;
                                    }
                                    this.loadMoreGuaranteed();
                                }
                            }
                            case 2: {
                                this._skip7BitBinary();
                                return;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (tb & 3) {
                            case 0: {
                                this._skipBytes(5);
                                return;
                            }
                            case 1: {
                                this._skipBytes(10);
                                return;
                            }
                            case 2: {
                                this._readUnsignedVInt();
                                this._skip7BitBinary();
                                return;
                            }
                        }
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                this._skipBytes(1 + (tb & 0x3F));
                return;
            }
            case 4: 
            case 5: {
                this._skipBytes(2 + (tb & 0x3F));
                return;
            }
            case 7: {
                switch ((tb &= 0x1F) >> 2) {
                    case 0: 
                    case 1: {
                        while (true) {
                            int end = this._inputEnd;
                            byte[] buf = this._inputBuffer;
                            while (this._inputPtr < end) {
                                if (buf[this._inputPtr++] != -4) continue;
                                return;
                            }
                            this.loadMoreGuaranteed();
                        }
                    }
                    case 2: {
                        this._skip7BitBinary();
                        return;
                    }
                    case 7: {
                        this._skipBytes(this._readUnsignedVInt());
                        return;
                    }
                }
            }
        }
        this._throwInternal();
    }

    protected void _skipBytes(int len) throws IOException {
        while (true) {
            int toAdd = Math.min(len, this._inputEnd - this._inputPtr);
            this._inputPtr += toAdd;
            if ((len -= toAdd) <= 0) {
                return;
            }
            this.loadMoreGuaranteed();
        }
    }

    protected void _skip7BitBinary() throws IOException {
        int origBytes = this._readUnsignedVInt();
        int chunks = origBytes / 7;
        int encBytes = chunks * 8;
        if ((origBytes -= 7 * chunks) > 0) {
            encBytes += 1 + origBytes;
        }
        this._skipBytes(encBytes);
    }

    private final int _decodeUtf8_2(int c) throws IOException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c & 0x1F) << 6 | d & 0x3F;
    }

    private final int _decodeUtf8_3(int c1) throws IOException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private final int _decodeUtf8_3fast(int c1) throws IOException {
        byte d;
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private final int _decodeUtf8_4(int c) throws IOException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = (c & 7) << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c << 6 | d & 0x3F) - 65536;
    }

    protected void _reportInvalidSharedName(int index) throws IOException {
        if (this._seenNames == null) {
            this._reportError("Encountered shared name reference, even though document header explicitly declared no shared name references are included");
        }
        this._reportError("Invalid shared name reference " + index + "; only got " + this._seenNameCount + " names in buffer (invalid content)");
    }

    protected void _reportInvalidSharedStringValue(int index) throws IOException {
        if (this._seenStringValues == null) {
            this._reportError("Encountered shared text value reference, even though document header did not declared shared text value references may be included");
        }
        this._reportError("Invalid shared text value reference " + index + "; only got " + this._seenStringValueCount + " names in buffer (invalid content)");
    }

    protected void _reportInvalidChar(int c) throws JsonParseException {
        if (c < 32) {
            this._throwInvalidSpace(c);
        }
        this._reportInvalidInitial(c);
    }

    protected void _reportInvalidInitial(int mask) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask));
    }

    protected void _reportInvalidOther(int mask) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask));
    }

    protected void _reportInvalidOther(int mask, int ptr) throws JsonParseException {
        this._inputPtr = ptr;
        this._reportInvalidOther(mask);
    }

    private final JsonToken _eofAsNextToken() throws IOException {
        if (!this._parsingContext.inRoot()) {
            this._handleEOF();
        }
        this.close();
        this._currToken = null;
        return null;
    }

    public static enum Feature implements FormatFeature
    {
        REQUIRE_HEADER(true);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }

        public boolean enabledIn(int flags) {
            return (flags & this.getMask()) != 0;
        }
    }
}

