/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.smile;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.dataformat.smile.SmileParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Tool {
    public static final String SUFFIX = ".lzf";
    public final JsonFactory jsonFactory = new JsonFactory();
    public final SmileFactory smileFactory = new SmileFactory();

    public Tool() {
        this.smileFactory.configure(SmileGenerator.Feature.CHECK_SHARED_NAMES, true);
        this.smileFactory.configure(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES, true);
        this.smileFactory.configure(SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT, true);
        this.smileFactory.configure(SmileGenerator.Feature.WRITE_HEADER, true);
        this.smileFactory.configure(SmileGenerator.Feature.WRITE_END_MARKER, false);
        this.smileFactory.configure(SmileParser.Feature.REQUIRE_HEADER, false);
    }

    private void process(String[] stringArray) throws IOException {
        String string = null;
        String string2 = null;
        if (stringArray.length == 2) {
            string = stringArray[0];
            string2 = stringArray[1];
        } else if (stringArray.length == 1) {
            string = stringArray[0];
        } else {
            this.showUsage();
        }
        boolean bl = "-e".equals(string);
        if (bl) {
            this.encode(this.inputStream(string2));
        } else if ("-d".equals(string)) {
            this.decode(this.inputStream(string2));
        } else if ("-v".equals(string)) {
            this.verify(this.inputStream(string2), this.inputStream(string2));
        } else {
            this.showUsage();
        }
    }

    private InputStream inputStream(String string) throws IOException {
        if (string == null) {
            return System.in;
        }
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("File '" + string + "' does not exist.");
            System.exit(1);
        }
        return new FileInputStream(file);
    }

    private void decode(InputStream inputStream) throws IOException {
        SmileParser smileParser = this.smileFactory.createParser(inputStream);
        JsonGenerator jsonGenerator = this.jsonFactory.createGenerator((OutputStream)System.out, JsonEncoding.UTF8);
        while (smileParser.nextToken() != null || smileParser.nextToken() != null) {
            jsonGenerator.copyCurrentEvent((JsonParser)smileParser);
        }
        smileParser.close();
        jsonGenerator.close();
    }

    private void encode(InputStream inputStream) throws IOException {
        JsonParser jsonParser = this.jsonFactory.createParser(inputStream);
        SmileGenerator smileGenerator = this.smileFactory.createGenerator(System.out, JsonEncoding.UTF8);
        while (jsonParser.nextToken() != null) {
            smileGenerator.copyCurrentEvent(jsonParser);
        }
        jsonParser.close();
        smileGenerator.close();
    }

    private void verify(InputStream inputStream, InputStream inputStream2) throws IOException {
        JsonToken jsonToken;
        JsonParser jsonParser = this.jsonFactory.createParser(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4000);
        SmileGenerator smileGenerator = this.smileFactory.createGenerator(byteArrayOutputStream, JsonEncoding.UTF8);
        while (jsonParser.nextToken() != null) {
            smileGenerator.copyCurrentEvent(jsonParser);
        }
        jsonParser.close();
        smileGenerator.close();
        jsonParser = this.jsonFactory.createParser(inputStream2);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        SmileParser smileParser = this.smileFactory.createParser(byArray);
        int n = 0;
        while ((jsonToken = jsonParser.nextToken()) != null) {
            String string;
            JsonToken jsonToken2 = smileParser.nextToken();
            ++n;
            if (jsonToken != jsonToken2) {
                throw new IOException("Input and encoded differ, token #" + n + "; expected " + jsonToken + ", got " + jsonToken2);
            }
            String string2 = jsonParser.getText();
            if (string2.equals(string = smileParser.getText())) continue;
            throw new IOException("Input and encoded differ, token #" + n + "; expected text '" + string2 + "', got '" + string + "'");
        }
        System.out.println("OK: verified " + n + " tokens (from " + byArray.length + " bytes of Smile encoded data), input and encoded contents are identical");
    }

    protected void showUsage() {
        System.err.println("Usage: java " + this.getClass().getName() + " -e/-d [file]");
        System.err.println(" (if no file given, reads from stdin -- always writes to stdout)");
        System.err.println(" -d: decode Smile encoded input as JSON");
        System.err.println(" -e: encode JSON (text) input as Smile");
        System.err.println(" -v: encode JSON (text) input as Smile; read back, verify, do not write out");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws IOException {
        new Tool().process(stringArray);
    }
}

