/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.TextBuffer;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.dataformat.protobuf.PackageVersion;
import com.fasterxml.jackson.dataformat.protobuf.ProtobufReadContext;
import com.fasterxml.jackson.dataformat.protobuf.ProtobufUtil;
import com.fasterxml.jackson.dataformat.protobuf.schema.FieldType;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufField;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufMessage;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufSchema;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ProtobufParser
extends ParserMinimalBase {
    private static final int STATE_INITIAL = 0;
    private static final int STATE_ROOT_KEY = 1;
    private static final int STATE_ROOT_VALUE = 2;
    private static final int STATE_NESTED_KEY = 3;
    private static final int STATE_NESTED_VALUE = 4;
    private static final int STATE_ARRAY_START = 5;
    private static final int STATE_ARRAY_START_PACKED = 6;
    private static final int STATE_ARRAY_VALUE_FIRST = 7;
    private static final int STATE_ARRAY_VALUE_OTHER = 8;
    private static final int STATE_ARRAY_VALUE_PACKED = 9;
    private static final int STATE_ARRAY_END = 10;
    private static final int STATE_MESSAGE_END = 11;
    private static final int STATE_CLOSED = 12;
    private static final int[] UTF8_UNIT_CODES = ProtobufUtil.sUtf8UnitLengths;
    protected ObjectCodec _objectCodec;
    protected ProtobufSchema _schema;
    protected final IOContext _ioContext;
    protected boolean _closed;
    protected int _inputPtr = 0;
    protected int _inputEnd = 0;
    protected long _currInputProcessed = 0L;
    protected long _tokenInputTotal = 0L;
    protected int _tokenInputRow = 1;
    protected int _tokenInputCol = 0;
    protected ProtobufReadContext _parsingContext;
    protected final TextBuffer _textBuffer;
    protected char[] _nameCopyBuffer = null;
    protected boolean _nameCopied = false;
    protected ByteArrayBuilder _byteArrayBuilder = null;
    protected byte[] _binaryValue;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;
    protected ProtobufMessage _currentMessage;
    protected ProtobufField _currentField;
    protected boolean _tokenIncomplete = false;
    protected int _state = 0;
    protected int _nextTag;
    protected int _decodedLength;
    protected int _currentEndOffset = Integer.MAX_VALUE;
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected float _numberFloat;
    protected long _numberLong;
    protected double _numberDouble;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;

    public ProtobufParser(IOContext ctxt, int parserFeatures, ObjectCodec codec, InputStream in, byte[] inputBuffer, int start, int end, boolean bufferRecyclable) {
        super(parserFeatures);
        this._ioContext = ctxt;
        this._objectCodec = codec;
        this._inputStream = in;
        this._inputBuffer = inputBuffer;
        this._inputPtr = start;
        this._inputEnd = end;
        this._bufferRecyclable = bufferRecyclable;
        this._textBuffer = ctxt.constructTextBuffer();
        this._parsingContext = ProtobufReadContext.createRootContext();
        this._tokenInputRow = -1;
        this._tokenInputCol = -1;
    }

    public void setSchema(ProtobufSchema schema) {
        if (this._schema == schema) {
            return;
        }
        if (this._state != 0) {
            throw new IllegalStateException("Can not change Schema after parsing has started");
        }
        this._schema = schema;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public int releaseBuffered(OutputStream out) throws IOException {
        int count = this._inputEnd - this._inputPtr;
        if (count < 1) {
            return 0;
        }
        int origPtr = this._inputPtr;
        out.write(this._inputBuffer, origPtr, count);
        return count;
    }

    public Object getInputSource() {
        return this._inputStream;
    }

    public JsonLocation getTokenLocation() {
        return new JsonLocation(this._ioContext.getSourceReference(), this._tokenInputTotal, -1L, -1, (int)this._tokenInputTotal);
    }

    public JsonLocation getCurrentLocation() {
        long offset = this._currInputProcessed + (long)this._inputPtr;
        return new JsonLocation(this._ioContext.getSourceReference(), offset, -1L, -1, (int)offset);
    }

    public String getCurrentName() throws IOException {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            ProtobufReadContext parent = this._parsingContext.getParent();
            return parent.getCurrentName();
        }
        return this._parsingContext.getCurrentName();
    }

    public void overrideCurrentName(String name) {
        ProtobufReadContext ctxt = this._parsingContext;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            ctxt = ctxt.getParent();
        }
        ctxt.setCurrentName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this._state = 12;
        if (!this._closed) {
            this._closed = true;
            try {
                this._closeInput();
            }
            finally {
                this._releaseBuffers();
            }
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    public ProtobufReadContext getParsingContext() {
        return this._parsingContext;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof ProtobufSchema;
    }

    public ProtobufSchema getSchema() {
        return this._schema;
    }

    public void setSchema(FormatSchema schema) {
        if (!(schema instanceof ProtobufSchema)) {
            throw new IllegalArgumentException("Can not use FormatSchema of type " + schema.getClass().getName());
        }
        this.setSchema((ProtobufSchema)schema);
    }

    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.hasTextAsCharacters();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    protected void _releaseBuffers() throws IOException {
        Object[] buf;
        if (this._bufferRecyclable && (buf = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer(buf);
        }
        this._textBuffer.releaseBuffers();
        buf = this._nameCopyBuffer;
        if (buf != null) {
            this._nameCopyBuffer = null;
            this._ioContext.releaseNameCopyBuffer((char[])buf);
        }
    }

    public JsonToken nextToken() throws IOException {
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            this._skipBytes(this._decodedLength);
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr;
        this._binaryValue = null;
        switch (this._state) {
            case 0: {
                if (this._schema == null) {
                    this._reportError("No Schema has been assigned: can not decode content");
                }
                this._currentMessage = this._schema.getRootType();
                this._currentField = this._currentMessage.firstField();
                this._state = 1;
                this._parsingContext.setMessageType(this._currentMessage);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            case 1: {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this.close();
                    this._currToken = JsonToken.END_OBJECT;
                    return this._currToken;
                }
                return this._handleRootKey(this._decodeVInt());
            }
            case 2: {
                JsonToken t;
                this._currToken = t = this._readNextValue(this._currentField.type, 1);
                return t;
            }
            case 3: {
                if (this._checkEnd()) {
                    this._currToken = JsonToken.END_OBJECT;
                    return this._currToken;
                }
                return this._handleNestedKey(this._decodeVInt());
            }
            case 5: {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._currentField);
                this._state = 7;
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 6: {
                int len = this._decodeLength();
                int newEnd = this._inputPtr + len;
                if (!this._parsingContext.inRoot() && newEnd > this._currentEndOffset) {
                    this._reportErrorF("Packed array for field '%s' (of type %s) extends past end of enclosing message: %d > %d (length: %d)", this._currentField.name, this._currentMessage.getName(), newEnd, this._currentEndOffset, len);
                }
                this._currentEndOffset = newEnd;
                this._parsingContext = this._parsingContext.createChildArrayContext(this._currentField, newEnd);
                this._state = 9;
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 7: {
                JsonToken t;
                this._currToken = t = this._readNextValue(this._currentField.type, 8);
                return t;
            }
            case 8: {
                ProtobufReadContext parent;
                if (this._checkEnd()) {
                    this._currToken = JsonToken.END_ARRAY;
                    return this._currToken;
                }
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    ProtobufReadContext parent2 = this._parsingContext.getParent();
                    if (!parent2.inRoot()) {
                        this._reportInvalidEOF();
                    }
                    this._parsingContext = parent2;
                    this._currentField = parent2.getField();
                    this._state = 11;
                    this._currToken = JsonToken.END_ARRAY;
                    return this._currToken;
                }
                int tag = this._decodeVInt();
                if (this._currentField.id == tag >> 3) {
                    JsonToken t;
                    this._currToken = t = this._readNextValue(this._currentField.type, 8);
                    return t;
                }
                this._nextTag = tag;
                this._parsingContext = parent = this._parsingContext.getParent();
                this._currentField = parent.getField();
                this._state = 10;
                this._currToken = JsonToken.END_ARRAY;
                return this._currToken;
            }
            case 9: {
                JsonToken t;
                if (this._checkEnd()) {
                    this._currToken = JsonToken.END_ARRAY;
                    return this._currToken;
                }
                this._currToken = t = this._readNextValue(this._currentField.type, 9);
                return t;
            }
            case 10: {
                if (this._parsingContext.inRoot()) {
                    return this._handleRootKey(this._nextTag);
                }
                return this._handleNestedKey(this._nextTag);
            }
            case 4: {
                JsonToken t;
                this._currToken = t = this._readNextValue(this._currentField.type, 3);
                return t;
            }
            case 11: {
                this._currToken = JsonToken.END_OBJECT;
                return this._currToken;
            }
            case 12: {
                return null;
            }
        }
        VersionUtil.throwInternal();
        return null;
    }

    private boolean _checkEnd() throws IOException {
        ProtobufReadContext parentCtxt;
        if (this._inputPtr < this._currentEndOffset) {
            return false;
        }
        if (this._inputPtr > this._currentEndOffset) {
            this._reportErrorF("Decoding: current inputPtr (%d) exceeds end offset (%d) (for message of type %s): corrupt content?", this._inputPtr, this._currentEndOffset, this._currentMessage.getName());
        }
        this._parsingContext = parentCtxt = this._parsingContext.getParent();
        this._currentMessage = parentCtxt.getMessageType();
        this._currentEndOffset = parentCtxt.getEndOffset();
        this._currentField = parentCtxt.getField();
        this._state = this._parsingContext.inRoot() ? 1 : (this._parsingContext.inArray() ? (this._currentField.packed ? 9 : 8) : 3);
        return true;
    }

    private JsonToken _handleRootKey(int tag) throws IOException {
        ProtobufField f;
        int wireType = tag & 7;
        int id = tag >> 3;
        if (this._currentField != null ? (f = this._currentField.nextOrThisIf(id)) == null && (f = this._currentMessage.field(id)) == null : (f = this._currentMessage.field(id)) == null) {
            return this._skipUnknownField(id, wireType);
        }
        this._parsingContext.setCurrentName(f.name);
        if (!f.isValidFor(wireType)) {
            this._reportIncompatibleType(f, wireType);
        }
        this._state = f.repeated ? (f.packed ? 6 : 5) : 2;
        this._currentField = f;
        this._currToken = JsonToken.FIELD_NAME;
        return this._currToken;
    }

    private JsonToken _handleNestedKey(int tag) throws IOException {
        ProtobufField f;
        int wireType = tag & 7;
        int id = tag >> 3;
        if (this._currentField != null ? (f = this._currentField.nextOrThisIf(id)) == null && (f = this._currentMessage.field(id)) == null : (f = this._currentMessage.field(id)) == null) {
            return this._skipUnknownField(id, wireType);
        }
        if (this._currentField == null || (f = this._currentField.nextOrThisIf(id)) == null) {
            f = this._currentMessage.field(id);
        }
        if (f == null) {
            return this._skipUnknownField(id, wireType);
        }
        this._parsingContext.setCurrentName(f.name);
        if (!f.isValidFor(wireType)) {
            this._reportIncompatibleType(f, wireType);
        }
        this._state = f.repeated ? (f.packed ? 6 : 5) : 4;
        this._currentField = f;
        this._currToken = JsonToken.FIELD_NAME;
        return this._currToken;
    }

    private JsonToken _readNextValue(FieldType t, int nextState) throws IOException {
        JsonToken type;
        switch (this._currentField.type) {
            case DOUBLE: {
                this._numberDouble = Double.longBitsToDouble(this._decode64Bits());
                this._numTypesValid = 8;
                type = JsonToken.VALUE_NUMBER_FLOAT;
                break;
            }
            case FLOAT: {
                this._numberFloat = Float.intBitsToFloat(this._decode32Bits());
                this._numTypesValid = 32;
                type = JsonToken.VALUE_NUMBER_FLOAT;
                break;
            }
            case VINT32_Z: {
                this._numberInt = ProtobufUtil.zigzagDecode(this._decodeVInt());
                this._numTypesValid = 1;
                type = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case VINT64_Z: {
                this._numberLong = ProtobufUtil.zigzagDecode(this._decodeVLong());
                this._numTypesValid = 2;
                type = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case VINT32_STD: {
                this._numberInt = this._decodeVInt();
                this._numTypesValid = 1;
                type = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case VINT64_STD: {
                this._numberLong = this._decodeVLong();
                this._numTypesValid = 2;
                type = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case FIXINT32: {
                this._numberInt = this._decode32Bits();
                this._numTypesValid = 1;
                type = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case FIXINT64: {
                this._numberLong = this._decode64Bits();
                this._numTypesValid = 2;
                type = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case BOOLEAN: {
                byte i;
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((i = this._inputBuffer[this._inputPtr++]) == 1) {
                    type = JsonToken.VALUE_TRUE;
                    break;
                }
                if (i == 0) {
                    type = JsonToken.VALUE_FALSE;
                    break;
                }
                this._reportError(String.format("Invalid byte value for bool field %s: 0x%2x; should be either 0x0 or 0x1", this._currentField.name, (int)i));
                type = null;
                break;
            }
            case STRING: {
                int len;
                this._decodedLength = len = this._decodeLength();
                if (len == 0) {
                    this._textBuffer.resetWithEmpty();
                } else {
                    this._tokenIncomplete = true;
                }
                type = JsonToken.VALUE_STRING;
                break;
            }
            case BYTES: {
                int len;
                this._decodedLength = len = this._decodeLength();
                if (len == 0) {
                    this._binaryValue = ByteArrayBuilder.NO_BYTES;
                } else {
                    this._tokenIncomplete = true;
                }
                type = JsonToken.VALUE_EMBEDDED_OBJECT;
                break;
            }
            case ENUM: {
                int ix = this._decodeLength();
                if (this._currentField.isStdEnum) {
                    this._numberInt = ix;
                    this._numTypesValid = 1;
                    type = JsonToken.VALUE_NUMBER_INT;
                    break;
                }
                String enumStr = this._currentField.findEnumByIndex(ix);
                if (enumStr == null) {
                    this._reportErrorF("Unknown id %d (for enum field %s)", ix, this._currentField.name);
                }
                type = JsonToken.VALUE_STRING;
                this._textBuffer.resetWithString(enumStr);
                break;
            }
            case MESSAGE: {
                ProtobufMessage msg;
                this._currentMessage = msg = this._currentField.getMessageType();
                int len = this._decodeLength();
                int newEnd = this._inputPtr + len;
                if (newEnd > this._currentEndOffset) {
                    this._reportErrorF("Message for field '%s' (of type %s) extends past end of enclosing message: %d > %d (length: %d)", this._currentField.name, msg.getName(), newEnd, this._currentEndOffset, len);
                }
                this._currentEndOffset = newEnd;
                this._state = 3;
                this._parsingContext = this._parsingContext.createChildObjectContext(msg, this._currentField, newEnd);
                this._currentField = msg.firstField();
                return JsonToken.START_OBJECT;
            }
            default: {
                throw new UnsupportedOperationException("Type " + (Object)((Object)this._currentField.type) + " not yet supported");
            }
        }
        this._state = nextState;
        return type;
    }

    private JsonToken _skipUnknownField(int tag, int wireType) throws IOException {
        if (!this.isEnabled(JsonParser.Feature.IGNORE_UNDEFINED)) {
            this._reportErrorF("Undefined property (id %d, wire type %d) for message type %s: not allowed to ignore, as `JsonParser.Feature.IGNORE_UNDEFINED` disabled", tag, wireType, this._currentMessage.getName());
        }
        do {
            this._skipUnknownValue(wireType);
            if (this._checkEnd()) {
                this._currToken = JsonToken.END_OBJECT;
                return this._currToken;
            }
            if (this._state == 3) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
            } else if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this.close();
                this._currToken = JsonToken.END_OBJECT;
                return this._currToken;
            }
            tag = this._decodeVInt();
            wireType = tag & 7;
            this._currentField = this._currentMessage.field(tag >> 3);
        } while (this._currentField == null);
        this._parsingContext.setCurrentName(this._currentField.name);
        this._state = 2;
        if (!this._currentField.isValidFor(wireType)) {
            this._reportIncompatibleType(this._currentField, wireType);
        }
        this._currToken = JsonToken.FIELD_NAME;
        return this._currToken;
    }

    private void _skipUnknownValue(int wireType) throws IOException {
        switch (wireType) {
            case 0: {
                this._skipVInt();
                break;
            }
            case 5: {
                this._skipBytes(4);
                break;
            }
            case 1: {
                this._skipBytes(64);
                break;
            }
            case 2: {
                int len = this._decodeLength();
                this._skipBytes(len);
                break;
            }
            default: {
                this._reportError(String.format("Unrecognized wire type 0x%x for unknown field within message of type %s)", wireType, this._currentMessage.getName()));
            }
        }
    }

    public boolean nextFieldName(SerializableString sstr) throws IOException {
        if (this._state == 1) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this.close();
                this._currToken = JsonToken.END_OBJECT;
                return false;
            }
            int tag = this._decodeVInt();
            int wireType = tag & 7;
            int id = tag >> 3;
            ProtobufField f = this._findField(id);
            if (f == null) {
                this._skipUnknownField(id, wireType);
                return false;
            }
            String name = this._currentField.name;
            this._parsingContext.setCurrentName(name);
            if (!this._currentField.isValidFor(wireType)) {
                this._reportIncompatibleType(this._currentField, wireType);
            }
            this._state = this._currentField.repeated ? (this._currentField.packed ? 6 : 5) : 2;
            this._currToken = JsonToken.FIELD_NAME;
            return name.equals(sstr.getValue());
        }
        if (this._state == 3) {
            if (this._checkEnd()) {
                this._currToken = JsonToken.END_OBJECT;
                return false;
            }
            int tag = this._decodeVInt();
            int wireType = tag & 7;
            int id = tag >> 3;
            ProtobufField f = this._findField(id);
            if (f == null) {
                this._skipUnknownField(id, wireType);
                return false;
            }
            String name = this._currentField.name;
            this._parsingContext.setCurrentName(name);
            if (!this._currentField.isValidFor(wireType)) {
                this._reportIncompatibleType(this._currentField, wireType);
            }
            this._state = this._currentField.repeated ? (this._currentField.packed ? 6 : 5) : 4;
            this._currToken = JsonToken.FIELD_NAME;
            return name.equals(sstr.getValue());
        }
        return this.nextToken() == JsonToken.FIELD_NAME && sstr.getValue().equals(this.getCurrentName());
    }

    public String nextFieldName() throws IOException {
        if (this._state == 1) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this.close();
                this._currToken = JsonToken.END_OBJECT;
                return null;
            }
            int tag = this._decodeVInt();
            int wireType = tag & 7;
            int id = tag >> 3;
            ProtobufField f = this._findField(id);
            if (f == null && this._skipUnknownField(id, wireType) != JsonToken.FIELD_NAME) {
                return null;
            }
            String name = this._currentField.name;
            this._parsingContext.setCurrentName(name);
            if (!this._currentField.isValidFor(wireType)) {
                this._reportIncompatibleType(this._currentField, wireType);
            }
            this._state = this._currentField.repeated ? (this._currentField.packed ? 6 : 5) : 2;
            this._currToken = JsonToken.FIELD_NAME;
            return name;
        }
        if (this._state == 3) {
            if (this._checkEnd()) {
                this._currToken = JsonToken.END_OBJECT;
                return null;
            }
            int tag = this._decodeVInt();
            int wireType = tag & 7;
            int id = tag >> 3;
            ProtobufField f = this._findField(id);
            if (f == null && this._skipUnknownField(id, wireType) != JsonToken.FIELD_NAME) {
                return null;
            }
            String name = this._currentField.name;
            this._parsingContext.setCurrentName(name);
            if (!this._currentField.isValidFor(wireType)) {
                this._reportIncompatibleType(this._currentField, wireType);
            }
            this._state = this._currentField.repeated ? (this._currentField.packed ? 6 : 5) : 4;
            this._currToken = JsonToken.FIELD_NAME;
            return name;
        }
        return this.nextToken() == JsonToken.FIELD_NAME ? this.getCurrentName() : null;
    }

    public String nextTextValue() throws IOException {
        int len;
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            this._skipBytes(this._decodedLength);
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr;
        this._binaryValue = null;
        switch (this._state) {
            case 2: {
                JsonToken t;
                this._currToken = t = this._readNextValue(this._currentField.type, 1);
                return t == JsonToken.VALUE_STRING ? this.getText() : null;
            }
            case 4: {
                JsonToken t;
                this._currToken = t = this._readNextValue(this._currentField.type, 3);
                return t == JsonToken.VALUE_STRING ? this.getText() : null;
            }
            case 7: {
                if (this._currentField.type == FieldType.STRING) {
                    this._state = 8;
                    break;
                }
                this._currToken = this._readNextValue(this._currentField.type, 8);
                return null;
            }
            case 8: {
                ProtobufReadContext parent;
                if (this._checkEnd()) {
                    this._currToken = JsonToken.END_ARRAY;
                    return null;
                }
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    ProtobufReadContext parent2 = this._parsingContext.getParent();
                    if (!parent2.inRoot()) {
                        this._reportInvalidEOF();
                    }
                    this._parsingContext = parent2;
                    this._currentField = parent2.getField();
                    this._state = 11;
                    this._currToken = JsonToken.END_ARRAY;
                    return null;
                }
                int tag = this._decodeVInt();
                if (this._currentField.id == tag >> 3) {
                    if (this._currentField.type == FieldType.STRING) break;
                    this._currToken = this._readNextValue(this._currentField.type, 8);
                    return null;
                }
                this._nextTag = tag;
                this._parsingContext = parent = this._parsingContext.getParent();
                this._currentField = parent.getField();
                this._state = 10;
                this._currToken = JsonToken.END_ARRAY;
                return null;
            }
            case 9: {
                if (this._checkEnd()) {
                    this._currToken = JsonToken.END_ARRAY;
                    return null;
                }
                if (this._currentField.type == FieldType.STRING) break;
                this._currToken = this._readNextValue(this._currentField.type, 9);
                return null;
            }
            default: {
                return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
            }
        }
        this._decodedLength = len = this._decodeLength();
        this._currToken = JsonToken.VALUE_STRING;
        if (len == 0) {
            this._textBuffer.resetWithEmpty();
            return "";
        }
        if (this._inputPtr + len <= this._inputEnd) {
            return this._finishShortText(len);
        }
        this._finishToken();
        return this._textBuffer.contentsAsString();
    }

    private final ProtobufField _findField(int id) {
        ProtobufField f;
        if (this._currentField == null || (f = this._currentField.nextOrThisIf(id)) == null) {
            f = this._currentMessage.field(id);
        }
        this._currentField = f;
        return f;
    }

    public String getText() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                int len = this._decodedLength;
                if (this._inputPtr + len <= this._inputEnd) {
                    this._tokenIncomplete = false;
                    return this._finishShortText(len);
                }
                this._finishToken();
            }
            return this._textBuffer.contentsAsString();
        }
        JsonToken t = this._currToken;
        if (t == null) {
            return null;
        }
        if (t == JsonToken.FIELD_NAME) {
            return this._parsingContext.getCurrentName();
        }
        if (t.isNumeric()) {
            return this.getNumberValue().toString();
        }
        return this._currToken.asString();
    }

    public char[] getTextCharacters() throws IOException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            switch (this._currToken) {
                case VALUE_STRING: {
                    return this._textBuffer.getTextBuffer();
                }
                case FIELD_NAME: {
                    return this._parsingContext.getCurrentName().toCharArray();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getNumberValue().toString().toCharArray();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    public int getTextLength() throws IOException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            switch (this._currToken) {
                case VALUE_STRING: {
                    return this._textBuffer.size();
                }
                case FIELD_NAME: {
                    return this._parsingContext.getCurrentName().length();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getNumberValue().toString().length();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    public int getTextOffset() throws IOException {
        return 0;
    }

    public String getValueAsString() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                int len = this._decodedLength;
                if (this._inputPtr + len <= this._inputEnd) {
                    this._tokenIncomplete = false;
                    return this._finishShortText(len);
                }
                this._finishToken();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
            return null;
        }
        return this.getText();
    }

    public String getValueAsString(String defaultValue) throws IOException {
        if (!(this._currToken == JsonToken.VALUE_STRING || this._currToken != null && this._currToken != JsonToken.VALUE_NULL && this._currToken.isScalarValue())) {
            return defaultValue;
        }
        return this.getText();
    }

    public int getText(Writer writer) throws IOException {
        JsonToken t = this._currToken;
        if (t == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                int len = this._decodedLength;
                if (this._inputPtr + len <= this._inputEnd) {
                    this._tokenIncomplete = false;
                    this._finishShortText(len);
                } else {
                    this._finishToken();
                }
            }
            return this._textBuffer.contentsToWriter(writer);
        }
        if (t == JsonToken.FIELD_NAME) {
            String n = this._parsingContext.getCurrentName();
            writer.write(n);
            return n.length();
        }
        if (t != null) {
            if (t.isNumeric()) {
                return this._textBuffer.contentsToWriter(writer);
            }
            char[] ch = t.asCharArray();
            writer.write(ch);
            return ch.length;
        }
        return 0;
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + this._currToken + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        return this._binaryValue;
    }

    public Object getEmbeddedObject() throws IOException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    public int readBinaryValue(Base64Variant b64variant, OutputStream out) throws IOException {
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + this._currToken + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        return -1;
    }

    public boolean isNaN() {
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 8) != 0) {
                double d = this._numberDouble;
                return Double.isNaN(d) || Double.isInfinite(d);
            }
            if ((this._numTypesValid & 0x20) != 0) {
                float f = this._numberFloat;
                return Float.isNaN(f) || Float.isInfinite(f);
            }
        }
        return false;
    }

    public Number getNumberValue() throws IOException {
        if (this._numTypesValid == 0) {
            this._checkNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._numberBigInt;
            }
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 8) != 0) {
            return this._numberDouble;
        }
        if ((this._numTypesValid & 0x20) == 0) {
            this._throwInternal();
        }
        return Float.valueOf(this._numberFloat);
    }

    public JsonParser.NumberType getNumberType() throws IOException {
        if (this._numTypesValid == 0) {
            this._checkNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return JsonParser.NumberType.INT;
            }
            if ((this._numTypesValid & 2) != 0) {
                return JsonParser.NumberType.LONG;
            }
            return JsonParser.NumberType.BIG_INTEGER;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        if ((this._numTypesValid & 8) != 0) {
            return JsonParser.NumberType.DOUBLE;
        }
        return JsonParser.NumberType.FLOAT;
    }

    public int getIntValue() throws IOException {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(1);
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    public long getLongValue() throws IOException {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    public BigInteger getBigIntegerValue() throws IOException {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._numberBigInt;
    }

    public float getFloatValue() throws IOException {
        if ((this._numTypesValid & 0x20) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(32);
            }
            if ((this._numTypesValid & 0x20) == 0) {
                this.convertNumberToFloat();
            }
        }
        return this._numberFloat;
    }

    public double getDoubleValue() throws IOException {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(8);
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._numberDouble;
    }

    public BigDecimal getDecimalValue() throws IOException {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(16);
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._numberBigDecimal;
    }

    protected void _checkNumericValue(int expType) throws IOException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT || this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return;
        }
        this._reportError("Current token (" + this._currToken + ") not numeric, can not use numeric value accessors");
    }

    protected void convertNumberToInt() throws IOException {
        if ((this._numTypesValid & 2) != 0) {
            int result = (int)this._numberLong;
            if ((long)result != this._numberLong) {
                this._reportError("Numeric value (" + this.getText() + ") out of range of int");
            }
            this._numberInt = result;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_INT.compareTo(this._numberBigInt) > 0 || BI_MAX_INT.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigInt.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -2.147483648E9 || this._numberDouble > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberDouble;
        } else if ((this._numTypesValid & 0x20) != 0) {
            if ((double)this._numberFloat < -2.147483648E9 || (double)this._numberFloat > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberFloat;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_INT.compareTo(this._numberBigDecimal) > 0 || BD_MAX_INT.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected void convertNumberToLong() throws IOException {
        if ((this._numTypesValid & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_LONG.compareTo(this._numberBigInt) > 0 || BI_MAX_LONG.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigInt.longValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -9.223372036854776E18 || this._numberDouble > 9.223372036854776E18) {
                this.reportOverflowLong();
            }
            this._numberLong = (long)this._numberDouble;
        } else if ((this._numTypesValid & 0x20) != 0) {
            if ((double)this._numberFloat < -9.223372036854776E18 || (double)this._numberFloat > 9.223372036854776E18) {
                this.reportOverflowInt();
            }
            this._numberLong = (long)this._numberFloat;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_LONG.compareTo(this._numberBigDecimal) > 0 || BD_MAX_LONG.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected void convertNumberToBigInteger() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberBigInt = this._numberBigDecimal.toBigInteger();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberDouble).toBigInteger();
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberFloat).toBigInteger();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected void convertNumberToFloat() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberFloat = this._numberBigDecimal.floatValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberFloat = this._numberBigInt.floatValue();
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberFloat = (float)this._numberDouble;
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberFloat = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberFloat = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x20;
    }

    protected void convertNumberToDouble() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberBigDecimal.doubleValue();
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberDouble = this._numberFloat;
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberBigInt.doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected void convertNumberToBigDecimal() throws IOException {
        if ((this._numTypesValid & 0x28) != 0) {
            this._numberBigDecimal = NumberInput.parseBigDecimal((String)this.getText());
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._numberBigInt);
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    protected void _finishToken() throws IOException {
        this._tokenIncomplete = false;
        if (this._currToken == JsonToken.VALUE_STRING) {
            int len = this._decodedLength;
            if (len > this._inputEnd - this._inputPtr) {
                if (len >= this._inputBuffer.length) {
                    this._finishLongText(len);
                    return;
                }
                this._loadToHaveAtLeast(len);
            }
            this._finishShortText(len);
            return;
        }
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._binaryValue = this._finishBytes(this._decodedLength);
            return;
        }
        this._throwInternal();
    }

    protected byte[] _finishBytes(int len) throws IOException {
        byte[] b = new byte[len];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int ptr = 0;
        while (true) {
            int toAdd = Math.min(len, this._inputEnd - this._inputPtr);
            System.arraycopy(this._inputBuffer, this._inputPtr, b, ptr, toAdd);
            this._inputPtr += toAdd;
            ptr += toAdd;
            if ((len -= toAdd) <= 0) {
                return b;
            }
            this.loadMoreGuaranteed();
        }
    }

    private final String _finishShortText(int len) throws IOException {
        int i;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        if (outBuf.length < len) {
            outBuf = this._textBuffer.expandCurrentSegment(len);
        }
        int outPtr = 0;
        int inPtr = this._inputPtr;
        this._inputPtr += len;
        byte[] inputBuf = this._inputBuffer;
        int end = inPtr + len;
        while ((i = inputBuf[inPtr]) >= 0) {
            outBuf[outPtr++] = (char)i;
            if (++inPtr != end) continue;
            return this._textBuffer.setCurrentAndReturn(outPtr);
        }
        int[] codes = UTF8_UNIT_CODES;
        do {
            i = inputBuf[inPtr++] & 0xFF;
            switch (codes[i]) {
                case 0: {
                    break;
                }
                case 1: {
                    i = (i & 0x1F) << 6 | inputBuf[inPtr++] & 0x3F;
                    break;
                }
                case 2: {
                    i = (i & 0xF) << 12 | (inputBuf[inPtr++] & 0x3F) << 6 | inputBuf[inPtr++] & 0x3F;
                    break;
                }
                case 3: {
                    i = (i & 7) << 18 | (inputBuf[inPtr++] & 0x3F) << 12 | (inputBuf[inPtr++] & 0x3F) << 6 | inputBuf[inPtr++] & 0x3F;
                    outBuf[outPtr++] = (char)(0xD800 | (i -= 65536) >> 10);
                    i = 0xDC00 | i & 0x3FF;
                    break;
                }
                default: {
                    this._reportError("Invalid byte " + Integer.toHexString(i) + " in Unicode text block");
                }
            }
            outBuf[outPtr++] = (char)i;
        } while (inPtr < end);
        return this._textBuffer.setCurrentAndReturn(outPtr);
    }

    private final void _finishLongText(int len) throws IOException {
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        int[] codes = UTF8_UNIT_CODES;
        int outEnd = outBuf.length;
        while (--len >= 0) {
            int c = this._nextByte() & 0xFF;
            int code = codes[c];
            if (code == 0 && outPtr < outEnd) {
                outBuf[outPtr++] = (char)c;
                continue;
            }
            if ((len -= code) < 0) {
                throw this._constructError("Malformed UTF-8 character at end of long (non-chunked) text segment");
            }
            switch (code) {
                case 0: {
                    break;
                }
                case 1: {
                    int d = this._nextByte();
                    if ((d & 0xC0) != 128) {
                        this._reportInvalidOther(d & 0xFF, this._inputPtr);
                    }
                    c = (c & 0x1F) << 6 | d & 0x3F;
                    break;
                }
                case 2: {
                    c = this._decodeUTF8_3(c);
                    break;
                }
                case 3: {
                    c = this._decodeUTF8_4(c);
                    outBuf[outPtr++] = (char)(0xD800 | c >> 10);
                    if (outPtr >= outBuf.length) {
                        outBuf = this._textBuffer.finishCurrentSegment();
                        outPtr = 0;
                        outEnd = outBuf.length;
                    }
                    c = 0xDC00 | c & 0x3FF;
                    break;
                }
                default: {
                    this._reportInvalidChar(c);
                }
            }
            if (outPtr >= outEnd) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
                outEnd = outBuf.length;
            }
            outBuf[outPtr++] = (char)c;
        }
        this._textBuffer.setCurrentLength(outPtr);
    }

    private final int _decodeUTF8_3(int c1) throws IOException {
        c1 &= 0xF;
        int d = this._nextByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        d = this._nextByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private final int _decodeUTF8_4(int c) throws IOException {
        int d = this._nextByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = (c & 7) << 6 | d & 0x3F;
        d = this._nextByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        d = this._nextByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c << 6 | d & 0x3F) - 65536;
    }

    private final int _nextByte() throws IOException {
        int inPtr = this._inputPtr;
        if (inPtr < this._inputEnd) {
            byte ch = this._inputBuffer[inPtr];
            this._inputPtr = inPtr + 1;
            return ch;
        }
        this.loadMoreGuaranteed();
        return this._inputBuffer[this._inputPtr++];
    }

    protected final boolean loadMore() throws IOException {
        if (this._inputStream != null) {
            this._currInputProcessed += (long)this._inputEnd;
            int count = this._inputStream.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (count > 0) {
                this._currentEndOffset = this._parsingContext.adjustEnd(this._inputEnd);
                this._inputPtr = 0;
                this._inputEnd = count;
                return true;
            }
            this._closeInput();
            if (count == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    protected final void loadMoreGuaranteed() throws IOException {
        if (!this.loadMore()) {
            this._reportInvalidEOF();
        }
    }

    protected final void _loadToHaveAtLeast(int minAvailable) throws IOException {
        if (this._inputStream == null) {
            throw this._constructError("Needed to read " + minAvailable + " bytes, reached end-of-input");
        }
        int ptr = this._inputPtr;
        int amount = this._inputEnd - ptr;
        if (ptr > 0) {
            this._currInputProcessed += (long)ptr;
            if (amount > 0) {
                System.arraycopy(this._inputBuffer, ptr, this._inputBuffer, 0, amount);
            }
            this._currentEndOffset = this._parsingContext.adjustEnd(ptr);
        }
        this._inputPtr = 0;
        this._inputEnd = amount;
        while (this._inputEnd < minAvailable) {
            int count = this._inputStream.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (count < 1) {
                this._closeInput();
                if (count == 0) {
                    throw new IOException("InputStream.read() returned 0 characters when trying to read " + amount + " bytes");
                }
                throw this._constructError("Needed to read " + minAvailable + " bytes, missed " + minAvailable + " before end-of-input");
            }
            this._inputEnd += count;
        }
    }

    protected ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected void _closeInput() throws IOException {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    protected void _handleEOF() throws JsonParseException {
        if (!this._parsingContext.inRoot()) {
            String marker = this._parsingContext.inArray() ? "Array" : "Object";
            this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", marker, this._parsingContext.getStartLocation(this._ioContext.getSourceReference(), this._currInputProcessed)), null);
        }
    }

    protected void _skipBytes(int len) throws IOException {
        while (true) {
            int toAdd = Math.min(len, this._inputEnd - this._inputPtr);
            this._inputPtr += toAdd;
            if ((len -= toAdd) <= 0) {
                return;
            }
            this.loadMoreGuaranteed();
        }
    }

    protected void _skipVInt() throws IOException {
        int ptr = this._inputPtr;
        if (ptr + 10 > this._inputEnd) {
            this._skipVIntSlow();
            return;
        }
        byte[] buf = this._inputBuffer;
        if (buf[ptr++] >= 0 || buf[ptr++] >= 0 || buf[ptr++] >= 0 || buf[ptr++] >= 0) {
            this._inputPtr = ptr;
            return;
        }
        int end = ptr + 6;
        while (ptr < end) {
            if (buf[ptr] >= 0) {
                this._inputPtr = ptr + 1;
                return;
            }
            ++ptr;
        }
        this._reportTooLongVInt(buf[ptr - 1]);
    }

    protected void _skipVIntSlow() throws IOException {
        for (int i = 0; i < 10; ++i) {
            byte ch;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((ch = this._inputBuffer[this._inputPtr++]) < 0) continue;
            return;
        }
        this._reportTooLongVInt(this._inputBuffer[this._inputPtr - 1]);
    }

    private int _decodeVInt() throws IOException {
        int v;
        int ptr = this._inputPtr;
        if (ptr + 5 > this._inputEnd) {
            return this._decodeVIntSlow();
        }
        byte[] buf = this._inputBuffer;
        if ((v = buf[ptr++]) < 0) {
            byte ch;
            v &= 0x7F;
            if ((ch = buf[ptr++]) < 0) {
                v |= (ch & 0x7F) << 7;
                if ((ch = buf[ptr++]) < 0) {
                    v |= (ch & 0x7F) << 14;
                    if ((ch = buf[ptr++]) < 0) {
                        int last;
                        v |= (ch & 0x7F) << 21;
                        if ((last = buf[ptr++] & 0xFF) > 31) {
                            this._inputPtr = ptr;
                            this._reportTooLongVInt(last);
                        }
                        v |= last << 28;
                    } else {
                        v |= ch << 21;
                    }
                } else {
                    v |= ch << 14;
                }
            } else {
                v |= ch << 7;
            }
        }
        this._inputPtr = ptr;
        return v;
    }

    private int _decodeLength() throws IOException {
        int v;
        int ptr = this._inputPtr;
        if (ptr + 5 > this._inputEnd) {
            int v2 = this._decodeVIntSlow();
            if (v2 < 0) {
                this._reportInvalidLength(v2);
            }
            return v2;
        }
        byte[] buf = this._inputBuffer;
        if ((v = buf[ptr++]) < 0) {
            byte ch;
            v &= 0x7F;
            if ((ch = buf[ptr++]) < 0) {
                v |= (ch & 0x7F) << 7;
                if ((ch = buf[ptr++]) < 0) {
                    v |= (ch & 0x7F) << 14;
                    if ((ch = buf[ptr++]) < 0) {
                        int last;
                        v |= (ch & 0x7F) << 21;
                        if ((last = buf[ptr++] & 0xFF) > 15) {
                            this._inputPtr = ptr;
                            this._reportTooLongVInt(last);
                        }
                        v |= last << 28;
                    } else {
                        v |= ch << 21;
                    }
                } else {
                    v |= ch << 14;
                }
            } else {
                v |= ch << 7;
            }
        }
        this._inputPtr = ptr;
        if (v < 0) {
            this._reportInvalidLength(v);
        }
        return v;
    }

    protected int _decodeVIntSlow() throws IOException {
        int v = 0;
        int shift = 0;
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            int ch = this._inputBuffer[this._inputPtr++];
            if (shift >= 28 && (ch &= 0xFF) > 15) {
                this._reportTooLongVInt(ch);
            }
            if (ch >= 0) {
                return v | ch << shift;
            }
            v |= (ch & 0x7F) << shift;
            shift += 7;
        }
    }

    private long _decodeVLong() throws IOException {
        int ch;
        int v;
        if (this._inputPtr + 10 > this._inputEnd) {
            return this._decodeVLongSlow();
        }
        byte[] buf = this._inputBuffer;
        if ((v = buf[this._inputPtr++]) >= 0) {
            return v;
        }
        v &= 0x7F;
        if ((ch = buf[this._inputPtr++]) >= 0) {
            return v | ch << 7;
        }
        v |= (ch & 0x7F) << 7;
        if ((ch = buf[this._inputPtr++]) >= 0) {
            return v | ch << 14;
        }
        v |= (ch & 0x7F) << 14;
        if ((ch = buf[this._inputPtr++]) >= 0) {
            return v | ch << 21;
        }
        long l = v |= (ch & 0x7F) << 21;
        if ((v = buf[this._inputPtr++]) >= 0) {
            return (long)v << 28 | l;
        }
        v &= 0x7F;
        if ((ch = buf[this._inputPtr++]) >= 0) {
            long l2 = v | ch << 7;
            return l2 << 28 | l;
        }
        v |= (ch & 0x7F) << 7;
        if ((ch = buf[this._inputPtr++]) >= 0) {
            long l2 = v | ch << 14;
            return l2 << 28 | l;
        }
        v |= (ch & 0x7F) << 14;
        if ((ch = buf[this._inputPtr++]) >= 0) {
            long l2 = v | ch << 21;
            return l2 << 28 | l;
        }
        l |= (long)(v |= (ch & 0x7F) << 21) << 28;
        if ((v = buf[this._inputPtr++]) >= 0) {
            return (long)v << 56 | l;
        }
        v &= 0x7F;
        if ((ch = buf[this._inputPtr++] & 0xFF) > 1) {
            this._reportTooLongVInt(ch);
        }
        return (long)(v |= (ch & 0x7F) << 7) << 56 | l;
    }

    protected long _decodeVLongSlow() throws IOException {
        long v = 0L;
        int shift = 0;
        while (true) {
            long l;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            int ch = this._inputBuffer[this._inputPtr++];
            if (shift >= 63 && (ch &= 0xFF) > 1) {
                this._reportTooLongVLong(ch);
            }
            if (ch >= 0) {
                l = ch;
                return v | l << shift;
            }
            l = ch &= 0x7F;
            v |= l << shift;
            shift += 7;
        }
    }

    protected final int _decode32Bits() throws IOException {
        int ptr = this._inputPtr;
        if (ptr + 3 >= this._inputEnd) {
            return this._slow32();
        }
        byte[] b = this._inputBuffer;
        int v = (b[ptr] & 0xFF) + ((b[ptr + 1] & 0xFF) << 8) + ((b[ptr + 2] & 0xFF) << 16) + ((b[ptr + 3] & 0xFF) << 24);
        this._inputPtr = ptr + 4;
        return v;
    }

    protected final int _slow32() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int v = this._inputBuffer[this._inputPtr++] & 0xFF;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        v |= (this._inputBuffer[this._inputPtr++] & 0xFF) << 8;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        v |= (this._inputBuffer[this._inputPtr++] & 0xFF) << 16;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return v | this._inputBuffer[this._inputPtr++] << 24;
    }

    protected final long _decode64Bits() throws IOException {
        int ptr = this._inputPtr;
        if (ptr + 7 >= this._inputEnd) {
            return this._slow64();
        }
        byte[] b = this._inputBuffer;
        int i1 = b[ptr++] & 0xFF | (b[ptr++] & 0xFF) << 8 | (b[ptr++] & 0xFF) << 16 | b[ptr++] << 24;
        int i2 = b[ptr++] & 0xFF | (b[ptr++] & 0xFF) << 8 | (b[ptr++] & 0xFF) << 16 | b[ptr++] << 24;
        this._inputPtr = ptr;
        return ProtobufParser._long(i1, i2);
    }

    protected final long _slow64() throws IOException {
        return ProtobufParser._long(this._decode32Bits(), this._decode32Bits());
    }

    protected static final long _long(int i1, int i2) {
        long high = i2;
        long low = i1;
        low = low << 32 >>> 32;
        return (high <<= 32) | low;
    }

    private void _reportErrorF(String format, Object ... args) throws JsonParseException {
        this._reportError(String.format(format, args));
    }

    private void _reportIncompatibleType(ProtobufField field, int wireType) throws JsonParseException {
        this._reportError(String.format("Incompatible wire type (0x%x) for field '%s': not valid for field of type %s (expected 0x%x)", new Object[]{wireType, field.name, field.type, field.type.getWireType()}));
    }

    private void _reportInvalidLength(int len) throws JsonParseException {
        this._reportError("Invalid length (%d): must be positive number", len);
    }

    private void _reportTooLongVInt(int fifth) throws JsonParseException {
        this._reportError("Too long tag VInt: fifth byte 0x%x", fifth);
    }

    private void _reportTooLongVLong(int fifth) throws JsonParseException {
        this._reportError("Too long tag VLong: tenth byte 0x%x", fifth);
    }

    private void _reportInvalidInitial(int mask) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x%x", mask);
    }

    private void _reportInvalidOther(int mask) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x%x", mask);
    }

    private void _reportInvalidOther(int mask, int ptr) throws JsonParseException {
        this._inputPtr = ptr;
        this._reportInvalidOther(mask);
    }

    private void _reportInvalidChar(int c) throws JsonParseException {
        if (c < 32) {
            this._throwInvalidSpace(c);
        }
        this._reportInvalidInitial(c);
    }
}

