/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf.schemagen;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.DataType;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.DefinedTypeElementBuilders;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.ProtoBufSchemaVisitor;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.TypeElementBuilder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class ProtobufSchemaHelper {
    private ProtobufSchemaHelper() {
    }

    public static String getNamespace(JavaType type) {
        Class cls = type.getRawClass();
        Package pkg = cls.getPackage();
        return pkg == null ? "" : pkg.getName();
    }

    public static DataType.ScalarType getScalarType(JavaType type) {
        Class raw = type.getRawClass();
        if (raw.isPrimitive()) {
            raw = ClassUtil.wrapperType((Class)raw);
        }
        if (raw == Integer.class || raw == Short.class || raw == Byte.class) {
            return DataType.ScalarType.INT32;
        }
        if (raw == Long.class || raw == BigInteger.class) {
            return DataType.ScalarType.INT64;
        }
        if (raw == String.class) {
            return DataType.ScalarType.STRING;
        }
        if (raw == Float.class) {
            return DataType.ScalarType.FLOAT;
        }
        if (raw == Boolean.class) {
            return DataType.ScalarType.BOOL;
        }
        if (raw == byte[].class || raw == ByteBuffer.class) {
            return DataType.ScalarType.BYTES;
        }
        if (raw == Double.class || raw == BigDecimal.class) {
            return DataType.ScalarType.DOUBLE;
        }
        return null;
    }

    public static boolean hasIndex(BeanProperty writer) {
        return writer.getMetadata().hasIndex();
    }

    public static TypeElementBuilder acceptTypeElement(SerializerProvider provider, JavaType type, DefinedTypeElementBuilders definedTypeElementBuilders, boolean isNested) throws JsonMappingException {
        JsonSerializer serializer = provider.findValueSerializer(type, null);
        ProtoBufSchemaVisitor visitor = new ProtoBufSchemaVisitor(provider, definedTypeElementBuilders, isNested);
        serializer.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, type);
        return visitor;
    }
}

