/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf.schema;

import com.fasterxml.jackson.core.util.InternCache;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.DataType;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.EnumConstantElement;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.EnumElement;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.FieldElement;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.MessageElement;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.TypeElement;
import com.fasterxml.jackson.dataformat.protobuf.schema.FieldType;
import com.fasterxml.jackson.dataformat.protobuf.schema.FieldTypes;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufEnum;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufField;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TypeResolver {
    private final TypeResolver _parent;
    private Map<String, MessageElement> _nativeMessageTypes;
    private Map<String, ProtobufEnum> _enumTypes;
    private Map<String, ProtobufMessage> _resolvedMessageTypes;

    protected TypeResolver(TypeResolver p, Map<String, MessageElement> nativeMsgs, Map<String, ProtobufEnum> enums) {
        this._parent = p;
        if (enums == null) {
            enums = Collections.emptyMap();
        }
        this._enumTypes = enums;
        if (nativeMsgs == null) {
            nativeMsgs = Collections.emptyMap();
        }
        this._nativeMessageTypes = nativeMsgs;
        this._resolvedMessageTypes = Collections.emptyMap();
    }

    public static TypeResolver construct(Collection<TypeElement> nativeTypes) {
        return TypeResolver.construct(null, nativeTypes);
    }

    protected static TypeResolver construct(TypeResolver parent, Collection<TypeElement> nativeTypes) {
        LinkedHashMap<String, MessageElement> nativeMessages = null;
        LinkedHashMap<String, ProtobufEnum> enumTypes = null;
        for (TypeElement nt : nativeTypes) {
            if (nt instanceof MessageElement) {
                if (nativeMessages == null) {
                    nativeMessages = new LinkedHashMap<String, MessageElement>();
                }
                nativeMessages.put(nt.name(), (MessageElement)nt);
                continue;
            }
            if (!(nt instanceof EnumElement)) continue;
            if (enumTypes == null) {
                enumTypes = new LinkedHashMap<String, ProtobufEnum>();
            }
            enumTypes.put(nt.name(), TypeResolver._constructEnum((EnumElement)nt));
        }
        return new TypeResolver(parent, nativeMessages, enumTypes);
    }

    protected static ProtobufEnum _constructEnum(EnumElement nativeEnum) {
        LinkedHashMap<String, Integer> valuesByName = new LinkedHashMap<String, Integer>();
        boolean standard = true;
        int exp = 0;
        for (EnumConstantElement v : nativeEnum.constants()) {
            int id = v.tag();
            if (standard && id != exp) {
                standard = false;
            }
            valuesByName.put(v.name(), id);
            ++exp;
        }
        String name = InternCache.instance.intern(nativeEnum.name());
        return new ProtobufEnum(name, valuesByName, standard);
    }

    public ProtobufMessage resolve(MessageElement rawType) {
        ProtobufMessage msg = this._findResolvedMessage(rawType.name());
        if (msg != null) {
            return msg;
        }
        return TypeResolver.construct(this, rawType.nestedElements())._resolve(rawType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ProtobufMessage _resolve(MessageElement rawType) {
        List<FieldElement> rawFields = rawType.fields();
        Object[] resolvedFields = new ProtobufField[rawFields.size()];
        ProtobufMessage message = new ProtobufMessage(rawType.name(), (ProtobufField[])resolvedFields);
        if (this._resolvedMessageTypes.isEmpty()) {
            this._resolvedMessageTypes = new HashMap<String, ProtobufMessage>();
        }
        this._resolvedMessageTypes.put(rawType.name(), message);
        int ix = 0;
        for (FieldElement f : rawFields) {
            ProtobufField pbf;
            DataType fieldType = f.type();
            FieldType type = FieldTypes.findType(fieldType);
            if (type != null) {
                pbf = new ProtobufField(f, type);
            } else {
                if (!(fieldType instanceof DataType.NamedType)) throw new IllegalArgumentException(String.format("Unrecognized DataType '%s' for field '%s'", fieldType.getClass().getName(), f.name()));
                String typeStr = ((DataType.NamedType)fieldType).name();
                ProtobufField resolvedF = this._findLocalResolved(f, typeStr);
                if (resolvedF != null) {
                    pbf = resolvedF;
                } else {
                    MessageElement nativeMt = this._nativeMessageTypes.get(typeStr);
                    if (nativeMt != null) {
                        pbf = new ProtobufField(f, TypeResolver.construct(this, nativeMt.nestedElements())._resolve(nativeMt));
                    } else {
                        resolvedF = this._parent._findAnyResolved(f, typeStr);
                        if (resolvedF != null) {
                            pbf = resolvedF;
                        } else {
                            StringBuilder enumStr = this._knownEnums(new StringBuilder());
                            StringBuilder msgStr = this._knownMsgs(new StringBuilder());
                            throw new IllegalArgumentException(String.format("Unknown protobuf field type '%s' for field '%s' of MessageType '%s' (known enum types: %s; known message types: %s)", typeStr, f.name(), rawType.name(), enumStr, msgStr));
                        }
                    }
                }
            }
            resolvedFields[ix++] = pbf;
        }
        ProtobufField first = resolvedFields.length == 0 ? null : resolvedFields[0];
        Arrays.sort(resolvedFields);
        int end = resolvedFields.length - 1;
        for (int i = 0; i < end; ++i) {
            ((ProtobufField)resolvedFields[i]).assignNext((ProtobufField)resolvedFields[i + 1]);
        }
        message.init(first);
        return message;
    }

    private ProtobufMessage _findResolvedMessage(String typeStr) {
        ProtobufMessage msg = this._resolvedMessageTypes.get(typeStr);
        if (msg == null && this._parent != null) {
            return this._parent._findResolvedMessage(typeStr);
        }
        return msg;
    }

    private ProtobufField _findAnyResolved(FieldElement nativeField, String typeStr) {
        ProtobufField f = this._findLocalResolved(nativeField, typeStr);
        if (f == null) {
            MessageElement nativeMt = this._nativeMessageTypes.get(typeStr);
            if (nativeMt != null) {
                return new ProtobufField(nativeField, TypeResolver.construct(this, nativeMt.nestedElements())._resolve(nativeMt));
            }
            if (this._parent != null) {
                return this._parent._findAnyResolved(nativeField, typeStr);
            }
        }
        return f;
    }

    private StringBuilder _knownEnums(StringBuilder sb) {
        if (this._parent != null) {
            sb = this._parent._knownEnums(sb);
        }
        for (String name : this._enumTypes.keySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(name);
        }
        return sb;
    }

    private StringBuilder _knownMsgs(StringBuilder sb) {
        if (this._parent != null) {
            sb = this._parent._knownMsgs(sb);
        }
        for (String name : this._nativeMessageTypes.keySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(name);
        }
        return sb;
    }

    private ProtobufField _findLocalResolved(FieldElement nativeField, String typeStr) {
        ProtobufMessage msg = this._resolvedMessageTypes.get(typeStr);
        if (msg != null) {
            return new ProtobufField(nativeField, msg);
        }
        ProtobufEnum et = this._enumTypes.get(typeStr);
        if (et != null) {
            return new ProtobufField(nativeField, et);
        }
        return null;
    }
}

