/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf.schema;

import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.FieldElement;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.OptionElement;
import com.fasterxml.jackson.dataformat.protobuf.schema.EnumLookup;
import com.fasterxml.jackson.dataformat.protobuf.schema.FieldType;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufEnum;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufMessage;
import java.util.Collection;

public class ProtobufField
implements Comparable<ProtobufField> {
    public final int id;
    public final int typedTag;
    public final String name;
    public final FieldType type;
    public final int wireType;
    public final boolean required;
    public final boolean repeated;
    public final boolean packed;
    public final boolean deprecated;
    public final boolean usesZigZag;
    protected ProtobufMessage messageType;
    protected final EnumLookup enumValues;
    public ProtobufField next;
    public final boolean isObject;
    public final boolean isStdEnum;

    public ProtobufField(FieldElement nativeField, FieldType type) {
        this(nativeField, type, null, null);
    }

    public ProtobufField(FieldElement nativeField, ProtobufMessage msg) {
        this(nativeField, FieldType.MESSAGE, msg, null);
    }

    public ProtobufField(FieldElement nativeField, ProtobufEnum et) {
        this(nativeField, FieldType.ENUM, null, et);
    }

    public static ProtobufField unknownField() {
        return new ProtobufField(null, FieldType.MESSAGE, null, null);
    }

    protected ProtobufField(FieldElement nativeField, FieldType type, ProtobufMessage msg, ProtobufEnum et) {
        this.type = type;
        this.wireType = type.getWireType();
        this.usesZigZag = type.usesZigZag();
        if (et == null) {
            this.enumValues = EnumLookup.empty();
            this.isStdEnum = false;
        } else {
            this.enumValues = EnumLookup.construct(et);
            this.isStdEnum = et.usesStandardIndexing();
        }
        this.messageType = msg;
        if (nativeField == null) {
            this.id = 0;
            this.typedTag = 0;
            this.packed = false;
            this.deprecated = false;
            this.required = false;
            this.repeated = false;
            this.name = "UNKNOWN";
        } else {
            this.id = nativeField.tag();
            this.typedTag = (this.id << 3) + this.wireType;
            this.name = nativeField.name();
            switch (nativeField.label()) {
                case REPEATED: {
                    this.required = false;
                    this.repeated = true;
                    break;
                }
                case REQUIRED: {
                    this.required = true;
                    this.repeated = false;
                    break;
                }
                default: {
                    this.repeated = false;
                    this.required = false;
                }
            }
            this.packed = ProtobufField._findBooleanOption(nativeField, "packed");
            this.deprecated = ProtobufField._findBooleanOption(nativeField, "deprecated");
        }
        this.isObject = type == FieldType.MESSAGE;
    }

    private static boolean _findBooleanOption(FieldElement f, String key) {
        for (OptionElement opt : f.options()) {
            if (!key.equals(opt.name())) continue;
            Object val = opt.value();
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            return "true".equals(String.valueOf(val).trim());
        }
        return false;
    }

    public void assignMessageType(ProtobufMessage msgType) {
        if (this.type != FieldType.MESSAGE) {
            throw new IllegalStateException("Can not assign message type for non-message field '" + this.name + "'");
        }
        this.messageType = msgType;
    }

    public void assignNext(ProtobufField n) {
        if (this.next != null) {
            throw new IllegalStateException("Can not overwrite 'next' after being set");
        }
        this.next = n;
    }

    public final ProtobufMessage getMessageType() {
        return this.messageType;
    }

    public final ProtobufField nextOrThisIf(int idToMatch) {
        if (this.next != null && this.next.id == idToMatch) {
            return this.next;
        }
        if (idToMatch == this.id) {
            return this;
        }
        return null;
    }

    public final ProtobufField nextIf(String nameToMatch) {
        if (this.next != null && (nameToMatch == this.next.name || nameToMatch.equals(this.next.name))) {
            return this.next;
        }
        return null;
    }

    public final int findEnumIndex(SerializableString key) {
        return this.enumValues.findEnumIndex(key);
    }

    public final int findEnumIndex(String key) {
        return this.enumValues.findEnumIndex(key);
    }

    public final String findEnumByIndex(int index) {
        return this.enumValues.findEnumByIndex(index);
    }

    public Collection<String> getEnumValues() {
        return this.enumValues.getEnumValues();
    }

    public final boolean isArray() {
        return this.repeated;
    }

    public final boolean isValidFor(int typeTag) {
        return typeTag == this.type.getWireType() || this.packed && this.repeated && typeTag == 2;
    }

    public String toString() {
        return "Field '" + this.name + "', tag=" + this.typedTag + ", wireType=" + this.wireType + ", fieldType=" + (Object)((Object)this.type);
    }

    @Override
    public int compareTo(ProtobufField other) {
        return this.id - other.id;
    }
}

