/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf.schema;

import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.MessageElement;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.ProtoFile;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.TypeElement;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufSchema;
import com.fasterxml.jackson.dataformat.protobuf.schema.TypeResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class NativeProtobufSchema {
    protected final String _name;
    protected final Collection<TypeElement> _nativeTypes;
    protected volatile String[] _messageNames;

    protected NativeProtobufSchema(ProtoFile input) {
        this(input.filePath(), input.typeElements());
    }

    protected NativeProtobufSchema(String name, Collection<TypeElement> types) {
        this._name = name;
        this._nativeTypes = types;
    }

    public static NativeProtobufSchema construct(ProtoFile input) {
        return new NativeProtobufSchema(input);
    }

    public static NativeProtobufSchema construct(String name, Collection<TypeElement> types) {
        return new NativeProtobufSchema(name, types);
    }

    public boolean hasMessageType(String messageTypeName) {
        for (TypeElement type : this._nativeTypes) {
            if (!messageTypeName.equals(type.name()) || !(type instanceof MessageElement)) continue;
            return true;
        }
        return false;
    }

    public ProtobufSchema forType(String messageTypeName) {
        MessageElement msg = this._messageType(messageTypeName);
        if (msg == null) {
            throw new IllegalArgumentException("Protobuf schema definition (name '" + this._name + "') has no message type with name '" + messageTypeName + "': known types: " + this.getMessageNames());
        }
        return new ProtobufSchema(this, TypeResolver.resolve(this._nativeTypes, msg));
    }

    public ProtobufSchema forFirstType() {
        MessageElement msg = this._firstMessageType();
        if (msg == null) {
            throw new IllegalArgumentException("Protobuf schema definition (name '" + this._name + "') contains no message type definitions");
        }
        return new ProtobufSchema(this, TypeResolver.resolve(this._nativeTypes, msg));
    }

    public List<String> getMessageNames() {
        if (this._messageNames == null) {
            this._messageNames = this._getMessageNames();
        }
        return Arrays.asList(this._messageNames);
    }

    public String toString() {
        return this.toString(this._name);
    }

    public String toString(String name) {
        ProtoFile.Builder builder = ProtoFile.builder(name);
        builder.addTypes(this._nativeTypes);
        return builder.build().toSchema();
    }

    protected MessageElement _firstMessageType() {
        for (TypeElement type : this._nativeTypes) {
            if (!(type instanceof MessageElement)) continue;
            return (MessageElement)type;
        }
        return null;
    }

    protected MessageElement _messageType(String name) {
        for (TypeElement type : this._nativeTypes) {
            if (!(type instanceof MessageElement) || !name.equals(type.name())) continue;
            return (MessageElement)type;
        }
        return null;
    }

    private String[] _getMessageNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (TypeElement type : this._nativeTypes) {
            if (!(type instanceof MessageElement)) continue;
            names.add(type.name());
        }
        return names.toArray(new String[names.size()]);
    }
}

