/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf.schema;

import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.dataformat.protobuf.schema.FieldLookup;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufField;
import java.util.Arrays;

public class ProtobufMessage {
    private static final ProtobufField[] NO_FIELDS = new ProtobufField[0];
    private static final int MAX_FIELD_INDEX_SIZE = 200;
    protected final String _name;
    protected final ProtobufField[] _fields;
    protected FieldLookup _fieldsByName;
    protected ProtobufField[] _fieldsById;
    protected ProtobufField _firstField;
    protected int _idOffset = -1;

    public ProtobufMessage(String name, ProtobufField[] fields) {
        this._name = name;
        this._fields = fields;
    }

    public void init(ProtobufField first) {
        this._firstField = first;
        this._fieldsByName = FieldLookup.construct(this._fields);
        int len = this._fields.length;
        if (len > 0) {
            int firstId = this._fields[0].id;
            int lastId = this._fields[len - 1].id;
            if (firstId > lastId) {
                throw new IllegalStateException("Internal error: first id (" + firstId + ") > last id (" + lastId + ")");
            }
            int size = lastId - firstId + 1;
            if (size <= 200) {
                this._idOffset = firstId;
                this._fieldsById = new ProtobufField[size];
                for (ProtobufField f : this._fields) {
                    int index = f.id - this._idOffset;
                    if (this._fieldsById[index] != null) {
                        throw new IllegalStateException("Internal error: collision for message of type '" + this._name + "' for id " + f.id);
                    }
                    this._fieldsById[index] = f;
                }
            }
        }
    }

    public static ProtobufMessage bogusMessage(String desc) {
        ProtobufMessage bogus = new ProtobufMessage(desc, NO_FIELDS);
        bogus.init(null);
        return bogus;
    }

    public ProtobufField firstField() {
        return this._firstField;
    }

    public ProtobufField firstIf(String name) {
        ProtobufField f = this._firstField;
        if (f != null && name.equals(f.name)) {
            return f;
        }
        return this._fieldsByName.findField(name);
    }

    public int getFieldCount() {
        return this._fields.length;
    }

    public String getName() {
        return this._name;
    }

    public ProtobufField field(String name) {
        return this._fieldsByName.findField(name);
    }

    public ProtobufField field(int id) {
        int index;
        int idOffset = this._idOffset;
        if (idOffset >= 0 && (index = id - idOffset) < this._fieldsById.length && index >= 0) {
            return this._fieldsById[index];
        }
        for (ProtobufField f : this._fields) {
            if (f.id != id) continue;
            return f;
        }
        return null;
    }

    public ProtobufField field(SerializableString name) {
        return this._fieldsByName.findField(name.getValue());
    }

    public String fieldsAsString() {
        return Arrays.asList(this._fields).toString();
    }

    public Iterable<ProtobufField> fields() {
        return Arrays.asList(this._fields);
    }
}

