/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser;

import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.Utils;
import java.util.Locale;

public interface DataType {
    public Kind kind();

    public static final class NamedType
    implements DataType {
        private final String name;

        public static NamedType create(String name) {
            return new NamedType(Utils.checkNotNull(name, "name"));
        }

        private NamedType(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        @Override
        public Kind kind() {
            return Kind.NAMED;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof NamedType)) {
                return false;
            }
            NamedType other = (NamedType)obj;
            return this.name.equals(other.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static final class MapType
    implements DataType {
        private final DataType keyType;
        private final DataType valueType;

        public static MapType create(DataType keyType, DataType valueType) {
            return new MapType(Utils.checkNotNull(keyType, "keyType"), Utils.checkNotNull(valueType, "valueType"));
        }

        private MapType(DataType keyType, DataType valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public Kind kind() {
            return Kind.MAP;
        }

        public DataType keyType() {
            return this.keyType;
        }

        public DataType valueType() {
            return this.valueType;
        }

        public String toString() {
            return "map<" + this.keyType + ", " + this.valueType + ">";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MapType)) {
                return false;
            }
            MapType other = (MapType)obj;
            return this.keyType.equals(other.keyType) && this.valueType.equals(other.valueType);
        }

        public int hashCode() {
            return this.keyType.hashCode() * 37 + this.valueType.hashCode();
        }
    }

    public static enum ScalarType implements DataType
    {
        ANY,
        BOOL,
        BYTES,
        DOUBLE,
        FLOAT,
        FIXED32,
        FIXED64,
        INT32,
        INT64,
        SFIXED32,
        SFIXED64,
        SINT32,
        SINT64,
        STRING,
        UINT32,
        UINT64;


        @Override
        public Kind kind() {
            return Kind.SCALAR;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    public static enum Kind {
        SCALAR,
        MAP,
        NAMED;

    }
}

