/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf.schemagen;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.TypeElementBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DefinedTypeElementBuilders {
    protected Map<JavaType, TypeElementBuilder> _definedTypeElementBuilders = new LinkedHashMap<JavaType, TypeElementBuilder>();
    protected Set<JavaType> _isNestedType = new HashSet<JavaType>();

    public void addTypeElement(JavaType type, TypeElementBuilder builder, boolean isNested) {
        if (this._definedTypeElementBuilders.containsKey(type)) {
            if (this._definedTypeElementBuilders.get(type) != builder) {
                throw new IllegalStateException("Trying to redefine TypeElementBuilder for type " + type);
            }
        } else {
            this._definedTypeElementBuilders.put(type, builder);
        }
        if (isNested) {
            this._isNestedType.add(type);
        }
    }

    public boolean containsBuilderFor(JavaType type) {
        return this._definedTypeElementBuilders.containsKey(type);
    }

    public TypeElementBuilder getBuilderFor(JavaType type) {
        return this._definedTypeElementBuilders.get(type);
    }

    public Set<TypeElementBuilder> getAllBuilders() {
        return new HashSet<TypeElementBuilder>(this._definedTypeElementBuilders.values());
    }

    public Set<TypeElementBuilder> getAllNestedBuilders() {
        return this.getAllBuildersFor(this._isNestedType);
    }

    public Set<TypeElementBuilder> getDependencyBuilders() {
        return this.getNonNestedBuilders(true);
    }

    public Set<TypeElementBuilder> getNonNestedBuilders() {
        return this.getNonNestedBuilders(false);
    }

    public Set<TypeElementBuilder> getNonNestedBuilders(boolean excludeRoot) {
        Set<JavaType> types = this._definedTypeElementBuilders.keySet();
        types.removeAll(this._isNestedType);
        if (excludeRoot) {
            if (this._definedTypeElementBuilders.isEmpty()) {
                throw new IllegalStateException("DefinedTypeElementBuilders._definedTypeElementBuilders is empty");
            }
            types.remove(this._definedTypeElementBuilders.keySet().iterator().next());
        }
        return this.getAllBuildersFor(types);
    }

    protected HashSet<TypeElementBuilder> getAllBuildersFor(Collection<JavaType> types) {
        HashSet<TypeElementBuilder> nestedBuilder = new HashSet<TypeElementBuilder>();
        for (JavaType type : types) {
            nestedBuilder.add(this.getBuilderFor(type));
        }
        return nestedBuilder;
    }
}

