/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.javaprop;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsFactory;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsGenerator;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsSchema;
import com.fasterxml.jackson.dataformat.javaprop.PackageVersion;
import java.io.IOException;
import java.util.Properties;

public class JavaPropsMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public JavaPropsMapper() {
        this(new JavaPropsFactory());
    }

    public JavaPropsMapper(JavaPropsFactory f) {
        super((JsonFactory)f);
    }

    protected JavaPropsMapper(JavaPropsMapper src) {
        super((ObjectMapper)src);
    }

    public JavaPropsMapper copy() {
        this._checkInvalidCopy(JavaPropsMapper.class);
        return new JavaPropsMapper(this);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public JavaPropsFactory getFactory() {
        return (JavaPropsFactory)this._jsonFactory;
    }

    public <T> T readValue(Properties props, Class<T> valueType) throws IOException {
        return (T)this.readValue((JsonParser)this.getFactory().createParser(props), valueType);
    }

    public <T> T readValue(Properties props, JavaType valueType) throws IOException {
        return (T)this.readValue((JsonParser)this.getFactory().createParser(props), valueType);
    }

    public void writeValue(Properties targetProps, Object value) throws IOException {
        if (targetProps == null) {
            throw new IllegalArgumentException("Can not pass null Properties as target");
        }
        JavaPropsGenerator g = this.getFactory().createGenerator(targetProps);
        this.writeValue((JsonGenerator)g, value);
        g.close();
    }

    public void writeValue(Properties targetProps, Object value, JavaPropsSchema schema) throws IOException {
        if (targetProps == null) {
            throw new IllegalArgumentException("Can not pass null Properties as target");
        }
        JavaPropsGenerator g = this.getFactory().createGenerator(targetProps);
        if (schema != null) {
            g.setSchema(schema);
        }
        this.writeValue((JsonGenerator)g, value);
        g.close();
    }

    public Properties writeValueAsProperties(Object value) throws IOException {
        Properties props = new Properties();
        this.writeValue(props, value);
        return props;
    }

    public Properties writeValueAsProperties(Object value, JavaPropsSchema schema) throws IOException {
        Properties props = new Properties();
        this.writeValue(props, value, schema);
        return props;
    }
}

