/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion.ionvalue;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.dataformat.ion.ionvalue.IonValueDeserializer;
import software.amazon.ion.IonContainer;
import software.amazon.ion.IonValue;

class DeserializersEx
extends SimpleDeserializers {
    private static final long serialVersionUID = 1L;
    private static final IonValueDeserializer ION_VALUE_DESERIALIZER = new IonValueDeserializer();

    DeserializersEx() {
    }

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (IonValue.class.isAssignableFrom(type.getRawClass())) {
            return ION_VALUE_DESERIALIZER;
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }

    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        if (IonContainer.class.isAssignableFrom(type.getRawClass())) {
            return ION_VALUE_DESERIALIZER;
        }
        return super.findCollectionDeserializer(type, config, beanDesc, elementTypeDeserializer, elementDeserializer);
    }
}

