/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.ion.IonFactory;
import com.fasterxml.jackson.dataformat.ion.IonTimestampDeserializers;
import com.fasterxml.jackson.dataformat.ion.IonTimestampSerializers;
import com.fasterxml.jackson.dataformat.ion.PackageVersion;
import java.io.IOException;
import java.sql.Date;
import software.amazon.ion.IonContainer;
import software.amazon.ion.IonDatagram;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonValue;
import software.amazon.ion.IonWriter;

public class IonObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public IonObjectMapper() {
        this(new IonFactory());
    }

    public IonObjectMapper(IonFactory f) {
        super((JsonFactory)f);
        f.setCodec((ObjectCodec)this);
        SimpleModule m = new SimpleModule("IonTimestampModule", PackageVersion.VERSION);
        m.addSerializer(java.util.Date.class, (JsonSerializer)new IonTimestampSerializers.IonTimestampJavaDateSerializer());
        m.addSerializer(Date.class, (JsonSerializer)new IonTimestampSerializers.IonTimestampSQLDateSerializer());
        m.addDeserializer(java.util.Date.class, (JsonDeserializer)new IonTimestampDeserializers.IonTimestampJavaDateDeserializer());
        m.addDeserializer(Date.class, (JsonDeserializer)new IonTimestampDeserializers.IonTimestampSQLDateDeserializer());
        this.registerModule((Module)m);
    }

    protected IonObjectMapper(IonObjectMapper src) {
        super((ObjectMapper)src);
    }

    public void setCreateBinaryWriters(boolean bin) {
        this.getFactory().setCreateBinaryWriters(bin);
    }

    public ObjectMapper copy() {
        this._checkInvalidCopy(IonObjectMapper.class);
        return new IonObjectMapper(this);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public IonFactory getFactory() {
        return (IonFactory)this._jsonFactory;
    }

    public <T> T readValue(IonReader r, Class<T> valueType) throws IOException {
        return (T)this._readMapAndClose((JsonParser)this.getFactory().createParser(r), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(IonReader r, TypeReference valueTypeRef) throws IOException {
        return (T)this._readMapAndClose((JsonParser)this.getFactory().createParser(r), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(IonReader r, JavaType valueType) throws IOException {
        return (T)this._readMapAndClose((JsonParser)this.getFactory().createParser(r), valueType);
    }

    public <T> T readValue(IonValue value, Class<T> valueType) throws IOException {
        return (T)this._readMapAndClose((JsonParser)this.getFactory().createParser(value), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(IonValue value, TypeReference valueTypeRef) throws IOException {
        return (T)this._readMapAndClose((JsonParser)this.getFactory().createParser(value), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(IonValue value, JavaType valueType) throws IOException {
        return (T)this._readMapAndClose((JsonParser)this.getFactory().createParser(value), valueType);
    }

    public void writeValue(IonWriter w, Object value) throws IOException {
        this._configAndWriteValue(this.getFactory().createGenerator(w), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IonValue writeValueAsIonValue(Object value) throws IOException {
        IonFactory f = this.getFactory();
        IonDatagram container = f._system.newDatagram();
        try (IonWriter writer = f._system.newWriter((IonContainer)container);){
            this.writeValue(writer, value);
            IonValue result = container.get(0);
            result.removeFromContainer();
            IonValue ionValue = result;
            return ionValue;
        }
    }
}

