/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.dataformat.ion.PackageVersion;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.IonWriter;
import software.amazon.ion.Timestamp;

public class IonGenerator
extends GeneratorBase {
    protected final IonWriter _writer;
    protected final IOContext _ioContext;
    protected final Closeable _destination;

    public IonGenerator(int features, ObjectCodec codec, IonWriter ion, IOContext ctxt, Closeable dst) {
        super(features, codec);
        this._writer = ion;
        this._ioContext = ctxt;
        this._destination = dst;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._writer.close();
            if (this._ioContext.isResourceManaged()) {
                this._destination.close();
            } else if (this._destination instanceof Flushable) {
                ((Flushable)((Object)this._destination)).flush();
            }
        }
    }

    public void flush() throws IOException {
        Object dst = this._ioContext.getSourceReference();
        if (dst instanceof Flushable) {
            ((Flushable)dst).flush();
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    public boolean canWriteTypeId() {
        return true;
    }

    public boolean canWriteBinaryNatively() {
        return true;
    }

    public void writeNumber(int value) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write numeric value");
        this._writer.writeInt((long)value);
    }

    public void writeNumber(long value) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write numeric value");
        this._writer.writeInt(value);
    }

    public void writeNumber(BigInteger value) throws IOException, JsonGenerationException {
        if (value == null) {
            this.writeNull();
        } else {
            this._verifyValueWrite("write numeric value");
            this._writer.writeInt(value);
        }
    }

    public void writeNumber(double value) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write numeric value");
        this._writer.writeFloat(value);
    }

    public void writeNumber(float value) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write numeric value");
        this._writer.writeFloat((double)value);
    }

    public void writeNumber(BigDecimal value) throws IOException, JsonGenerationException {
        if (value == null) {
            this.writeNull();
        } else {
            this._verifyValueWrite("write numeric value");
            this._writer.writeDecimal(value);
        }
    }

    public void writeNumber(String value) throws IOException, JsonGenerationException, UnsupportedOperationException {
        this.writeString(value);
    }

    public void writeSymbol(String value) throws JsonGenerationException, IOException {
        this._verifyValueWrite("write symbol value");
        this._writer.writeSymbol(value);
    }

    public void annotateNextValue(String annotation) {
        this._writer.addTypeAnnotation(annotation);
    }

    public void writeDate(Calendar value) throws JsonGenerationException, IOException {
        this._verifyValueWrite("write date value");
        this._writer.writeTimestamp(Timestamp.forCalendar((Calendar)value));
    }

    public void writeString(String value) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        this._writer.writeString(value);
    }

    public void writeString(char[] buffer, int offset, int length) throws IOException, JsonGenerationException {
        this.writeString(new String(buffer, offset, length));
    }

    public void writeUTF8String(byte[] buffer, int offset, int length) throws IOException, JsonGenerationException {
        this.writeString(new String(buffer, offset, length, "UTF-8"));
    }

    public void writeRaw(String value) throws IOException, JsonGenerationException {
        this._reportNoRaw();
    }

    public void writeRaw(char value) throws IOException, JsonGenerationException {
        this._reportNoRaw();
    }

    public void writeRaw(String value, int arg1, int arg2) throws IOException, JsonGenerationException {
        this._reportNoRaw();
    }

    public void writeRaw(char[] value, int arg1, int arg2) throws IOException, JsonGenerationException {
        this._reportNoRaw();
    }

    public void writeRawValue(String value) throws IOException, JsonGenerationException {
        this._reportNoRaw();
    }

    public void writeRawValue(String value, int arg1, int arg2) throws IOException, JsonGenerationException {
        this._reportNoRaw();
    }

    public void writeRawValue(char[] value, int arg1, int arg2) throws IOException, JsonGenerationException {
        this._reportNoRaw();
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException, JsonGenerationException {
        this._reportNoRaw();
    }

    public void writeBinary(Base64Variant b64v, byte[] data, int offset, int length) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write binary data");
        this._writer.writeBlob(data, offset, length);
    }

    public void writeBoolean(boolean value) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write boolean");
        this._writer.writeBool(value);
    }

    public void writeNull() throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null");
        this._writer.writeNull();
    }

    public void writeNull(IonType ionType) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null");
        this._writer.writeNull(ionType);
    }

    public void writeObject(Object pojo) throws IOException, JsonProcessingException {
        if (pojo == null) {
            this.writeNull();
        } else {
            if (this._objectCodec == null) {
                throw new IllegalStateException("No ObjectCodec defined for the generator, can not serialize regular Java objects");
            }
            this._objectCodec.writeValue((JsonGenerator)this, pojo);
        }
    }

    public void writeValue(IonValue value) throws IOException {
        this._verifyValueWrite("write ion value");
        if (value == null) {
            this._writer.writeNull();
        } else {
            value.writeTo(this._writer);
        }
    }

    public void writeValue(Timestamp value) throws IOException {
        this._verifyValueWrite("write timestamp");
        if (value == null) {
            this._writer.writeNull();
        } else {
            this._writer.writeTimestamp(value);
        }
    }

    protected void _releaseBuffers() {
    }

    protected void _verifyValueWrite(String msg) throws IOException, JsonGenerationException {
        int status = this._writeContext.writeValue();
        if (status == 5) {
            this._reportError("Can not " + msg + ", expecting field name");
        }
        if (this._cfgPrettyPrinter != null) {
            switch (status) {
                case 1: {
                    this._cfgPrettyPrinter.writeArrayValueSeparator((JsonGenerator)this);
                    break;
                }
                case 2: {
                    this._cfgPrettyPrinter.writeObjectFieldValueSeparator((JsonGenerator)this);
                    break;
                }
                case 3: {
                    this._cfgPrettyPrinter.writeRootValueSeparator((JsonGenerator)this);
                    break;
                }
                case 0: {
                    if (this._writeContext.inArray()) {
                        this._cfgPrettyPrinter.beforeArrayValues((JsonGenerator)this);
                        break;
                    }
                    if (!this._writeContext.inObject()) break;
                    this._cfgPrettyPrinter.beforeObjectEntries((JsonGenerator)this);
                    break;
                }
                default: {
                    throw new IllegalStateException("Should never occur; status " + status);
                }
            }
        }
    }

    public void writeEndArray() throws IOException, JsonGenerationException {
        this._writeContext = this._writeContext.getParent();
        this._writer.stepOut();
    }

    public void writeEndObject() throws IOException, JsonGenerationException {
        this._writeContext = this._writeContext.getParent();
        this._writer.stepOut();
    }

    public void writeFieldName(String value) throws IOException, JsonGenerationException {
        int status = this._writeContext.writeFieldName(value);
        if (status == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(value);
    }

    protected void _writeFieldName(String value) throws IOException, JsonGenerationException {
        this._writer.setFieldName(value);
    }

    public void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        this._writer.stepIn(IonType.LIST);
    }

    public void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        this._writer.stepIn(IonType.STRUCT);
    }

    public void writeTypeId(Object rawId) throws IOException {
        if (rawId instanceof String[]) {
            String[] ids;
            for (String id : ids = (String[])rawId) {
                this.annotateNextValue(id);
            }
        } else {
            this.annotateNextValue(String.valueOf(rawId));
        }
    }

    public WritableTypeId writeTypePrefix(WritableTypeId typeIdDef) throws IOException {
        JsonToken valueShape = typeIdDef.valueShape;
        typeIdDef.wrapperWritten = false;
        this.writeTypeId(typeIdDef.id);
        if (valueShape == JsonToken.START_OBJECT) {
            this.writeStartObject(typeIdDef.forValue);
        } else if (valueShape == JsonToken.START_ARRAY) {
            this.writeStartArray();
        }
        return typeIdDef;
    }

    public String toString() {
        return "[" + ((Object)((Object)this)).getClass().getSimpleName() + ", Ion writer: " + this._writer + "]";
    }

    protected void _reportNoRaw() throws IOException {
        throw new IOException("writeRaw() functionality not available with Ion backend");
    }
}

