/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonReadContext;
import com.fasterxml.jackson.dataformat.ion.PackageVersion;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import software.amazon.ion.IonContainer;
import software.amazon.ion.IonList;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.IonWriter;
import software.amazon.ion.Timestamp;
import software.amazon.ion.system.IonSystemBuilder;

public class IonParser
extends ParserMinimalBase {
    private static final BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger INT_MIN_VALUE = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger INT_MAX_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    protected final IonReader _reader;
    protected final IOContext _ioContext;
    protected ObjectCodec _objectCodec;
    private final IonSystem _system;
    protected boolean _closed;
    protected JsonReadContext _parsingContext;
    protected JsonToken _valueToken;

    @Deprecated
    public IonParser(IonReader r, IOContext ctxt) {
        this(r, ctxt, null);
    }

    @Deprecated
    public IonParser(IonReader r, IOContext ctxt, ObjectCodec codec) {
        this(r, IonSystemBuilder.standard().build(), ctxt, codec);
    }

    IonParser(IonReader r, IonSystem system, IOContext ctxt, ObjectCodec codec) {
        this._reader = r;
        this._ioContext = ctxt;
        this._objectCodec = codec;
        this._parsingContext = JsonReadContext.createRootContext((int)-1, (int)-1, null);
        this._system = system;
    }

    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean requiresCustomCodec() {
        return false;
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void close() throws IOException {
        if (!this._closed) {
            Object src;
            if (this._ioContext.isResourceManaged() && (src = this._ioContext.getSourceReference()) instanceof Closeable) {
                ((Closeable)src).close();
            }
            this._closed = true;
        }
    }

    public String getText() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    return this.getCurrentName();
                }
                case VALUE_STRING: {
                    return this._reader.stringValue();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    Number n = this.getNumberValue();
                    return n == null ? null : n.toString();
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Timestamp ts;
                    if (this._reader.getType() != IonType.TIMESTAMP || (ts = this._reader.timestampValue()) == null) break;
                    return ts.toString();
                }
            }
            return this._currToken.asString();
        }
        return null;
    }

    public char[] getTextCharacters() throws IOException {
        String str = this.getText();
        return str == null ? null : str.toCharArray();
    }

    public int getTextLength() throws IOException {
        return this.getText().length();
    }

    public int getTextOffset() throws IOException {
        return 0;
    }

    public BigInteger getBigIntegerValue() throws IOException {
        return this._reader.bigIntegerValue();
    }

    public BigDecimal getDecimalValue() throws IOException {
        return this._reader.bigDecimalValue();
    }

    public double getDoubleValue() throws IOException {
        return this._reader.doubleValue();
    }

    public float getFloatValue() throws IOException {
        return (float)this._reader.doubleValue();
    }

    public int getIntValue() throws IOException {
        return this._reader.intValue();
    }

    public long getLongValue() throws IOException {
        return this._reader.longValue();
    }

    public JsonParser.NumberType getNumberType() throws IOException {
        IonType type = this._reader.getType();
        if (type != null) {
            switch (type) {
                case DECIMAL: {
                    return JsonParser.NumberType.DOUBLE;
                }
                case INT: {
                    BigInteger i = this._reader.bigIntegerValue();
                    if (i.compareTo(LONG_MIN_VALUE) < 0 || i.compareTo(LONG_MAX_VALUE) > 0) {
                        return JsonParser.NumberType.BIG_INTEGER;
                    }
                    if (i.compareTo(INT_MIN_VALUE) < 0 || i.compareTo(INT_MAX_VALUE) > 0) {
                        return JsonParser.NumberType.LONG;
                    }
                    return JsonParser.NumberType.INT;
                }
            }
        }
        return null;
    }

    public Number getNumberValue() throws IOException {
        JsonParser.NumberType nt = this.getNumberType();
        if (nt != null) {
            switch (nt) {
                case INT: {
                    return this._reader.intValue();
                }
                case LONG: {
                    return this._reader.longValue();
                }
                case FLOAT: {
                    return Float.valueOf((float)this._reader.doubleValue());
                }
                case DOUBLE: {
                    return this._reader.doubleValue();
                }
                case BIG_DECIMAL: {
                    return this._reader.bigDecimalValue();
                }
                case BIG_INTEGER: {
                    return this.getBigIntegerValue();
                }
            }
        }
        return null;
    }

    public byte[] getBinaryValue(Base64Variant arg0) throws IOException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            switch (this._reader.getType()) {
                case BLOB: 
                case CLOB: {
                    return this._reader.newBytes();
                }
            }
        }
        return null;
    }

    private IonValue getIonValue() throws IOException {
        if (this._system == null) {
            throw new IllegalStateException("This " + ((Object)((Object)this)).getClass().getSimpleName() + " instance cannot be used for IonValue mapping");
        }
        this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
        IonList l = this._system.newEmptyList();
        IonWriter writer = this._system.newWriter((IonContainer)l);
        writer.writeValue(this._reader);
        IonValue v = l.get(0);
        v.removeFromContainer();
        return v;
    }

    public Object getEmbeddedObject() throws IOException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            switch (this._reader.getType()) {
                case TIMESTAMP: {
                    return this._reader.timestampValue();
                }
                case BLOB: 
                case CLOB: {
                    return this._reader.newBytes();
                }
            }
        }
        return this.getIonValue();
    }

    public JsonLocation getCurrentLocation() {
        return JsonLocation.NA;
    }

    public String getCurrentName() throws IOException {
        return this._parsingContext.getCurrentName();
    }

    public JsonStreamContext getParsingContext() {
        return this._parsingContext;
    }

    public JsonLocation getTokenLocation() {
        return JsonLocation.NA;
    }

    public JsonToken nextToken() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._currToken = this._valueToken;
            return this._currToken;
        }
        if (this._currToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
            this._reader.stepIn();
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
            this._reader.stepIn();
        }
        IonType type = this._reader.next();
        if (type == null) {
            if (this._parsingContext.inRoot()) {
                this.close();
                this._currToken = null;
            } else {
                this._parsingContext = this._parsingContext.getParent();
                this._currToken = this._reader.isInStruct() ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
                this._reader.stepOut();
            }
            return this._currToken;
        }
        boolean inStruct = !this._parsingContext.inRoot() && this._reader.isInStruct();
        this._parsingContext.setCurrentName(inStruct ? this._reader.getFieldName() : null);
        JsonToken t = this._tokenFromType(type);
        if (inStruct) {
            this._valueToken = t;
            this._currToken = JsonToken.FIELD_NAME;
            return this._currToken;
        }
        this._currToken = t;
        return this._currToken;
    }

    public String[] getTypeAnnotations() {
        return this._reader.getTypeAnnotations();
    }

    public JsonParser skipChildren() throws IOException {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int open = 1;
        while (true) {
            JsonToken t;
            if ((t = this.nextToken()) == null) {
                this._handleEOF();
                return this;
            }
            switch (t) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++open;
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    if (--open != 0) break;
                    return this;
                }
            }
        }
    }

    protected JsonToken _tokenFromType(IonType type) {
        if (this._reader.isNullValue()) {
            return JsonToken.VALUE_NULL;
        }
        switch (type) {
            case BOOL: {
                return this._reader.booleanValue() ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
            }
            case DECIMAL: 
            case FLOAT: {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            case INT: {
                return JsonToken.VALUE_NUMBER_INT;
            }
            case STRING: 
            case SYMBOL: {
                return JsonToken.VALUE_STRING;
            }
            case NULL: {
                return JsonToken.VALUE_NULL;
            }
            case LIST: 
            case SEXP: {
                return JsonToken.START_ARRAY;
            }
            case STRUCT: {
                return JsonToken.START_OBJECT;
            }
            case TIMESTAMP: {
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
        }
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    protected void _handleEOF() throws JsonParseException {
        if (!this._parsingContext.inRoot()) {
            this._reportError(": expected close marker for " + this._parsingContext.typeDesc() + " (from " + this._parsingContext.getStartLocation(this._ioContext.getSourceReference()) + ")");
        }
    }

    public void overrideCurrentName(String name) {
        try {
            this._parsingContext.setCurrentName(name);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

