/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion.polymorphism;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.dataformat.ion.IonGenerator;
import com.fasterxml.jackson.dataformat.ion.polymorphism.MultipleTypeIdResolver;
import java.io.IOException;

public class IonAnnotationTypeSerializer
extends TypeSerializer {
    private final TypeIdResolver typeIdResolver;

    IonAnnotationTypeSerializer(TypeIdResolver typeIdResolver) {
        this.typeIdResolver = typeIdResolver;
    }

    public JsonTypeInfo.As getTypeInclusion() {
        return null;
    }

    public String getPropertyName() {
        return null;
    }

    public TypeIdResolver getTypeIdResolver() {
        return this.typeIdResolver;
    }

    private IonGenerator ionGenerator(JsonGenerator g) throws JsonGenerationException {
        if (g instanceof IonGenerator) {
            return (IonGenerator)g;
        }
        throw new JsonGenerationException("Can only use IonTypeSerializer with IonGenerator", g);
    }

    public void writeTypePrefixForScalar(Object value, JsonGenerator g) throws IOException {
    }

    public void writeTypePrefixForObject(Object value, JsonGenerator g) throws IOException {
        TypeIdResolver resolver = this.getTypeIdResolver();
        if (resolver instanceof MultipleTypeIdResolver) {
            String[] ids;
            for (String id : ids = ((MultipleTypeIdResolver)resolver).idsFromValue(value)) {
                this.ionGenerator(g).annotateNextValue(id);
            }
        } else {
            String id = this.getTypeIdResolver().idFromValue(value);
            if (null != id && !id.isEmpty()) {
                this.ionGenerator(g).annotateNextValue(id);
            }
        }
        g.writeStartObject();
    }

    public void writeTypePrefixForArray(Object value, JsonGenerator g) throws IOException {
        g.writeStartArray();
    }

    public void writeTypeSuffixForScalar(Object value, JsonGenerator g) throws IOException {
    }

    public void writeTypeSuffixForObject(Object value, JsonGenerator g) throws IOException {
        g.writeEndObject();
    }

    public void writeTypeSuffixForArray(Object value, JsonGenerator g) throws IOException {
        g.writeEndArray();
    }

    public TypeSerializer forProperty(BeanProperty prop) {
        return this;
    }

    public void writeCustomTypePrefixForScalar(Object value, JsonGenerator g, String typeId) throws IOException {
    }

    public void writeCustomTypePrefixForObject(Object value, JsonGenerator g, String typeId) throws IOException {
    }

    public void writeCustomTypePrefixForArray(Object value, JsonGenerator g, String typeId) throws IOException {
    }

    public void writeCustomTypeSuffixForScalar(Object value, JsonGenerator g, String typeId) throws IOException {
    }

    public void writeCustomTypeSuffixForObject(Object value, JsonGenerator g, String typeId) throws IOException {
    }

    public void writeCustomTypeSuffixForArray(Object value, JsonGenerator g, String typeId) throws IOException {
    }
}

