/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion;

import com.amazon.ion.IntegerSize;
import com.amazon.ion.IonContainer;
import com.amazon.ion.IonException;
import com.amazon.ion.IonList;
import com.amazon.ion.IonReader;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonType;
import com.amazon.ion.IonValue;
import com.amazon.ion.IonWriter;
import com.amazon.ion.Timestamp;
import com.amazon.ion.UnknownSymbolException;
import com.amazon.ion.system.IonSystemBuilder;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonReadContext;
import com.fasterxml.jackson.core.util.JacksonFeature;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.dataformat.ion.IonFactory;
import com.fasterxml.jackson.dataformat.ion.PackageVersion;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class IonParser
extends ParserMinimalBase {
    protected static final JacksonFeatureSet<StreamReadCapability> ION_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES.with((JacksonFeature)StreamReadCapability.EXACT_FLOATS);
    protected final IonReader _reader;
    protected final IOContext _ioContext;
    protected ObjectCodec _objectCodec;
    private final IonSystem _system;
    protected boolean _closed;
    protected JsonReadContext _parsingContext;
    protected JsonToken _valueToken;
    protected int _formatFeatures;

    @Deprecated
    public IonParser(IonReader r, IOContext ctxt) {
        this(r, ctxt, null);
    }

    @Deprecated
    public IonParser(IonReader r, IOContext ctxt, ObjectCodec codec) {
        this(r, IonSystemBuilder.standard().build(), ctxt, codec, IonFactory.DEFAULT_ION_PARSER_FEATURE_FLAGS);
    }

    IonParser(IonReader r, IonSystem system, IOContext ctxt, ObjectCodec codec, int ionParserFeatures) {
        this._reader = r;
        this._ioContext = ctxt;
        this._objectCodec = codec;
        this._parsingContext = JsonReadContext.createRootContext((int)-1, (int)-1, null);
        this._system = system;
        this._formatFeatures = ionParserFeatures;
    }

    public StreamReadConstraints streamReadConstraints() {
        return this._ioContext.streamReadConstraints();
    }

    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public IonSystem getIonSystem() {
        return this._system;
    }

    public boolean canReadTypeId() {
        return Feature.USE_NATIVE_TYPE_ID.enabledIn(this._formatFeatures);
    }

    public boolean requiresCustomCodec() {
        return false;
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return ION_READ_CAPABILITIES;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void close() throws IOException {
        if (!this._closed) {
            Object src;
            if (this._ioContext.isResourceManaged() && (src = this._ioContext.contentReference().getRawContent()) instanceof Closeable) {
                ((Closeable)src).close();
            }
            this._closed = true;
        }
    }

    public String getText() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    return this.getCurrentName();
                }
                case VALUE_STRING: {
                    try {
                        return this._reader.stringValue();
                    }
                    catch (UnknownSymbolException e) {
                        throw this._constructError(e.getMessage(), e);
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    Number n = this.getNumberValue();
                    return n == null ? null : n.toString();
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Timestamp ts;
                    if (this._reader.getType() != IonType.TIMESTAMP || (ts = this._reader.timestampValue()) == null) break;
                    return ts.toString();
                }
            }
            return this._currToken.asString();
        }
        return null;
    }

    public char[] getTextCharacters() throws IOException {
        String str = this.getText();
        return str == null ? null : str.toCharArray();
    }

    public int getTextLength() throws IOException {
        return this.getText().length();
    }

    public int getTextOffset() throws IOException {
        return 0;
    }

    public BigInteger getBigIntegerValue() throws IOException {
        return this._reader.bigIntegerValue();
    }

    public BigDecimal getDecimalValue() throws IOException {
        return this._reader.bigDecimalValue();
    }

    public double getDoubleValue() throws IOException {
        return this._reader.doubleValue();
    }

    public float getFloatValue() throws IOException {
        return (float)this._reader.doubleValue();
    }

    public int getIntValue() throws IOException {
        return this._reader.intValue();
    }

    public long getLongValue() throws IOException {
        return this._reader.longValue();
    }

    public JsonParser.NumberType getNumberType() throws IOException {
        IonType type = this._reader.getType();
        if (type != null) {
            switch (type) {
                case DECIMAL: {
                    return JsonParser.NumberType.BIG_DECIMAL;
                }
                case INT: {
                    IntegerSize size = this._reader.getIntegerSize();
                    switch (size) {
                        case INT: {
                            return JsonParser.NumberType.INT;
                        }
                        case LONG: {
                            return JsonParser.NumberType.LONG;
                        }
                    }
                    return JsonParser.NumberType.BIG_INTEGER;
                }
                case FLOAT: {
                    return JsonParser.NumberType.DOUBLE;
                }
            }
        }
        return null;
    }

    public Number getNumberValue() throws IOException {
        JsonParser.NumberType nt = this.getNumberType();
        if (nt != null) {
            switch (nt) {
                case INT: {
                    return this._reader.intValue();
                }
                case LONG: {
                    return this._reader.longValue();
                }
                case FLOAT: {
                    return Float.valueOf((float)this._reader.doubleValue());
                }
                case DOUBLE: {
                    return this._reader.doubleValue();
                }
                case BIG_DECIMAL: {
                    return this._reader.bigDecimalValue();
                }
                case BIG_INTEGER: {
                    return this.getBigIntegerValue();
                }
            }
        }
        return null;
    }

    public final Number getNumberValueExact() throws IOException {
        return this.getNumberValue();
    }

    public byte[] getBinaryValue(Base64Variant arg0) throws IOException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            switch (this._reader.getType()) {
                case BLOB: 
                case CLOB: {
                    return this._reader.newBytes();
                }
            }
        }
        return null;
    }

    private IonValue getIonValue() throws IOException {
        if (this._system == null) {
            throw new IllegalStateException("This " + ((Object)((Object)this)).getClass().getSimpleName() + " instance cannot be used for IonValue mapping");
        }
        this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
        IonList l = this._system.newEmptyList();
        IonWriter writer = this._system.newWriter((IonContainer)l);
        writer.writeValue(this._reader);
        IonValue v = l.get(0);
        v.removeFromContainer();
        return v;
    }

    public Object getEmbeddedObject() throws IOException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            switch (this._reader.getType()) {
                case TIMESTAMP: {
                    try {
                        return this._reader.timestampValue();
                    }
                    catch (IllegalArgumentException e) {
                        throw this._constructError(String.format("Invalid embedded TIMESTAMP value, problem: %s", e.getMessage()), e);
                    }
                }
                case BLOB: 
                case CLOB: {
                    return this._reader.newBytes();
                }
            }
        }
        return this.getIonValue();
    }

    public Object getTypeId() throws IOException {
        String[] typeAnnotations = this.getTypeAnnotations();
        return typeAnnotations.length == 0 ? null : typeAnnotations[0];
    }

    public JsonLocation getCurrentLocation() {
        return JsonLocation.NA;
    }

    public String getCurrentName() throws IOException {
        return this._parsingContext.getCurrentName();
    }

    public JsonStreamContext getParsingContext() {
        return this._parsingContext;
    }

    public JsonLocation getTokenLocation() {
        return JsonLocation.NA;
    }

    public JsonToken nextToken() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._currToken = this._valueToken;
            return this._currToken;
        }
        if (this._currToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
            this._reader.stepIn();
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
            this._reader.stepIn();
        }
        IonType type = null;
        try {
            type = this._reader.next();
        }
        catch (IonException e) {
            this._wrapError(e.getMessage(), e);
        }
        if (type == null) {
            if (this._parsingContext.inRoot()) {
                this.close();
                this._currToken = null;
            } else {
                this._parsingContext = this._parsingContext.getParent();
                this._currToken = this._reader.isInStruct() ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
                this._reader.stepOut();
            }
            return this._currToken;
        }
        boolean inStruct = !this._parsingContext.inRoot() && this._reader.isInStruct();
        try {
            this._parsingContext.setCurrentName(inStruct ? this._reader.getFieldName() : null);
        }
        catch (UnknownSymbolException e) {
            this._wrapError(e.getMessage(), e);
        }
        JsonToken t = this._tokenFromType(type);
        if (inStruct) {
            this._valueToken = t;
            this._currToken = JsonToken.FIELD_NAME;
            return this._currToken;
        }
        this._currToken = t;
        return this._currToken;
    }

    public String[] getTypeAnnotations() throws JsonParseException {
        try {
            return this._reader.getTypeAnnotations();
        }
        catch (UnknownSymbolException e) {
            throw this._constructError(e.getMessage(), e);
        }
    }

    public JsonParser skipChildren() throws IOException {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int open = 1;
        while (true) {
            JsonToken t;
            if ((t = this.nextToken()) == null) {
                this._handleEOF();
                return this;
            }
            switch (t) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++open;
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    if (--open != 0) break;
                    return this;
                }
            }
        }
    }

    protected JsonToken _tokenFromType(IonType type) {
        if (this._reader.isNullValue()) {
            return JsonToken.VALUE_NULL;
        }
        switch (type) {
            case BOOL: {
                return this._reader.booleanValue() ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
            }
            case DECIMAL: 
            case FLOAT: {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            case INT: {
                return JsonToken.VALUE_NUMBER_INT;
            }
            case STRING: 
            case SYMBOL: {
                return JsonToken.VALUE_STRING;
            }
            case NULL: {
                return JsonToken.VALUE_NULL;
            }
            case LIST: 
            case SEXP: {
                return JsonToken.START_ARRAY;
            }
            case STRUCT: {
                return JsonToken.START_OBJECT;
            }
            case TIMESTAMP: {
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
        }
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    protected void _handleEOF() throws JsonParseException {
        if (!this._parsingContext.inRoot()) {
            this._reportError(": expected close marker for " + this._parsingContext.typeDesc() + " (from " + this._parsingContext.startLocation(this._ioContext.contentReference()) + ")");
        }
    }

    public void overrideCurrentName(String name) {
        try {
            this._parsingContext.setCurrentName(name);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static enum Feature implements FormatFeature
    {
        USE_NATIVE_TYPE_ID(true);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

