/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion.polymorphism;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.dataformat.ion.polymorphism.IonAnnotationTypeDeserializer;
import com.fasterxml.jackson.dataformat.ion.polymorphism.IonAnnotationTypeSerializer;
import java.util.Collection;

public class IonAnnotationTypeResolverBuilder
implements TypeResolverBuilder<IonAnnotationTypeResolverBuilder> {
    private Class<?> defaultImpl;
    private TypeIdResolver typeIdResolver;
    private boolean typeIdVisible;

    public IonAnnotationTypeResolverBuilder() {
    }

    protected IonAnnotationTypeResolverBuilder(IonAnnotationTypeResolverBuilder base, Class<?> defaultImpl) {
        this.typeIdResolver = base.typeIdResolver;
        this.typeIdVisible = base.typeIdVisible;
        this.defaultImpl = defaultImpl;
    }

    public Class<?> getDefaultImpl() {
        return this.defaultImpl;
    }

    public TypeSerializer buildTypeSerializer(SerializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        return new IonAnnotationTypeSerializer(this.typeIdResolver);
    }

    public TypeDeserializer buildTypeDeserializer(DeserializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        JavaType defImplType = this.defaultImpl == null ? null : config.constructSpecializedType(baseType, this.defaultImpl);
        return new IonAnnotationTypeDeserializer(baseType, this.typeIdResolver, null, this.typeIdVisible, defImplType);
    }

    public IonAnnotationTypeResolverBuilder init(JsonTypeInfo.Id idType, TypeIdResolver res) {
        this.typeIdResolver = res;
        return this;
    }

    public IonAnnotationTypeResolverBuilder inclusion(JsonTypeInfo.As includeAs) {
        return this;
    }

    public IonAnnotationTypeResolverBuilder typeProperty(String propName) {
        return this;
    }

    public IonAnnotationTypeResolverBuilder defaultImpl(Class<?> di) {
        this.defaultImpl = di;
        return this;
    }

    public IonAnnotationTypeResolverBuilder typeIdVisibility(boolean isVisible) {
        this.typeIdVisible = isVisible;
        return this;
    }

    public IonAnnotationTypeResolverBuilder withDefaultImpl(Class<?> newDefaultImpl) {
        if (newDefaultImpl == this.defaultImpl) {
            return this;
        }
        return new IonAnnotationTypeResolverBuilder(this, this.defaultImpl);
    }
}

