/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion.ionvalue;

import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazon.ion.Timestamp;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.ion.IonParser;
import java.io.IOException;

class IonValueDeserializer
extends JsonDeserializer<IonValue> {
    IonValueDeserializer() {
    }

    public IonValue deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Object embeddedObject = jp.getEmbeddedObject();
        if (embeddedObject instanceof IonValue) {
            return (IonValue)embeddedObject;
        }
        if (!(jp instanceof IonParser)) {
            throw JsonMappingException.from((JsonParser)jp, (String)("Unsupported parser for deserializing " + embeddedObject.getClass().getCanonicalName() + " into IonValue"));
        }
        IonSystem ionSystem = ((IonParser)jp).getIonSystem();
        if (embeddedObject instanceof Timestamp) {
            return ionSystem.newTimestamp((Timestamp)embeddedObject);
        }
        if (embeddedObject instanceof byte[]) {
            return ionSystem.newBlob((byte[])embeddedObject);
        }
        throw JsonMappingException.from((JsonParser)jp, (String)("Cannot deserialize embedded object type " + embeddedObject.getClass().getCanonicalName() + " into IonValue"));
    }
}

