/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion.polymorphism;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeDeserializerBase;
import com.fasterxml.jackson.dataformat.ion.IonParser;
import com.fasterxml.jackson.dataformat.ion.polymorphism.MultipleTypeIdResolver;
import java.io.IOException;

public class IonAnnotationTypeDeserializer
extends TypeDeserializerBase {
    private static final long serialVersionUID = 1L;

    public IonAnnotationTypeDeserializer(JavaType baseType, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl) {
        super(baseType, idRes, typePropertyName, typeIdVisible, defaultImpl);
    }

    public JsonTypeInfo.As getTypeInclusion() {
        return null;
    }

    private IonParser ionParser(JsonParser p) throws JsonParseException {
        if (p instanceof IonParser) {
            return (IonParser)p;
        }
        throw new JsonParseException(p, "Can only use IonAnnotationTypeDeserializer with IonGenerator");
    }

    private Object _deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String[] typeIds = this.ionParser(p).getTypeAnnotations();
        String typeIdToUse = null;
        TypeIdResolver typeIdResolver = super.getTypeIdResolver();
        if (typeIdResolver instanceof MultipleTypeIdResolver) {
            typeIdToUse = ((MultipleTypeIdResolver)typeIdResolver).selectId(typeIds);
        } else if (null != typeIdResolver) {
            for (String typeId : typeIds) {
                JavaType type = typeIdResolver.typeFromId((DatabindContext)ctxt, typeId);
                if (null == type) continue;
                typeIdToUse = typeId;
            }
        }
        JsonDeserializer deserializer = null == typeIdToUse ? this._findDefaultImplDeserializer(ctxt) : super._findDeserializer(ctxt, typeIdToUse);
        if (deserializer == null) {
            return null;
        }
        return deserializer.deserialize(p, ctxt);
    }

    public Object deserializeTypedFromObject(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(p, ctxt);
    }

    public Object deserializeTypedFromArray(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(p, ctxt);
    }

    public Object deserializeTypedFromScalar(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(p, ctxt);
    }

    public Object deserializeTypedFromAny(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this._deserialize(p, ctxt);
    }

    public TypeDeserializer forProperty(BeanProperty prop) {
        return this;
    }
}

