/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.FormatSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class CsvSchema
implements FormatSchema,
Iterable<Column>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int ENCODING_FEATURE_USE_HEADER = 1;
    protected static final int ENCODING_FEATURE_SKIP_FIRST_DATA_ROW = 2;
    protected static final int ENCODING_FEATURE_ALLOW_COMMENTS = 4;
    protected static final int ENCODING_FEATURE_REORDER_COLUMNS = 8;
    protected static final int ENCODING_FEATURE_STRICT_HEADERS = 16;
    protected static final int DEFAULT_ENCODING_FEATURES = 0;
    protected static final char[] NO_CHARS = new char[0];
    public static final char DEFAULT_COLUMN_SEPARATOR = ',';
    public static final String DEFAULT_ARRAY_ELEMENT_SEPARATOR = ";";
    public static final String NO_ARRAY_ELEMENT_SEPARATOR = "";
    public static final String DEFAULT_ANY_PROPERTY_NAME = null;
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    public static final char[] DEFAULT_NULL_VALUE = null;
    public static final int DEFAULT_ESCAPE_CHAR = -1;
    public static final char[] DEFAULT_LINEFEED = "\n".toCharArray();
    @Deprecated
    public static final boolean DEFAULT_USE_HEADER = false;
    @Deprecated
    public static final boolean DEFAULT_SKIP_FIRST_DATA_ROW = false;
    protected static final Column[] NO_COLUMNS = new Column[0];
    protected final Column[] _columns;
    protected final Map<String, Column> _columnsByName;
    protected int _features = 0;
    protected final char _columnSeparator;
    protected final String _arrayElementSeparator;
    protected final int _quoteChar;
    protected final int _escapeChar;
    protected final char[] _lineSeparator;
    protected final char[] _nullValue;
    protected transient String _nullValueAsString;
    protected final String _anyPropertyName;

    @Deprecated
    public CsvSchema(Column[] columns, int features, char columnSeparator, int quoteChar, int escapeChar, char[] lineSeparator, int arrayElementSeparator, char[] nullValue) {
        this(columns, features, columnSeparator, quoteChar, escapeChar, lineSeparator, arrayElementSeparator == -1 ? NO_ARRAY_ELEMENT_SEPARATOR : Character.toString((char)arrayElementSeparator), nullValue, DEFAULT_ANY_PROPERTY_NAME);
    }

    public CsvSchema(Column[] columns, int features, char columnSeparator, int quoteChar, int escapeChar, char[] lineSeparator, String arrayElementSeparator, char[] nullValue, String anyPropertyName) {
        columns = columns == null ? NO_COLUMNS : CsvSchema._link(columns);
        this._columns = columns;
        this._features = features;
        this._columnSeparator = columnSeparator;
        this._arrayElementSeparator = arrayElementSeparator;
        this._quoteChar = quoteChar;
        this._escapeChar = escapeChar;
        this._lineSeparator = lineSeparator;
        this._nullValue = nullValue;
        this._anyPropertyName = anyPropertyName;
        if (this._columns.length == 0) {
            this._columnsByName = Collections.emptyMap();
        } else {
            this._columnsByName = new HashMap<String, Column>(4 + this._columns.length);
            for (Column c : this._columns) {
                this._columnsByName.put(c.getName(), c);
            }
        }
    }

    protected CsvSchema(Column[] columns, int features, char columnSeparator, int quoteChar, int escapeChar, char[] lineSeparator, String arrayElementSeparator, char[] nullValue, Map<String, Column> columnsByName, String anyPropertyName) {
        this._columns = columns;
        this._features = features;
        this._columnSeparator = columnSeparator;
        this._quoteChar = quoteChar;
        this._escapeChar = escapeChar;
        this._lineSeparator = lineSeparator;
        this._arrayElementSeparator = arrayElementSeparator;
        this._nullValue = nullValue;
        this._columnsByName = columnsByName;
        this._anyPropertyName = anyPropertyName;
    }

    protected CsvSchema(CsvSchema base, Column[] columns) {
        this._columns = CsvSchema._link(columns);
        this._features = base._features;
        this._columnSeparator = base._columnSeparator;
        this._quoteChar = base._quoteChar;
        this._escapeChar = base._escapeChar;
        this._lineSeparator = base._lineSeparator;
        this._arrayElementSeparator = base._arrayElementSeparator;
        this._nullValue = base._nullValue;
        this._anyPropertyName = base._anyPropertyName;
        if (this._columns.length == 0) {
            this._columnsByName = Collections.emptyMap();
        } else {
            this._columnsByName = new HashMap<String, Column>(4 + this._columns.length);
            for (Column c : this._columns) {
                this._columnsByName.put(c.getName(), c);
            }
        }
    }

    protected CsvSchema(CsvSchema base, int features) {
        this._columns = base._columns;
        this._features = features;
        this._columnSeparator = base._columnSeparator;
        this._quoteChar = base._quoteChar;
        this._escapeChar = base._escapeChar;
        this._lineSeparator = base._lineSeparator;
        this._arrayElementSeparator = base._arrayElementSeparator;
        this._nullValue = base._nullValue;
        this._anyPropertyName = base._anyPropertyName;
        this._columnsByName = base._columnsByName;
    }

    private static Column[] _link(Column[] orig) {
        int i = orig.length;
        Column[] result = new Column[i];
        Column prev = null;
        while (--i >= 0) {
            Column curr;
            result[i] = curr = orig[i].withNext(i, prev);
            prev = curr;
        }
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CsvSchema emptySchema() {
        return CsvSchema.builder().build();
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public CsvSchema withUseHeader(boolean state) {
        return this._withFeature(1, state);
    }

    public CsvSchema withColumnReordering(boolean state) {
        return this._withFeature(8, state);
    }

    public CsvSchema withStrictHeaders(boolean state) {
        return this._withFeature(16, state);
    }

    public CsvSchema withHeader() {
        return this._withFeature(1, true);
    }

    public CsvSchema withoutHeader() {
        return this._withFeature(1, false);
    }

    public CsvSchema withSkipFirstDataRow(boolean state) {
        return this._withFeature(2, state);
    }

    public CsvSchema withAllowComments(boolean state) {
        return this._withFeature(4, state);
    }

    public CsvSchema withComments() {
        return this._withFeature(4, true);
    }

    public CsvSchema withoutComments() {
        return this._withFeature(4, false);
    }

    protected CsvSchema _withFeature(int feature, boolean state) {
        int newFeatures = state ? this._features | feature : this._features & ~feature;
        return newFeatures == this._features ? this : new CsvSchema(this, newFeatures);
    }

    public CsvSchema withColumnSeparator(char sep) {
        return this._columnSeparator == sep ? this : new CsvSchema(this._columns, this._features, sep, this._quoteChar, this._escapeChar, this._lineSeparator, this._arrayElementSeparator, this._nullValue, this._columnsByName, this._anyPropertyName);
    }

    public CsvSchema withQuoteChar(char c) {
        return this._quoteChar == c ? this : new CsvSchema(this._columns, this._features, this._columnSeparator, c, this._escapeChar, this._lineSeparator, this._arrayElementSeparator, this._nullValue, this._columnsByName, this._anyPropertyName);
    }

    public CsvSchema withoutQuoteChar() {
        return this._quoteChar == -1 ? this : new CsvSchema(this._columns, this._features, this._columnSeparator, -1, this._escapeChar, this._lineSeparator, this._arrayElementSeparator, this._nullValue, this._columnsByName, this._anyPropertyName);
    }

    public CsvSchema withEscapeChar(char c) {
        return this._escapeChar == c ? this : new CsvSchema(this._columns, this._features, this._columnSeparator, this._quoteChar, c, this._lineSeparator, this._arrayElementSeparator, this._nullValue, this._columnsByName, this._anyPropertyName);
    }

    public CsvSchema withoutEscapeChar() {
        return this._escapeChar == -1 ? this : new CsvSchema(this._columns, this._features, this._columnSeparator, this._quoteChar, -1, this._lineSeparator, this._arrayElementSeparator, this._nullValue, this._columnsByName, this._anyPropertyName);
    }

    @Deprecated
    public CsvSchema withArrayElementSeparator(char c) {
        return Character.toString(c).equals(this._arrayElementSeparator) ? this : new CsvSchema(this._columns, this._features, this._columnSeparator, this._quoteChar, this._escapeChar, this._lineSeparator, Character.toString(c), this._nullValue, this._columnsByName, this._anyPropertyName);
    }

    public CsvSchema withArrayElementSeparator(String separator) {
        String sep = separator == null ? NO_ARRAY_ELEMENT_SEPARATOR : separator;
        return this._arrayElementSeparator.equals(sep) ? this : new CsvSchema(this._columns, this._features, this._columnSeparator, this._quoteChar, this._escapeChar, this._lineSeparator, separator, this._nullValue, this._columnsByName, this._anyPropertyName);
    }

    public CsvSchema withoutArrayElementSeparator() {
        return this._arrayElementSeparator.isEmpty() ? this : new CsvSchema(this._columns, this._features, this._columnSeparator, this._quoteChar, this._escapeChar, this._lineSeparator, NO_ARRAY_ELEMENT_SEPARATOR, this._nullValue, this._columnsByName, this._anyPropertyName);
    }

    public CsvSchema withLineSeparator(String sep) {
        return new CsvSchema(this._columns, this._features, this._columnSeparator, this._quoteChar, this._escapeChar, sep.toCharArray(), this._arrayElementSeparator, this._nullValue, this._columnsByName, this._anyPropertyName);
    }

    public CsvSchema withNullValue(String nvl) {
        return new CsvSchema(this._columns, this._features, this._columnSeparator, this._quoteChar, this._escapeChar, this._lineSeparator, this._arrayElementSeparator, nvl == null ? null : nvl.toCharArray(), this._columnsByName, this._anyPropertyName);
    }

    public CsvSchema withoutColumns() {
        return new CsvSchema(NO_COLUMNS, this._features, this._columnSeparator, this._quoteChar, this._escapeChar, this._lineSeparator, this._arrayElementSeparator, this._nullValue, this._columnsByName, this._anyPropertyName);
    }

    public CsvSchema withAnyPropertyName(String name) {
        return new CsvSchema(this._columns, this._features, this._columnSeparator, this._quoteChar, this._escapeChar, this._lineSeparator, this._arrayElementSeparator, this._nullValue, this._columnsByName, name);
    }

    public CsvSchema sortedBy(String ... columnNames) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String colName : columnNames) {
            Column col = this._columnsByName.get(colName);
            if (col == null) continue;
            map.put(col.getName(), col);
        }
        for (Column col : this._columns) {
            map.put(col.getName(), col);
        }
        return new CsvSchema(this, map.values().toArray(new Column[map.size()]));
    }

    public CsvSchema sortedBy(Comparator<String> cmp) {
        TreeMap<String, Column> map = new TreeMap<String, Column>(cmp);
        for (Column col : this._columns) {
            map.put(col.getName(), col);
        }
        return new CsvSchema(this, map.values().toArray(new Column[map.size()]));
    }

    public String getSchemaType() {
        return "CSV";
    }

    public boolean usesHeader() {
        return (this._features & 1) != 0;
    }

    public boolean reordersColumns() {
        return (this._features & 8) != 0;
    }

    public boolean skipsFirstDataRow() {
        return (this._features & 2) != 0;
    }

    public boolean allowsComments() {
        return (this._features & 4) != 0;
    }

    public boolean strictHeaders() {
        return (this._features & 0x10) != 0;
    }

    @Deprecated
    public boolean useHeader() {
        return (this._features & 1) != 0;
    }

    @Deprecated
    public boolean skipFirstDataRow() {
        return (this._features & 2) != 0;
    }

    public char getColumnSeparator() {
        return this._columnSeparator;
    }

    public String getArrayElementSeparator() {
        return this._arrayElementSeparator;
    }

    public int getQuoteChar() {
        return this._quoteChar;
    }

    public int getEscapeChar() {
        return this._escapeChar;
    }

    public char[] getLineSeparator() {
        return this._lineSeparator;
    }

    public char[] getNullValue() {
        return this._nullValue;
    }

    public char[] getNullValueOrEmpty() {
        if (this._nullValue == null) {
            return NO_CHARS;
        }
        return this._nullValue;
    }

    public String getNullValueString() {
        String str = this._nullValueAsString;
        if (str == null) {
            if (this._nullValue == null) {
                return null;
            }
            this._nullValueAsString = str = this._nullValue.length == 0 ? NO_ARRAY_ELEMENT_SEPARATOR : new String(this._nullValue);
        }
        return str;
    }

    public boolean usesQuoteChar() {
        return this._quoteChar >= 0;
    }

    public boolean usesEscapeChar() {
        return this._escapeChar >= 0;
    }

    public boolean hasArrayElementSeparator() {
        return !this._arrayElementSeparator.isEmpty();
    }

    public String getAnyPropertyName() {
        return this._anyPropertyName;
    }

    @Override
    public Iterator<Column> iterator() {
        return Arrays.asList(this._columns).iterator();
    }

    public int size() {
        return this._columns.length;
    }

    public Column column(int index) {
        return this._columns[index];
    }

    public String columnName(int index) {
        return this._columns[index].getName();
    }

    public Column column(String name) {
        return this._columnsByName.get(name);
    }

    public Column column(String name, int probableIndex) {
        Column col;
        if (probableIndex < this._columns.length && (col = this._columns[probableIndex]).hasName(name)) {
            return col;
        }
        return this._columnsByName.get(name);
    }

    public String getColumnDesc() {
        StringBuilder sb = new StringBuilder(100);
        for (Column col : this._columns) {
            if (sb.length() == 0) {
                sb.append('[');
            } else {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(col.getName());
            sb.append('\"');
        }
        sb.append(']');
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(150);
        sb.append("[CsvSchema: ").append("columns=[");
        boolean first = true;
        for (Column col : this._columns) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(col.getName());
            sb.append("\"/");
            sb.append((Object)col.getType());
        }
        sb.append(']');
        sb.append(", header? ").append(this.usesHeader());
        sb.append(", skipFirst? ").append(this.skipsFirstDataRow());
        sb.append(", comments? ").append(this.allowsComments());
        sb.append(", any-properties? ");
        String anyProp = this.getAnyPropertyName();
        if (anyProp == null) {
            sb.append("N/A");
        } else {
            sb.append("as '").append(anyProp).append("'");
        }
        sb.append(']');
        return sb.toString();
    }

    protected static String _validArrayElementSeparator(String sep) {
        if (sep == null || sep.isEmpty()) {
            return NO_ARRAY_ELEMENT_SEPARATOR;
        }
        return sep;
    }

    public static class Builder {
        protected final ArrayList<Column> _columns = new ArrayList();
        protected int _encodingFeatures = 0;
        protected char _columnSeparator = (char)44;
        protected String _arrayElementSeparator = ";";
        protected String _anyPropertyName = DEFAULT_ANY_PROPERTY_NAME;
        protected int _quoteChar = 34;
        protected int _escapeChar = -1;
        protected char[] _lineSeparator = DEFAULT_LINEFEED;
        protected char[] _nullValue = DEFAULT_NULL_VALUE;

        public Builder() {
        }

        public Builder(CsvSchema src) {
            for (Column col : src._columns) {
                this._columns.add(col);
            }
            this._encodingFeatures = src._features;
            this._columnSeparator = src._columnSeparator;
            this._arrayElementSeparator = src._arrayElementSeparator;
            this._quoteChar = src._quoteChar;
            this._escapeChar = src._escapeChar;
            this._lineSeparator = src._lineSeparator;
            this._nullValue = src._nullValue;
            this._anyPropertyName = src._anyPropertyName;
        }

        public Builder addColumn(String name) {
            int index = this._columns.size();
            return this.addColumn(new Column(index, name));
        }

        public Builder addColumn(String name, ColumnType type) {
            int index = this._columns.size();
            return this.addColumn(new Column(index, name, type));
        }

        public Builder addColumn(Column c) {
            this._columns.add(c);
            return this;
        }

        public Builder addArrayColumn(String name) {
            int index = this._columns.size();
            return this.addColumn(new Column(index, name, ColumnType.ARRAY, CsvSchema.NO_ARRAY_ELEMENT_SEPARATOR));
        }

        @Deprecated
        public Builder addArrayColumn(String name, int elementSeparator) {
            int index = this._columns.size();
            return this.addColumn(new Column(index, name, ColumnType.ARRAY, elementSeparator));
        }

        public Builder addArrayColumn(String name, String elementSeparator) {
            int index = this._columns.size();
            return this.addColumn(new Column(index, name, ColumnType.ARRAY, elementSeparator));
        }

        public Builder addNumberColumn(String name) {
            int index = this._columns.size();
            return this.addColumn(new Column(index, name, ColumnType.NUMBER));
        }

        public Builder addBooleanColumn(String name) {
            int index = this._columns.size();
            return this.addColumn(new Column(index, name, ColumnType.BOOLEAN));
        }

        public Builder replaceColumn(int index, Column c) {
            this._checkIndex(index);
            this._columns.set(index, c);
            return this;
        }

        public Builder renameColumn(int index, String newName) {
            this._checkIndex(index);
            this._columns.set(index, this._columns.get(index).withName(newName));
            return this;
        }

        public Builder setColumnType(int index, ColumnType type) {
            this._checkIndex(index);
            this._columns.set(index, this._columns.get(index).withType(type));
            return this;
        }

        public Builder removeArrayElementSeparator(int index) {
            this._checkIndex(index);
            this._columns.set(index, this._columns.get(index).withArrayElementSeparator(CsvSchema.NO_ARRAY_ELEMENT_SEPARATOR));
            return this;
        }

        @Deprecated
        public void setArrayElementSeparator(int index, char sep) {
            this._checkIndex(index);
            this._columns.set(index, this._columns.get(index).withElementSeparator(sep));
        }

        public Builder setArrayElementSeparator(int index, String sep) {
            this._checkIndex(index);
            this._columns.set(index, this._columns.get(index).withArrayElementSeparator(sep));
            return this;
        }

        public Builder setAnyPropertyName(String name) {
            this._anyPropertyName = name;
            return this;
        }

        public Builder clearColumns() {
            this._columns.clear();
            return this;
        }

        public int size() {
            return this._columns.size();
        }

        public Iterator<Column> getColumns() {
            return this._columns.iterator();
        }

        public Builder setUseHeader(boolean b) {
            this._feature(1, b);
            return this;
        }

        public Builder setReorderColumns(boolean b) {
            this._feature(8, b);
            return this;
        }

        public Builder setStrictHeaders(boolean b) {
            this._feature(16, b);
            return this;
        }

        public Builder setSkipFirstDataRow(boolean b) {
            this._feature(2, b);
            return this;
        }

        public Builder setAllowComments(boolean b) {
            this._feature(4, b);
            return this;
        }

        protected final void _feature(int feature, boolean state) {
            this._encodingFeatures = state ? this._encodingFeatures | feature : this._encodingFeatures & ~feature;
        }

        public Builder setColumnSeparator(char c) {
            this._columnSeparator = c;
            return this;
        }

        @Deprecated
        public Builder setArrayElementSeparator(char c) {
            this._arrayElementSeparator = Character.toString(c);
            return this;
        }

        public Builder setArrayElementSeparator(String separator) {
            this._arrayElementSeparator = CsvSchema._validArrayElementSeparator(separator);
            return this;
        }

        @Deprecated
        public Builder disableElementSeparator(char c) {
            return this.disableArrayElementSeparator();
        }

        public Builder disableArrayElementSeparator() {
            this._arrayElementSeparator = CsvSchema.NO_ARRAY_ELEMENT_SEPARATOR;
            return this;
        }

        public Builder setQuoteChar(char c) {
            this._quoteChar = c;
            return this;
        }

        public Builder disableQuoteChar() {
            this._quoteChar = -1;
            return this;
        }

        public Builder setEscapeChar(char c) {
            this._escapeChar = c;
            return this;
        }

        public Builder disableEscapeChar() {
            this._escapeChar = -1;
            return this;
        }

        public Builder setLineSeparator(String lf) {
            this._lineSeparator = lf.toCharArray();
            return this;
        }

        public Builder setLineSeparator(char lf) {
            this._lineSeparator = new char[]{lf};
            return this;
        }

        public Builder setNullValue(String nvl) {
            return this.setNullValue(nvl == null ? null : nvl.toCharArray());
        }

        public Builder setNullValue(char[] nvl) {
            this._nullValue = nvl;
            return this;
        }

        public CsvSchema build() {
            Column[] cols = this._columns.toArray(new Column[this._columns.size()]);
            return new CsvSchema(cols, this._encodingFeatures, this._columnSeparator, this._quoteChar, this._escapeChar, this._lineSeparator, this._arrayElementSeparator, this._nullValue, this._anyPropertyName);
        }

        protected void _checkIndex(int index) {
            if (index < 0 || index >= this._columns.size()) {
                throw new IllegalArgumentException("Illegal index " + index + "; only got " + this._columns.size() + " columns");
            }
        }
    }

    public static class Column
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final Column PLACEHOLDER = new Column(0, "");
        private final String _name;
        private final int _index;
        private final ColumnType _type;
        private final String _arrayElementSeparator;
        private final Column _next;

        public Column(int index, String name) {
            this(index, name, ColumnType.STRING, CsvSchema.NO_ARRAY_ELEMENT_SEPARATOR);
        }

        public Column(int index, String name, ColumnType type) {
            this(index, name, type, CsvSchema.NO_ARRAY_ELEMENT_SEPARATOR);
        }

        @Deprecated
        public Column(int index, String name, ColumnType type, int arrayElementSep) {
            this(index, name, type, arrayElementSep < 0 ? CsvSchema.NO_ARRAY_ELEMENT_SEPARATOR : Character.toString((char)arrayElementSep));
        }

        public Column(int index, String name, ColumnType type, String arrayElementSep) {
            this._index = index;
            this._name = name;
            this._type = type;
            this._arrayElementSeparator = CsvSchema._validArrayElementSeparator(arrayElementSep);
            this._next = null;
        }

        public Column(Column src, Column next) {
            this(src, src._index, next);
        }

        protected Column(Column src, int index, Column next) {
            this._index = index;
            this._name = src._name;
            this._type = src._type;
            this._arrayElementSeparator = src._arrayElementSeparator;
            this._next = next;
        }

        public Column withName(String newName) {
            if (this._name == newName) {
                return this;
            }
            return new Column(this._index, newName, this._type, this._arrayElementSeparator);
        }

        public Column withType(ColumnType newType) {
            if (newType == this._type) {
                return this;
            }
            return new Column(this._index, this._name, newType, this._arrayElementSeparator);
        }

        @Deprecated
        public Column withElementSeparator(int separator) {
            return this.withArrayElementSeparator(separator < 0 ? CsvSchema.NO_ARRAY_ELEMENT_SEPARATOR : Character.toString((char)separator));
        }

        public Column withArrayElementSeparator(String separator) {
            String sep = CsvSchema._validArrayElementSeparator(separator);
            if (this._arrayElementSeparator.equals(sep)) {
                return this;
            }
            return new Column(this._index, this._name, this._type, sep);
        }

        public Column withNext(Column next) {
            if (this._next == next) {
                return this;
            }
            return new Column(this, next);
        }

        public Column withNext(int index, Column next) {
            if (this._index == index && this._next == next) {
                return this;
            }
            return new Column(this, index, next);
        }

        public int getIndex() {
            return this._index;
        }

        public String getName() {
            return this._name;
        }

        public ColumnType getType() {
            return this._type;
        }

        public Column getNext() {
            return this._next;
        }

        public Column getNextWithName(String name) {
            if (this._next != null && name.equals(this._next._name)) {
                return this._next;
            }
            return null;
        }

        public boolean hasName(String n) {
            return this._name == n || this._name.equals(n);
        }

        public String getArrayElementSeparator() {
            return this._arrayElementSeparator;
        }

        public boolean isArray() {
            return this._type == ColumnType.ARRAY;
        }
    }

    public static enum ColumnType {
        STRING,
        STRING_OR_LITERAL,
        NUMBER,
        NUMBER_OR_STRING,
        BOOLEAN,
        ARRAY;

    }
}

