/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.PackageVersion;
import com.fasterxml.jackson.dataformat.csv.impl.CsvWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class CsvGenerator
extends GeneratorBase {
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    private static final CsvSchema EMPTY_SCHEMA = CsvSchema.emptySchema();
    protected final IOContext _ioContext;
    protected int _csvFeatures;
    protected CsvSchema _schema = EMPTY_SCHEMA;
    protected CsvWriter _writer;
    protected boolean _handleFirstLine = true;
    protected int _nextColumnByName = -1;

    public CsvGenerator(IOContext ctxt, int jsonFeatures, int csvFeatures, ObjectCodec codec, Writer out, char columnSeparator, char quoteChar, char[] linefeed) {
        super(jsonFeatures, codec);
        this._ioContext = ctxt;
        this._csvFeatures = csvFeatures;
        this._writer = new CsvWriter(ctxt, out, columnSeparator, quoteChar, linefeed);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public CsvGenerator useDefaultPrettyPrinter() {
        return this;
    }

    public CsvGenerator setPrettyPrinter(PrettyPrinter pp) {
        return this;
    }

    public Object getOutputTarget() {
        return this._writer.getOutputTarget();
    }

    public void setSchema(FormatSchema schema) {
        if (!(schema instanceof CsvSchema)) {
            super.setSchema(schema);
            return;
        }
        if (this._schema != schema) {
            this._schema = (CsvSchema)schema;
            this._writer = this._writer.withSchema(this._schema);
        }
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof CsvSchema;
    }

    public boolean canOmitFields() {
        return false;
    }

    public final void writeFieldName(String name) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(name) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name);
    }

    public final void writeFieldName(SerializableString name) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(name.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name.getValue());
    }

    public final void writeStringField(String fieldName, String value) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(fieldName) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(fieldName);
        this.writeString(value);
    }

    private final void _writeFieldName(String name) throws IOException, JsonGenerationException {
        CsvSchema.Column col;
        if (this._schema == null) {
            this._reportError("Unrecognized column '" + name + "', can not resolve without CsvSchema");
        }
        if ((col = this._schema.column(name)) == null) {
            this._reportError("Unrecognized column '" + name + "': known columns: " + this._schema.getColumnDesc());
        }
        this._nextColumnByName = col.getIndex();
    }

    public CsvGenerator enable(Feature f) {
        this._csvFeatures |= f.getMask();
        return this;
    }

    public CsvGenerator disable(Feature f) {
        this._csvFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._csvFeatures & f.getMask()) != 0;
    }

    public CsvGenerator configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public final void flush() throws IOException {
        this._writer.flush(this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM));
    }

    public void close() throws IOException {
        super.close();
        this.finishRow();
        this._writer.close(this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET));
    }

    public final void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        if (this._writeContext.inObject()) {
            this._reportError("CSV generator does not support Array values for properties");
        }
        this._writeContext = this._writeContext.createChildArrayContext();
    }

    public final void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this.finishRow();
    }

    public final void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        if (this._writeContext.inObject()) {
            this._reportError("CSV generator does not support Object values for properties");
        }
        this._writeContext = this._writeContext.createChildObjectContext();
    }

    public final void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this.finishRow();
    }

    public void writeString(String text) throws IOException, JsonGenerationException {
        if (text == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        this._writer.write(this._columnIndex(), text);
    }

    public void writeString(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write String value");
        this._writer.write(this._columnIndex(), text, offset, len);
    }

    public final void writeString(SerializableString sstr) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write String value");
        this._writer.write(this._columnIndex(), sstr.getValue());
    }

    public void writeRawUTF8String(byte[] text, int offset, int len) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public final void writeUTF8String(byte[] text, int offset, int len) throws IOException, JsonGenerationException {
        this.writeString(new String(text, offset, len, "UTF-8"));
    }

    public void writeRaw(String text) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String text, int offset, int len) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String text) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String text, int offset, int len) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException, JsonGenerationException {
        if (data == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (offset > 0 || offset + len != data.length) {
            data = Arrays.copyOfRange(data, offset, offset + len);
        }
        String encoded = b64variant.encode(data);
        this._writer.write(this._columnIndex(), encoded);
    }

    public void writeBoolean(boolean state) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write boolean value");
        this._writer.write(this._columnIndex(), state);
    }

    public void writeNull() throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null value");
        this._writer.write(this._columnIndex(), "");
    }

    public void writeNumber(int i) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        this._writer.write(this._columnIndex(), i);
    }

    public void writeNumber(long l) throws IOException, JsonGenerationException {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            this.writeNumber((int)l);
            return;
        }
        this._verifyValueWrite("write number");
        this._writer.write(this._columnIndex(), l);
    }

    public void writeNumber(BigInteger v) throws IOException, JsonGenerationException {
        if (v == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writer.write(this._columnIndex(), v.toString());
    }

    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        this._writer.write(this._columnIndex(), d);
    }

    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        this._writer.write(this._columnIndex(), f);
    }

    public void writeNumber(BigDecimal dec) throws IOException, JsonGenerationException {
        if (dec == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        String str = this.isEnabled(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) ? dec.toPlainString() : dec.toString();
        this._writer.write(this._columnIndex(), str);
    }

    public void writeNumber(String encodedValue) throws IOException, JsonGenerationException, UnsupportedOperationException {
        if (encodedValue == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writer.write(this._columnIndex(), encodedValue);
    }

    public void writeOmittedField(String fieldName) throws IOException, JsonGenerationException {
        CsvSchema.Column col;
        if (this._writeContext.writeFieldName(fieldName) == 4) {
            this._reportError("Can not skip a field, expecting a value");
        }
        if ((col = this._schema.column(fieldName)) != null) {
            this._nextColumnByName = col.getIndex();
            this._verifyValueWrite("skip positional value due to filtering");
            this._writer.write(this._columnIndex(), "");
        }
    }

    protected final void _verifyValueWrite(String typeMsg) throws IOException, JsonGenerationException {
        int status = this._writeContext.writeValue();
        if (status == 5) {
            this._reportError("Can not " + typeMsg + ", expecting field name");
        }
        if (this._handleFirstLine) {
            this._handleFirstLine();
        }
    }

    protected void _releaseBuffers() {
        this._writer._releaseBuffers();
    }

    protected final int _columnIndex() {
        int ix = this._nextColumnByName;
        if (ix < 0) {
            ix = this._writer.nextColumnIndex();
        }
        return ix;
    }

    protected void finishRow() throws IOException, JsonGenerationException {
        this._writer.endRow();
        this._nextColumnByName = -1;
    }

    protected void _handleFirstLine() throws IOException, JsonGenerationException {
        this._handleFirstLine = false;
        if (this._schema.useHeader()) {
            int count = this._schema.size();
            if (count == 0) {
                this._reportError("Schema specified that header line is to be written; but contains no column names");
            }
            for (CsvSchema.Column column : this._schema) {
                this._writer.writeColumnName(column.getName());
            }
            this._writer.endRow();
        }
    }

    public static enum Feature {
        BOGUS(false);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

