/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.FormatSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CsvSchema
implements FormatSchema,
Iterable<Column> {
    protected static final Column[] NO_COLUMNS = new Column[0];
    public static final char DEFAULT_COLUMN_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    public static final int DEFAULT_ESCAPE_CHAR = -1;
    public static final char[] DEFAULT_LINEFEED = "\n".toCharArray();
    public static final boolean DEFAULT_USE_HEADER = false;
    public static final boolean DEFAULT_SKIP_FIRST_DATA_ROW = false;
    protected final Column[] _columns;
    protected final Map<String, Column> _columnsByName;
    protected final boolean _useHeader;
    protected final boolean _skipFirstDataRow;
    protected final char _columnSeparator;
    protected final char _quoteChar;
    protected final int _escapeChar;
    protected final char[] _lineSeparator;

    public CsvSchema(Column[] columnArray, boolean bl, boolean bl2, char c, char c2, int n, char[] cArray) {
        if (columnArray == null) {
            columnArray = NO_COLUMNS;
        }
        this._columns = columnArray;
        this._useHeader = bl;
        this._skipFirstDataRow = bl2;
        this._columnSeparator = c;
        this._quoteChar = c2;
        this._escapeChar = n;
        this._lineSeparator = cArray;
        if (this._columns.length == 0) {
            this._columnsByName = Collections.emptyMap();
        } else {
            this._columnsByName = new HashMap<String, Column>(4 + this._columns.length);
            for (Column column : this._columns) {
                this._columnsByName.put(column.getName(), column);
            }
        }
    }

    protected CsvSchema(Column[] columnArray, boolean bl, boolean bl2, char c, char c2, int n, char[] cArray, Map<String, Column> map) {
        this._columns = columnArray;
        this._useHeader = bl;
        this._skipFirstDataRow = bl2;
        this._columnSeparator = c;
        this._quoteChar = c2;
        this._escapeChar = n;
        this._lineSeparator = cArray;
        this._columnsByName = map;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CsvSchema emptySchema() {
        return CsvSchema.builder().build();
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public CsvSchema withUseHeader(boolean bl) {
        return this._useHeader == bl ? this : new CsvSchema(this._columns, bl, this._skipFirstDataRow, this._columnSeparator, this._quoteChar, this._escapeChar, this._lineSeparator, this._columnsByName);
    }

    public CsvSchema withHeader() {
        return this.withUseHeader(true);
    }

    public CsvSchema withoutHeader() {
        return this.withUseHeader(false);
    }

    public CsvSchema withSkipFirstDataRow(boolean bl) {
        return this._skipFirstDataRow == bl ? this : new CsvSchema(this._columns, this._useHeader, bl, this._columnSeparator, this._quoteChar, this._escapeChar, this._lineSeparator, this._columnsByName);
    }

    public CsvSchema withColumnSeparator(char c) {
        return this._columnSeparator == c ? this : new CsvSchema(this._columns, this._useHeader, this._skipFirstDataRow, c, this._quoteChar, this._escapeChar, this._lineSeparator, this._columnsByName);
    }

    public CsvSchema withQuoteChar(char c) {
        return this._quoteChar == c ? this : new CsvSchema(this._columns, this._useHeader, this._skipFirstDataRow, this._columnSeparator, c, this._escapeChar, this._lineSeparator, this._columnsByName);
    }

    public CsvSchema withEscapeChar(char c) {
        return this._escapeChar == c ? this : new CsvSchema(this._columns, this._useHeader, this._skipFirstDataRow, this._columnSeparator, this._quoteChar, c, this._lineSeparator, this._columnsByName);
    }

    public CsvSchema withoutEscapeChar() {
        return this._escapeChar == -1 ? this : new CsvSchema(this._columns, this._useHeader, this._skipFirstDataRow, this._columnSeparator, this._quoteChar, -1, this._lineSeparator, this._columnsByName);
    }

    public CsvSchema withLineSeparator(String string) {
        return new CsvSchema(this._columns, this._useHeader, this._skipFirstDataRow, this._columnSeparator, this._quoteChar, this._escapeChar, string.toCharArray(), this._columnsByName);
    }

    public CsvSchema withoutColumns() {
        return new CsvSchema(NO_COLUMNS, this._useHeader, this._skipFirstDataRow, this._columnSeparator, this._quoteChar, this._escapeChar, this._lineSeparator, this._columnsByName);
    }

    public String getSchemaType() {
        return "CSV";
    }

    public boolean useHeader() {
        return this._useHeader;
    }

    public boolean skipFirstDataRow() {
        return this._skipFirstDataRow;
    }

    public char getColumnSeparator() {
        return this._columnSeparator;
    }

    public char getQuoteChar() {
        return this._quoteChar;
    }

    public int getEscapeChar() {
        return this._escapeChar;
    }

    public char[] getLineSeparator() {
        return this._lineSeparator;
    }

    @Override
    public Iterator<Column> iterator() {
        return Arrays.asList(this._columns).iterator();
    }

    public int size() {
        return this._columns.length;
    }

    public Column column(int n) {
        return this._columns[n];
    }

    public Column column(String string) {
        return this._columnsByName.get(string);
    }

    public String getColumnDesc() {
        StringBuilder stringBuilder = new StringBuilder(100);
        for (Column column : this._columns) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append('[');
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"');
            stringBuilder.append(column.getName());
            stringBuilder.append('\"');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(150);
        stringBuilder.append("[CsvSchema: ").append("columns=");
        boolean bl = true;
        for (Column column : this._columns) {
            if (bl) {
                bl = false;
                stringBuilder.append('[');
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"');
            stringBuilder.append(column.getName());
            stringBuilder.append("\"/");
            stringBuilder.append((Object)column.getType());
        }
        stringBuilder.append(']');
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static class Builder {
        protected final ArrayList<Column> _columns = new ArrayList();
        protected boolean _useHeader = false;
        protected boolean _skipFirstDataRow = false;
        protected char _columnSeparator = (char)44;
        protected char _quoteChar = (char)34;
        protected int _escapeChar = 34;
        protected char[] _lineSeparator = DEFAULT_LINEFEED;

        public Builder() {
        }

        public Builder(CsvSchema csvSchema) {
            for (Column column : csvSchema._columns) {
                this._columns.add(column);
            }
            this._useHeader = csvSchema._useHeader;
            this._columnSeparator = csvSchema._columnSeparator;
            this._quoteChar = csvSchema._quoteChar;
            this._escapeChar = csvSchema._escapeChar;
            this._lineSeparator = csvSchema._lineSeparator;
            this._skipFirstDataRow = csvSchema._skipFirstDataRow;
        }

        public Builder addColumn(String string) {
            int n = this._columns.size();
            return this.addColumn(new Column(n, string));
        }

        public Builder addColumn(String string, ColumnType columnType) {
            int n = this._columns.size();
            return this.addColumn(new Column(n, string, columnType));
        }

        public Builder addColumn(Column column) {
            this._columns.add(column);
            return this;
        }

        public void replaceColumn(int n, Column column) {
            this._checkIndex(n);
            this._columns.set(n, column);
        }

        public void renameColumn(int n, String string) {
            this._checkIndex(n);
            this._columns.set(n, this._columns.get(n).withName(string));
        }

        public void setColumnType(int n, ColumnType columnType) {
            this._checkIndex(n);
            this._columns.set(n, this._columns.get(n).withType(columnType));
        }

        public Builder clearColumns() {
            this._columns.clear();
            return this;
        }

        public int size() {
            return this._columns.size();
        }

        public Iterator<Column> getColumns() {
            return this._columns.iterator();
        }

        public Builder setUseHeader(boolean bl) {
            this._useHeader = bl;
            return this;
        }

        public Builder setSkipFirstDataRow(boolean bl) {
            this._skipFirstDataRow = bl;
            return this;
        }

        public Builder setColumnSeparator(char c) {
            this._columnSeparator = c;
            return this;
        }

        public Builder setQuoteChar(char c) {
            this._quoteChar = c;
            return this;
        }

        public Builder setEscapeChar(char c) {
            this._escapeChar = c;
            return this;
        }

        public Builder disableEscapeChar() {
            this._escapeChar = -1;
            return this;
        }

        public Builder setLineSeparator(String string) {
            this._lineSeparator = string.toCharArray();
            return this;
        }

        public Builder setLineSeparator(char c) {
            this._lineSeparator = new char[]{c};
            return this;
        }

        public CsvSchema build() {
            Column[] columnArray = this._columns.toArray(new Column[this._columns.size()]);
            return new CsvSchema(columnArray, this._useHeader, this._skipFirstDataRow, this._columnSeparator, this._quoteChar, this._escapeChar, this._lineSeparator);
        }

        protected void _checkIndex(int n) {
            if (n < 0 || n >= this._columns.size()) {
                throw new IllegalArgumentException("Illegal index " + n + "; only got " + this._columns.size() + " columns");
            }
        }
    }

    public static class Column {
        private final String _name;
        private final int _index;
        private final ColumnType _type;

        public Column(int n, String string) {
            this(n, string, ColumnType.STRING);
        }

        public Column(int n, String string, ColumnType columnType) {
            this._index = n;
            this._name = string;
            this._type = columnType;
        }

        public Column withName(String string) {
            return new Column(this._index, string, this._type);
        }

        public Column withType(ColumnType columnType) {
            return new Column(this._index, this._name, columnType);
        }

        public int getIndex() {
            return this._index;
        }

        public String getName() {
            return this._name;
        }

        public ColumnType getType() {
            return this._type;
        }
    }

    public static enum ColumnType {
        STRING,
        STRING_OR_LITERAL,
        NUMBER,
        NUMBER_OR_STRING;

    }
}

