/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.dataformat.csv.CsvFactory;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.impl.LRUMap;

public class CsvMapper
extends ObjectMapper {
    private static final long serialVersionUID = -4573529235914611523L;
    protected final LRUMap<JavaType, CsvSchema> _untypedSchemas = new LRUMap(8, 32);
    protected final LRUMap<JavaType, CsvSchema> _typedSchemas = new LRUMap(8, 32);

    public CsvMapper() {
        this(new CsvFactory());
    }

    public CsvMapper(CsvFactory csvFactory) {
        super((JsonFactory)csvFactory);
        this.enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
    }

    public CsvMapper configure(CsvGenerator.Feature feature, boolean bl) {
        return bl ? this.enable(feature) : this.disable(feature);
    }

    public CsvMapper configure(CsvParser.Feature feature, boolean bl) {
        return bl ? this.enable(feature) : this.disable(feature);
    }

    public CsvMapper enable(CsvGenerator.Feature feature) {
        ((CsvFactory)this._jsonFactory).enable(feature);
        return this;
    }

    public CsvMapper enable(CsvParser.Feature feature) {
        ((CsvFactory)this._jsonFactory).enable(feature);
        return this;
    }

    public CsvMapper disable(CsvGenerator.Feature feature) {
        ((CsvFactory)this._jsonFactory).disable(feature);
        return this;
    }

    public CsvMapper disable(CsvParser.Feature feature) {
        ((CsvFactory)this._jsonFactory).disable(feature);
        return this;
    }

    public final CsvFactory getFactory() {
        return (CsvFactory)this._jsonFactory;
    }

    public CsvSchema schemaFor(JavaType javaType) {
        return this._schemaFor(javaType, this._untypedSchemas, false);
    }

    public final CsvSchema schemaFor(Class<?> clazz) {
        return this._schemaFor(this.constructType(clazz), this._untypedSchemas, false);
    }

    public final CsvSchema schemaFor(TypeReference<?> typeReference) {
        return this._schemaFor(this.constructType(typeReference.getType()), this._untypedSchemas, false);
    }

    public CsvSchema typedSchemaFor(JavaType javaType) {
        return this._schemaFor(javaType, this._typedSchemas, true);
    }

    public final CsvSchema typedSchemaFor(Class<?> clazz) {
        return this._schemaFor(this.constructType(clazz), this._typedSchemas, true);
    }

    public final CsvSchema typedSchemaFor(TypeReference<?> typeReference) {
        return this._schemaFor(this.constructType(typeReference.getType()), this._typedSchemas, true);
    }

    public ObjectReader readerWithSchemaFor(Class<?> clazz) {
        JavaType javaType = this.constructType(clazz);
        if (javaType.isArrayType() || javaType.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.reader(javaType).with((FormatSchema)this.schemaFor(javaType));
    }

    public ObjectReader readerWithTypedSchemaFor(Class<?> clazz) {
        JavaType javaType = this.constructType(clazz);
        if (javaType.isArrayType() || javaType.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.reader(javaType).with((FormatSchema)this.typedSchemaFor(javaType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CsvSchema _schemaFor(JavaType javaType, LRUMap<JavaType, CsvSchema> annotationIntrospector, boolean bl) {
        Object object;
        AnnotationIntrospector annotationIntrospector2 = annotationIntrospector;
        synchronized (annotationIntrospector2) {
            object = (CsvSchema)annotationIntrospector.get(javaType);
            if (object != null) {
                return object;
            }
        }
        annotationIntrospector2 = this._deserializationConfig.getAnnotationIntrospector();
        object = CsvSchema.builder();
        this._addSchemaProperties((CsvSchema.Builder)object, annotationIntrospector2, bl, javaType, null);
        CsvSchema csvSchema = ((CsvSchema.Builder)object).build();
        AnnotationIntrospector annotationIntrospector3 = annotationIntrospector;
        synchronized (annotationIntrospector3) {
            annotationIntrospector.put(javaType, csvSchema);
        }
        return csvSchema;
    }

    protected void _addSchemaProperties(CsvSchema.Builder builder, AnnotationIntrospector annotationIntrospector, boolean bl, JavaType javaType, NameTransformer nameTransformer) {
        BeanDescription beanDescription = this.getSerializationConfig().introspect(javaType);
        for (BeanPropertyDefinition beanPropertyDefinition : beanDescription.findProperties()) {
            String string;
            if (!beanPropertyDefinition.couldSerialize()) continue;
            AnnotatedMember annotatedMember = beanPropertyDefinition.getPrimaryMember();
            if (annotatedMember != null && (string = annotationIntrospector.findUnwrappingNameTransformer(beanPropertyDefinition.getPrimaryMember())) != null) {
                if (nameTransformer != null) {
                    string = NameTransformer.chainedTransformer((NameTransformer)nameTransformer, (NameTransformer)string);
                }
                JavaType javaType2 = annotatedMember.getType(beanDescription.bindingsForBeanType());
                this._addSchemaProperties(builder, annotationIntrospector, bl, javaType2, (NameTransformer)string);
                continue;
            }
            string = beanPropertyDefinition.getName();
            if (nameTransformer != null) {
                string = nameTransformer.transform(string);
            }
            if (bl && annotatedMember != null) {
                builder.addColumn(string, this._determineType(annotatedMember.getRawType()));
                continue;
            }
            builder.addColumn(string);
        }
    }

    protected CsvSchema.ColumnType _determineType(Class<?> clazz) {
        if (clazz == String.class || clazz == Character.TYPE || clazz == Character.class) {
            return CsvSchema.ColumnType.STRING;
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz)) {
            return CsvSchema.ColumnType.NUMBER;
        }
        return CsvSchema.ColumnType.NUMBER_OR_STRING;
    }
}

