/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.PackageVersion;
import com.fasterxml.jackson.dataformat.csv.impl.CsvWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class CsvGenerator
extends GeneratorBase {
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    private static final CsvSchema EMPTY_SCHEMA = CsvSchema.emptySchema();
    protected final IOContext _ioContext;
    protected int _csvFeatures;
    protected CsvSchema _schema = EMPTY_SCHEMA;
    protected CsvWriter _writer;
    protected boolean _handleFirstLine = true;
    protected int _nextColumnByName = -1;

    public CsvGenerator(IOContext iOContext, int n, int n2, ObjectCodec objectCodec, Writer writer, char c, char c2, char[] cArray) {
        super(n, objectCodec);
        this._ioContext = iOContext;
        this._csvFeatures = n2;
        this._writer = new CsvWriter(iOContext, writer, c, c2, cArray);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public CsvGenerator useDefaultPrettyPrinter() {
        return this;
    }

    public CsvGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        return this;
    }

    public Object getOutputTarget() {
        return this._writer.getOutputTarget();
    }

    public void setSchema(FormatSchema formatSchema) {
        if (!(formatSchema instanceof CsvSchema)) {
            super.setSchema(formatSchema);
            return;
        }
        if (this._schema != formatSchema) {
            this._schema = (CsvSchema)formatSchema;
            this._writer = this._writer.withSchema(this._schema);
        }
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return formatSchema instanceof CsvSchema;
    }

    public boolean canOmitFields() {
        return false;
    }

    public final void writeFieldName(String string) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string);
    }

    public final void writeFieldName(SerializableString serializableString) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(serializableString.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializableString.getValue());
    }

    public final void writeStringField(String string, String string2) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string);
        this.writeString(string2);
    }

    private final void _writeFieldName(String string) throws IOException, JsonGenerationException {
        CsvSchema.Column column;
        if (this._schema == null) {
            this._reportError("Unrecognized column '" + string + "', can not resolve without CsvSchema");
        }
        if ((column = this._schema.column(string)) == null) {
            this._reportError("Unrecognized column '" + string + "': known columns: " + this._schema.getColumnDesc());
        }
        this._nextColumnByName = column.getIndex();
    }

    public CsvGenerator enable(Feature feature) {
        this._csvFeatures |= feature.getMask();
        return this;
    }

    public CsvGenerator disable(Feature feature) {
        this._csvFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(Feature feature) {
        return (this._csvFeatures & feature.getMask()) != 0;
    }

    public CsvGenerator configure(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public final void flush() throws IOException {
        this._writer.flush(this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM));
    }

    public void close() throws IOException {
        super.close();
        this.finishRow();
        this._writer.close(this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET));
    }

    public final void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        if (this._writeContext.inObject()) {
            this._reportError("CSV generator does not support Array values for properties");
        }
        this._writeContext = this._writeContext.createChildArrayContext();
    }

    public final void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this.finishRow();
    }

    public final void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        if (this._writeContext.inObject()) {
            this._reportError("CSV generator does not support Object values for properties");
        }
        this._writeContext = this._writeContext.createChildObjectContext();
    }

    public final void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this.finishRow();
    }

    public void writeString(String string) throws IOException, JsonGenerationException {
        if (string == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        this._writer.write(this._columnIndex(), string);
    }

    public void writeString(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write String value");
        this._writer.write(this._columnIndex(), cArray, n, n2);
    }

    public final void writeString(SerializableString serializableString) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write String value");
        this._writer.write(this._columnIndex(), serializableString.getValue());
    }

    public void writeRawUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public final void writeUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this.writeString(new String(byArray, n, n2, "UTF-8"));
    }

    public void writeRaw(String string) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String string, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String string) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String string, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        if (byArray == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (n > 0 || n + n2 != byArray.length) {
            byArray = Arrays.copyOfRange(byArray, n, n + n2);
        }
        String string = base64Variant.encode(byArray);
        this._writer.write(this._columnIndex(), string);
    }

    public void writeBoolean(boolean bl) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write boolean value");
        this._writer.write(this._columnIndex(), bl);
    }

    public void writeNull() throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null value");
        this._writer.write(this._columnIndex(), "");
    }

    public void writeNumber(int n) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        this._writer.write(this._columnIndex(), n);
    }

    public void writeNumber(long l) throws IOException, JsonGenerationException {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            this.writeNumber((int)l);
            return;
        }
        this._verifyValueWrite("write number");
        this._writer.write(this._columnIndex(), l);
    }

    public void writeNumber(BigInteger bigInteger) throws IOException, JsonGenerationException {
        if (bigInteger == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writer.write(this._columnIndex(), bigInteger.toString());
    }

    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        this._writer.write(this._columnIndex(), d);
    }

    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        this._writer.write(this._columnIndex(), f);
    }

    public void writeNumber(BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        if (bigDecimal == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        String string = this.isEnabled(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) ? bigDecimal.toPlainString() : bigDecimal.toString();
        this._writer.write(this._columnIndex(), string);
    }

    public void writeNumber(String string) throws IOException, JsonGenerationException, UnsupportedOperationException {
        if (string == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writer.write(this._columnIndex(), string);
    }

    public void writeOmittedField(String string) throws IOException, JsonGenerationException {
        CsvSchema.Column column;
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not skip a field, expecting a value");
        }
        if ((column = this._schema.column(string)) != null) {
            this._nextColumnByName = column.getIndex();
            this._verifyValueWrite("skip positional value due to filtering");
            this._writer.write(this._columnIndex(), "");
        }
    }

    protected final void _verifyValueWrite(String string) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeValue();
        if (n == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
        if (this._handleFirstLine) {
            this._handleFirstLine();
        }
    }

    protected void _releaseBuffers() {
        this._writer._releaseBuffers();
    }

    protected final int _columnIndex() {
        int n = this._nextColumnByName;
        if (n < 0) {
            n = this._writer.nextColumnIndex();
        }
        return n;
    }

    protected void finishRow() throws IOException, JsonGenerationException {
        this._writer.endRow();
        this._nextColumnByName = -1;
    }

    protected void _handleFirstLine() throws IOException, JsonGenerationException {
        this._handleFirstLine = false;
        if (this._schema.useHeader()) {
            int n = this._schema.size();
            if (n == 0) {
                this._reportError("Schema specified that header line is to be written; but contains no column names");
            }
            for (CsvSchema.Column column : this._schema) {
                this._writer.writeColumnName(column.getName());
            }
            this._writer.endRow();
        }
    }

    public static enum Feature {
        BOGUS(false);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

