/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.PackageVersion;
import com.fasterxml.jackson.dataformat.csv.impl.UTF8Reader;
import com.fasterxml.jackson.dataformat.csv.impl.UTF8Writer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;

public class CsvFactory
extends JsonFactory {
    private static final long serialVersionUID = -4036356829870939719L;
    public static final String FORMAT_NAME_CSV = "CSV";
    static final int DEFAULT_CSV_PARSER_FEATURE_FLAGS = CsvParser.Feature.collectDefaults();
    static final int DEFAULT_CSV_GENERATOR_FEATURE_FLAGS = CsvGenerator.Feature.collectDefaults();
    protected static final char[] DEFAULT_LF = new char[]{'\n'};
    protected int _csvParserFeatures = DEFAULT_CSV_PARSER_FEATURE_FLAGS;
    protected int _csvGeneratorFeatures = DEFAULT_CSV_GENERATOR_FEATURE_FLAGS;
    protected char _cfgColumnSeparator = (char)44;
    protected char _cfgQuoteCharacter = (char)34;
    protected char[] _cfgLineSeparator = DEFAULT_LF;

    public CsvFactory() {
        this(null);
    }

    public CsvFactory(ObjectCodec objectCodec) {
        super(objectCodec);
    }

    protected CsvFactory(CsvFactory csvFactory, ObjectCodec objectCodec) {
        super((JsonFactory)csvFactory, objectCodec);
        this._csvParserFeatures = csvFactory._csvParserFeatures;
        this._csvGeneratorFeatures = csvFactory._csvGeneratorFeatures;
        this._cfgColumnSeparator = csvFactory._cfgColumnSeparator;
        this._cfgQuoteCharacter = csvFactory._cfgQuoteCharacter;
        this._cfgLineSeparator = csvFactory._cfgLineSeparator;
    }

    public CsvFactory copy() {
        this._checkInvalidCopy(CsvFactory.class);
        return new CsvFactory(this, null);
    }

    protected Object readResolve() {
        return new CsvFactory(this, this._objectCodec);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean requiresPropertyOrdering() {
        return true;
    }

    public String getFormatName() {
        return FORMAT_NAME_CSV;
    }

    public MatchStrength hasFormat(InputAccessor inputAccessor) throws IOException {
        return MatchStrength.INCONCLUSIVE;
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return formatSchema instanceof CsvSchema;
    }

    public final CsvFactory configure(CsvParser.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public CsvFactory enable(CsvParser.Feature feature) {
        this._csvParserFeatures |= feature.getMask();
        return this;
    }

    public CsvFactory disable(CsvParser.Feature feature) {
        this._csvParserFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(CsvParser.Feature feature) {
        return (this._csvParserFeatures & feature.getMask()) != 0;
    }

    public final CsvFactory configure(CsvGenerator.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public CsvFactory enable(CsvGenerator.Feature feature) {
        this._csvGeneratorFeatures |= feature.getMask();
        return this;
    }

    public CsvFactory disable(CsvGenerator.Feature feature) {
        this._csvGeneratorFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(CsvGenerator.Feature feature) {
        return (this._csvGeneratorFeatures & feature.getMask()) != 0;
    }

    public CsvParser createParser(File file) throws IOException, JsonParseException {
        return this._createParser(new FileInputStream(file), this._createContext(file, true));
    }

    public CsvParser createParser(URL uRL) throws IOException, JsonParseException {
        return this._createParser(this._optimizedStreamFromURL(uRL), this._createContext(uRL, true));
    }

    public CsvParser createParser(InputStream inputStream) throws IOException, JsonParseException {
        return this._createParser(inputStream, this._createContext(inputStream, false));
    }

    public JsonParser createParser(Reader reader) throws IOException, JsonParseException {
        return this._createParser(reader, this._createContext(reader, false));
    }

    public CsvParser createParser(String string) throws IOException, JsonParseException {
        return this._createParser(new StringReader(string), this._createContext(string, true));
    }

    public CsvParser createParser(byte[] byArray) throws IOException, JsonParseException {
        return this._createParser(byArray, 0, byArray.length, this._createContext(byArray, true));
    }

    public CsvParser createParser(byte[] byArray, int n, int n2) throws IOException, JsonParseException {
        return this._createParser(byArray, n, n2, this._createContext(byArray, true));
    }

    @Deprecated
    public CsvParser createJsonParser(File file) throws IOException, JsonParseException {
        return this._createParser(new FileInputStream(file), this._createContext(file, true));
    }

    @Deprecated
    public CsvParser createJsonParser(URL uRL) throws IOException, JsonParseException {
        return this._createParser(this._optimizedStreamFromURL(uRL), this._createContext(uRL, true));
    }

    @Deprecated
    public CsvParser createJsonParser(InputStream inputStream) throws IOException, JsonParseException {
        return this._createParser(inputStream, this._createContext(inputStream, false));
    }

    @Deprecated
    public JsonParser createJsonParser(Reader reader) throws IOException, JsonParseException {
        return this._createParser(reader, this._createContext(reader, false));
    }

    @Deprecated
    public CsvParser createJsonParser(byte[] byArray) throws IOException, JsonParseException {
        return this._createParser(byArray, 0, byArray.length, this._createContext(byArray, true));
    }

    @Deprecated
    public CsvParser createJsonParser(byte[] byArray, int n, int n2) throws IOException, JsonParseException {
        return this._createParser(byArray, n, n2, this._createContext(byArray, true));
    }

    public CsvGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        IOContext iOContext = this._createContext(outputStream, false);
        if (this._outputDecorator != null) {
            outputStream = this._outputDecorator.decorate(iOContext, outputStream);
        }
        return this._createGenerator(iOContext, this._createWriter(outputStream, JsonEncoding.UTF8, iOContext));
    }

    public CsvGenerator createGenerator(OutputStream outputStream) throws IOException {
        return this.createGenerator(outputStream, JsonEncoding.UTF8);
    }

    public CsvGenerator createGenerator(Writer writer) throws IOException {
        IOContext iOContext = this._createContext(writer, false);
        if (this._outputDecorator != null) {
            writer = this._outputDecorator.decorate(iOContext, writer);
        }
        return this._createGenerator(writer, iOContext);
    }

    @Deprecated
    public CsvGenerator createJsonGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        return this.createGenerator(outputStream, jsonEncoding);
    }

    @Deprecated
    public CsvGenerator createJsonGenerator(OutputStream outputStream) throws IOException {
        return this.createGenerator(outputStream);
    }

    @Deprecated
    public CsvGenerator createJsonGenerator(Writer writer) throws IOException {
        return this.createGenerator(writer);
    }

    protected CsvParser _createParser(InputStream inputStream, IOContext iOContext) throws IOException, JsonParseException {
        Reader reader = this._createReader(inputStream, null, iOContext);
        return new CsvParser(iOContext, this._getBufferRecycler(), this._parserFeatures, this._csvParserFeatures, this._objectCodec, reader);
    }

    protected CsvParser _createParser(Reader reader, IOContext iOContext) throws IOException, JsonParseException {
        return new CsvParser(iOContext, this._getBufferRecycler(), this._parserFeatures, this._csvParserFeatures, this._objectCodec, reader);
    }

    protected CsvParser _createParser(byte[] byArray, int n, int n2, IOContext iOContext) throws IOException, JsonParseException {
        Reader reader = this._createReader(byArray, n, n2, null, iOContext);
        return new CsvParser(iOContext, this._getBufferRecycler(), this._parserFeatures, this._csvParserFeatures, this._objectCodec, reader);
    }

    protected CsvGenerator _createGenerator(Writer writer, IOContext iOContext) throws IOException {
        return this._createGenerator(iOContext, writer);
    }

    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Writer(iOContext, outputStream);
        }
        return new OutputStreamWriter(outputStream, jsonEncoding.getJavaName());
    }

    protected CsvGenerator _createGenerator(IOContext iOContext, Writer writer) throws IOException {
        int n = this._csvGeneratorFeatures;
        CsvGenerator csvGenerator = new CsvGenerator(iOContext, this._generatorFeatures, n, this._objectCodec, writer, this._cfgColumnSeparator, this._cfgQuoteCharacter, this._cfgLineSeparator);
        return csvGenerator;
    }

    protected Reader _createReader(InputStream inputStream, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == null || jsonEncoding == JsonEncoding.UTF8) {
            boolean bl = iOContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            return new UTF8Reader(iOContext, inputStream, bl);
        }
        return new InputStreamReader(inputStream, jsonEncoding.getJavaName());
    }

    protected Reader _createReader(byte[] byArray, int n, int n2, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == null || jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Reader(null, byArray, n, n2);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        return new InputStreamReader((InputStream)byteArrayInputStream, jsonEncoding.getJavaName());
    }
}

