/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.ser;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.avro.AvroGenerator;
import com.fasterxml.jackson.dataformat.avro.ser.ArrayWriteContext;
import com.fasterxml.jackson.dataformat.avro.ser.AvroWriteContext;
import com.fasterxml.jackson.dataformat.avro.ser.MapWriteContext;
import com.fasterxml.jackson.dataformat.avro.ser.NonBSGenericDatumWriter;
import com.fasterxml.jackson.dataformat.avro.ser.ObjectWriteContext;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;

class RootContext
extends AvroWriteContext {
    protected final BinaryEncoder _encoder;
    protected Object _rootValue;
    private NonBSGenericDatumWriter<Object> _writer;

    public RootContext(AvroGenerator generator, Schema schema, BinaryEncoder encoder) {
        super(0, null, generator, schema);
        this._encoder = encoder;
    }

    @Override
    public Object rawValue() {
        return this._rootValue;
    }

    @Override
    public final AvroWriteContext createChildArrayContext() throws JsonMappingException {
        GenericArray<Object> arr;
        switch (this._schema.getType()) {
            case ARRAY: 
            case UNION: {
                break;
            }
            default: {
                throw new IllegalStateException("Can not write START_ARRAY; schema type is " + this._schema.getType());
            }
        }
        this._rootValue = arr = this._createArray(this._schema);
        return new ArrayWriteContext(this, this._generator, arr);
    }

    @Override
    public final AvroWriteContext createChildObjectContext() throws JsonMappingException {
        switch (this._schema.getType()) {
            case UNION: 
            case RECORD: {
                GenericRecord rec = this._createRecord(this._schema);
                this._rootValue = rec;
                return new ObjectWriteContext((AvroWriteContext)this, this._generator, rec);
            }
            case MAP: {
                MapWriteContext ctxt = new MapWriteContext(this, this._generator, this._schema);
                this._rootValue = ctxt.rawValue();
                return ctxt;
            }
        }
        throw new IllegalStateException("Can not write START_OBJECT; schema type is " + this._schema.getType());
    }

    @Override
    public void writeValue(Object value) throws IOException {
        this._writer().write(value, (Encoder)this._encoder);
    }

    @Override
    public void writeString(String value) throws IOException {
        this._writer().write(value, (Encoder)this._encoder);
    }

    @Override
    public void writeNull() throws IOException {
        this._writer().write(null, (Encoder)this._encoder);
    }

    @Override
    public void complete() throws IOException {
        Object rootValue = this._rootValue;
        this._rootValue = null;
        if (this._generator.isEnabled(AvroGenerator.Feature.AVRO_FILE_OUTPUT)) {
            OutputStream outputStream = (OutputStream)this._generator.getOutputTarget();
            NonBSGenericDatumWriter datumWriter = new NonBSGenericDatumWriter(this._schema);
            DataFileWriter dataFileWriter = new DataFileWriter(datumWriter);
            dataFileWriter.create(this._schema, outputStream);
            dataFileWriter.append(rootValue);
            dataFileWriter.close();
            return;
        }
        if (rootValue != null) {
            this._writer().write(rootValue, (Encoder)this._encoder);
        }
        this._encoder.flush();
    }

    @Override
    public void appendDesc(StringBuilder sb) {
        sb.append("/");
    }

    protected void _reportError() {
        throw new IllegalStateException("Can not write values directly in root context, outside of Records/Arrays");
    }

    private final NonBSGenericDatumWriter<Object> _writer() {
        NonBSGenericDatumWriter<Object> w = this._writer;
        if (w == null) {
            this._writer = w = new NonBSGenericDatumWriter(this._schema);
        }
        return w;
    }
}

