/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.avro.AvroFactory;
import com.fasterxml.jackson.dataformat.avro.AvroModule;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import com.fasterxml.jackson.dataformat.avro.PackageVersion;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;

public class AvroMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public AvroMapper() {
        this(new AvroFactory());
    }

    public AvroMapper(AvroFactory f) {
        super((JsonFactory)f);
        this.registerModule(new AvroModule());
    }

    public AvroMapper(Module ... modules) {
        super((JsonFactory)new AvroFactory());
        this.registerModules(modules);
    }

    public AvroMapper(AvroFactory f, Module ... modules) {
        super((JsonFactory)f);
        this.registerModules(modules);
    }

    protected AvroMapper(ObjectMapper src) {
        super(src);
    }

    public AvroMapper copy() {
        this._checkInvalidCopy(AvroMapper.class);
        return new AvroMapper(this);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public AvroFactory getFactory() {
        return (AvroFactory)this._jsonFactory;
    }

    public AvroSchema schemaFor(Class<?> type) throws JsonMappingException {
        AvroSchemaGenerator gen = new AvroSchemaGenerator();
        this.acceptJsonFormatVisitor(type, gen);
        return gen.getGeneratedSchema();
    }

    public AvroSchema schemaFor(JavaType type) throws JsonMappingException {
        AvroSchemaGenerator gen = new AvroSchemaGenerator();
        this.acceptJsonFormatVisitor(type, gen);
        return gen.getGeneratedSchema();
    }

    public AvroSchema schemaFrom(InputStream in) throws IOException {
        try {
            AvroSchema avroSchema = new AvroSchema(new Schema.Parser().setValidate(true).parse(in));
            return avroSchema;
        }
        finally {
            in.close();
        }
    }

    public AvroSchema schemaFrom(String schemaAsString) throws IOException {
        return new AvroSchema(new Schema.Parser().setValidate(true).parse(schemaAsString));
    }

    public AvroSchema schemaFrom(File schemaFile) throws IOException {
        return new AvroSchema(new Schema.Parser().setValidate(true).parse(schemaFile));
    }
}

