/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.ser;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Encoder;

public class NonBSGenericDatumWriter<D>
extends GenericDatumWriter<D> {
    public NonBSGenericDatumWriter(Schema root) {
        super(root);
    }

    public int resolveUnion(Schema union, Object datum) {
        block9: {
            List schemas;
            block8: {
                if (datum == null) {
                    return union.getIndexNamed(Schema.Type.NULL.getName());
                }
                schemas = union.getTypes();
                if (!(datum instanceof String)) break block8;
                int len = schemas.size();
                block5: for (int i = 0; i < len; ++i) {
                    Schema s = (Schema)schemas.get(i);
                    switch (s.getType()) {
                        case STRING: 
                        case ENUM: {
                            return i;
                        }
                        case INT: {
                            if (!Character.class.getName().equals(s.getProp("java-class"))) continue block5;
                            return i;
                        }
                        case ARRAY: {
                            if (s.getElementType().getType() != Schema.Type.INT || !Character.class.getName().equals(s.getElementType().getProp("java-class"))) continue block5;
                            return i;
                        }
                    }
                }
                break block9;
            }
            if (!(datum instanceof BigDecimal)) break block9;
            int len = schemas.size();
            for (int i = 0; i < len; ++i) {
                if (((Schema)schemas.get(i)).getType() != Schema.Type.DOUBLE) continue;
                return i;
            }
        }
        return super.resolveUnion(union, datum);
    }

    protected void write(Schema schema, Object datum, Encoder out) throws IOException {
        if (schema.getType() == Schema.Type.DOUBLE && datum instanceof BigDecimal) {
            out.writeDouble(((BigDecimal)datum).doubleValue());
            return;
        }
        if (datum instanceof String) {
            String str = (String)datum;
            int len = str.length();
            if (schema.getType() == Schema.Type.ARRAY && schema.getElementType().getType() == Schema.Type.INT) {
                ArrayList<Integer> chars = new ArrayList<Integer>(len);
                for (int i = 0; i < len; ++i) {
                    chars.add(Integer.valueOf(str.charAt(i)));
                }
                super.write(schema, chars, out);
                return;
            }
            if (len == 1 && schema.getType() == Schema.Type.INT) {
                super.write(schema, (Object)str.charAt(0), out);
                return;
            }
        }
        super.write(schema, datum, out);
    }
}

