/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.schema;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.dataformat.avro.AvroFixedSize;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaHelper;
import com.fasterxml.jackson.dataformat.avro.schema.DefinedSchemas;
import com.fasterxml.jackson.dataformat.avro.schema.SchemaBuilder;
import com.fasterxml.jackson.dataformat.avro.schema.VisitorFormatWrapperImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.reflect.AvroMeta;
import org.apache.avro.reflect.AvroSchema;

public class RecordVisitor
extends JsonObjectFormatVisitor.Base
implements SchemaBuilder {
    protected final JavaType _type;
    protected final DefinedSchemas _schemas;
    protected final boolean _overridden;
    protected Schema _avroSchema;
    protected List<Schema.Field> _fields = new ArrayList<Schema.Field>();

    public RecordVisitor(SerializerProvider p, JavaType type, DefinedSchemas schemas) {
        super(p);
        this._type = type;
        this._schemas = schemas;
        BeanDescription bean = this.getProvider().getConfig().introspectDirectClassAnnotations(this._type);
        AvroSchema ann = (AvroSchema)bean.getClassInfo().getAnnotation(AvroSchema.class);
        if (ann != null) {
            this._avroSchema = AvroSchemaHelper.parseJsonSchema(ann.value());
            this._overridden = true;
        } else {
            this._avroSchema = AvroSchemaHelper.initializeRecordSchema(bean);
            this._overridden = false;
            AvroMeta meta = (AvroMeta)bean.getClassInfo().getAnnotation(AvroMeta.class);
            if (meta != null) {
                this._avroSchema.addProp(meta.key(), meta.value());
            }
        }
        schemas.addSchema(type, this._avroSchema);
    }

    @Override
    public Schema builtAvroSchema() {
        if (!this._overridden) {
            this._avroSchema.setFields(this._fields);
        }
        return this._avroSchema;
    }

    public void property(BeanProperty writer) throws JsonMappingException {
        if (this._overridden) {
            return;
        }
        this._fields.add(this.schemaFieldForWriter(writer, false));
    }

    public void property(String name, JsonFormatVisitable handler, JavaType type) throws JsonMappingException {
        if (this._overridden) {
            return;
        }
        VisitorFormatWrapperImpl wrapper = new VisitorFormatWrapperImpl(this._schemas, this.getProvider());
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)wrapper, type);
        Schema schema = wrapper.getAvroSchema();
        this._fields.add(new Schema.Field(name, schema, null, null));
    }

    public void optionalProperty(BeanProperty writer) throws JsonMappingException {
        if (this._overridden) {
            return;
        }
        this._fields.add(this.schemaFieldForWriter(writer, true));
    }

    public void optionalProperty(String name, JsonFormatVisitable handler, JavaType type) throws JsonMappingException {
        if (this._overridden) {
            return;
        }
        VisitorFormatWrapperImpl wrapper = new VisitorFormatWrapperImpl(this._schemas, this.getProvider());
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)wrapper, type);
        Schema schema = wrapper.getAvroSchema();
        if (!type.isPrimitive()) {
            schema = AvroSchemaHelper.unionWithNull(schema);
        }
        this._fields.add(new Schema.Field(name, schema, null, null));
    }

    protected Schema.Field schemaFieldForWriter(BeanProperty prop, boolean optional) throws JsonMappingException {
        Schema writerSchema;
        AvroSchema schemaOverride = (AvroSchema)prop.getAnnotation(AvroSchema.class);
        if (schemaOverride != null) {
            Schema.Parser parser = new Schema.Parser();
            writerSchema = parser.parse(schemaOverride.value());
        } else {
            AvroFixedSize fixedSize = (AvroFixedSize)prop.getAnnotation(AvroFixedSize.class);
            if (fixedSize != null) {
                writerSchema = Schema.createFixed((String)fixedSize.typeName(), null, (String)fixedSize.typeNamespace(), (int)fixedSize.size());
            } else {
                JsonSerializer ser = null;
                if (prop instanceof BeanPropertyWriter) {
                    BeanPropertyWriter bpw = (BeanPropertyWriter)prop;
                    ser = bpw.getSerializer();
                }
                SerializerProvider prov = this.getProvider();
                if (ser == null) {
                    if (prov == null) {
                        throw JsonMappingException.from((SerializerProvider)prov, (String)"SerializerProvider missing for RecordVisitor");
                    }
                    ser = prov.findValueSerializer(prop.getType(), prop);
                }
                VisitorFormatWrapperImpl visitor = new VisitorFormatWrapperImpl(this._schemas, prov);
                ser.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, prop.getType());
                writerSchema = visitor.getAvroSchema();
            }
            if (optional && !prop.getType().isPrimitive()) {
                writerSchema = AvroSchemaHelper.unionWithNull(writerSchema);
            }
        }
        Schema.Field field = new Schema.Field(prop.getName(), writerSchema, prop.getMetadata().getDescription(), null);
        AvroMeta meta = (AvroMeta)prop.getAnnotation(AvroMeta.class);
        if (meta != null) {
            field.addProp(meta.key(), meta.value());
        }
        return field;
    }
}

