/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.schema;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.dataformat.avro.schema.DefinedSchemas;
import com.fasterxml.jackson.dataformat.avro.schema.SchemaBuilder;
import com.fasterxml.jackson.dataformat.avro.schema.VisitorFormatWrapperImpl;
import org.apache.avro.Schema;

public class MapVisitor
extends JsonMapFormatVisitor.Base
implements SchemaBuilder {
    protected final JavaType _type;
    protected final DefinedSchemas _schemas;
    protected Schema _valueSchema;

    public MapVisitor(SerializerProvider p, JavaType type, DefinedSchemas schemas) {
        super(p);
        this._type = type;
        this._schemas = schemas;
    }

    @Override
    public Schema builtAvroSchema() {
        if (this._valueSchema == null) {
            throw new IllegalStateException("Missing value type for " + this._type);
        }
        return Schema.createMap((Schema)this._valueSchema);
    }

    public void keyFormat(JsonFormatVisitable handler, JavaType keyType) throws JsonMappingException {
    }

    public void valueFormat(JsonFormatVisitable handler, JavaType valueType) throws JsonMappingException {
        VisitorFormatWrapperImpl wrapper = new VisitorFormatWrapperImpl(this._schemas, this.getProvider());
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)wrapper, valueType);
        this._valueSchema = wrapper.getAvroSchema();
    }
}

