/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.schema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.reflect.Stringable;

public abstract class AvroSchemaHelper {
    public static final String AVRO_SCHEMA_PROP_CLASS = "java-class";
    public static final String AVRO_SCHEMA_PROP_KEY_CLASS = "java-key-class";
    protected static final Set<Class<?>> STRINGABLE_CLASSES = new HashSet<Class>(Arrays.asList(URI.class, URL.class, File.class, BigInteger.class, BigDecimal.class, String.class));

    public static boolean isStringable(AnnotatedClass type) {
        if (STRINGABLE_CLASSES.contains(type.getRawType())) {
            return true;
        }
        if (!type.hasAnnotation(Stringable.class)) {
            return false;
        }
        for (AnnotatedConstructor constructor : type.getConstructors()) {
            if (constructor.getParameterCount() != 1 || constructor.getRawParameterType(0) != String.class) continue;
            return true;
        }
        return false;
    }

    protected static String getNamespace(JavaType type) {
        Class cls = type.getRawClass();
        Package pkg = cls.getPackage();
        return pkg == null ? "" : pkg.getName();
    }

    protected static String getName(JavaType type) {
        String name = type.getRawClass().getSimpleName();
        while (name.indexOf("[]") >= 0) {
            name = name.replace("[]", "Array");
        }
        return name;
    }

    protected static Schema unionWithNull(Schema otherSchema) {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        schemas.add(Schema.create((Schema.Type)Schema.Type.NULL));
        if (otherSchema.getType() == Schema.Type.UNION) {
            schemas.addAll(otherSchema.getTypes());
        } else {
            schemas.add(otherSchema);
        }
        return Schema.createUnion(schemas);
    }

    public static Schema simpleSchema(JsonFormatTypes type, JavaType hint) {
        switch (type) {
            case BOOLEAN: {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case INTEGER: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case NULL: {
                return Schema.create((Schema.Type)Schema.Type.NULL);
            }
            case NUMBER: {
                if (hint.hasRawClass(Float.TYPE)) {
                    return Schema.create((Schema.Type)Schema.Type.FLOAT);
                }
                if (hint.hasRawClass(Long.TYPE)) {
                    return Schema.create((Schema.Type)Schema.Type.LONG);
                }
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case STRING: {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case ARRAY: 
            case OBJECT: {
                throw new UnsupportedOperationException("Should not try to create simple Schema for: " + type);
            }
        }
        throw new UnsupportedOperationException("Can not create Schema for: " + type + "; not (yet) supported");
    }

    public static Schema numericAvroSchema(JsonParser.NumberType type) {
        switch (type) {
            case INT: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case BIG_INTEGER: 
            case LONG: {
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case FLOAT: {
                return Schema.create((Schema.Type)Schema.Type.FLOAT);
            }
            case BIG_DECIMAL: 
            case DOUBLE: {
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
        }
        throw new IllegalStateException("Unrecognized number type: " + type);
    }

    public static Schema numericAvroSchema(JsonParser.NumberType type, JavaType hint) {
        Schema schema = AvroSchemaHelper.numericAvroSchema(type);
        if (hint != null) {
            schema.addProp(AVRO_SCHEMA_PROP_CLASS, AvroSchemaHelper.getTypeId(hint));
        }
        return schema;
    }

    public static Schema typedSchema(Schema.Type nativeType, JavaType javaType) {
        Schema schema = Schema.create((Schema.Type)nativeType);
        schema.addProp(AVRO_SCHEMA_PROP_CLASS, AvroSchemaHelper.getTypeId(javaType));
        return schema;
    }

    public static Schema anyNumberSchema() {
        return Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.INT), Schema.create((Schema.Type)Schema.Type.LONG), Schema.create((Schema.Type)Schema.Type.DOUBLE)));
    }

    protected static <T> T throwUnsupported() {
        throw new UnsupportedOperationException("Format variation not supported");
    }

    public static Schema initializeRecordSchema(BeanDescription bean) {
        return Schema.createRecord((String)AvroSchemaHelper.getName(bean.getType()), (String)bean.findClassDescription(), (String)AvroSchemaHelper.getNamespace(bean.getType()), (boolean)bean.getType().isTypeOrSubTypeOf(Throwable.class));
    }

    public static Schema parseJsonSchema(String json) {
        Schema.Parser parser = new Schema.Parser();
        return parser.parse(json);
    }

    protected static String getTypeId(JavaType type) {
        if (type.isPrimitive()) {
            return ClassUtil.wrapperType((Class)type.getRawClass()).getName();
        }
        return type.getRawClass().getName();
    }
}

