/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.ArrayReader;
import com.fasterxml.jackson.dataformat.avro.deser.AvroFieldReader;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.DecodeUtil;
import com.fasterxml.jackson.dataformat.avro.deser.MapReader;
import java.io.IOException;
import java.util.List;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;

public class StructDefaults {
    public static AvroFieldReader createObjectDefaults(String name, List<AvroFieldReader> fieldReaders) {
        return AvroFieldReader.construct(name, new ObjectDefaults(null, null, null, fieldReaders.toArray(new AvroFieldReader[fieldReaders.size()])));
    }

    public static AvroFieldReader createArrayDefaults(String name, List<AvroFieldReader> fieldReaders) {
        return AvroFieldReader.construct(name, new ArrayDefaults(null, null, null, fieldReaders.toArray(new AvroFieldReader[fieldReaders.size()])));
    }

    protected static class ArrayDefaults
    extends ArrayReader {
        protected final AvroFieldReader[] _valueReaders;

        public ArrayDefaults(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder, AvroFieldReader[] valueReaders) {
            super(parent, parser, decoder);
            this._valueReaders = valueReaders;
        }

        @Override
        public ArrayReader newReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
            return new ArrayDefaults(parent, parser, decoder, this._valueReaders);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._state = 1;
                    this._currToken = JsonToken.START_ARRAY;
                    return this._currToken;
                }
                case 1: {
                    if (this._index < this._valueReaders.length) {
                        AvroFieldReader r = this._valueReaders[this._index++];
                        this._currToken = r.readValue(this, this._parser, this._decoder);
                        return this._currToken;
                    }
                    AvroReadContext parent = this.getParent();
                    if (parent.inRoot() && !DecodeUtil.isEnd((Decoder)this._decoder)) {
                        this._index = 0;
                        this._state = 0;
                        this._currToken = JsonToken.END_ARRAY;
                        return this._currToken;
                    }
                    this._state = 3;
                    this._parser.setAvroContext(parent);
                    this._currToken = JsonToken.END_ARRAY;
                    return this._currToken;
                }
            }
            this.throwIllegalState(this._state);
            return null;
        }

        @Override
        public void skipValue(BinaryDecoder decoder) throws IOException {
        }
    }

    protected static class ObjectDefaults
    extends MapReader {
        protected final AvroFieldReader[] _fieldReaders;

        public ObjectDefaults(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder, AvroFieldReader[] fieldReaders) {
            super(parent, parser, decoder);
            this._fieldReaders = fieldReaders;
        }

        @Override
        public MapReader newReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
            return new ObjectDefaults(parent, parser, decoder, this._fieldReaders);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._state = 1;
                    this._currToken = JsonToken.START_OBJECT;
                    return this._currToken;
                }
                case 1: {
                    if (this._index < this._fieldReaders.length) {
                        this._state = 2;
                        this._currentName = this._fieldReaders[this._index].getName();
                        this._currToken = JsonToken.FIELD_NAME;
                        return this._currToken;
                    }
                    AvroReadContext parent = this.getParent();
                    if (parent.inRoot() && !DecodeUtil.isEnd((Decoder)this._decoder)) {
                        this._index = 0;
                        this._state = 0;
                        this._currToken = JsonToken.END_OBJECT;
                        return this._currToken;
                    }
                    this._state = 4;
                    this._parser.setAvroContext(parent);
                    this._currToken = JsonToken.END_OBJECT;
                    return this._currToken;
                }
                case 2: {
                    this._state = 1;
                    AvroFieldReader r = this._fieldReaders[this._index++];
                    this._currToken = r.readValue(this, this._parser, this._decoder);
                    return this._currToken;
                }
            }
            this.throwIllegalState(this._state);
            return null;
        }

        @Override
        public void skipValue(BinaryDecoder decoder) throws IOException {
        }
    }
}

