/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroFieldReader;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import java.io.IOException;
import org.apache.avro.io.BinaryDecoder;

public class ScalarDefaults {

    protected static final class NullDefaults
    extends DefaultsBase {
        public NullDefaults(String name) {
            super(name);
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder avroDecoder) {
            return JsonToken.VALUE_NULL;
        }
    }

    protected static final class LongDefaults
    extends DefaultsBase {
        protected final long _defaults;

        public LongDefaults(String name, long v) {
            super(name);
            this._defaults = v;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder avroDecoder) {
            return parser.setNumber(this._defaults);
        }
    }

    protected static final class IntDefaults
    extends DefaultsBase {
        protected final int _defaults;

        public IntDefaults(String name, int v) {
            super(name);
            this._defaults = v;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder avroDecoder) {
            return parser.setNumber(this._defaults);
        }
    }

    protected static final class FloatDefaults
    extends DefaultsBase {
        protected final float _defaults;

        public FloatDefaults(String name, float v) {
            super(name);
            this._defaults = v;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder avroDecoder) {
            return parser.setNumber(this._defaults);
        }
    }

    protected static final class DoubleDefaults
    extends DefaultsBase {
        protected final double _defaults;

        public DoubleDefaults(String name, double v) {
            super(name);
            this._defaults = v;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder avroDecoder) {
            return parser.setNumber(this._defaults);
        }
    }

    protected static final class BytesDefaults
    extends DefaultsBase {
        protected final byte[] _defaults;

        public BytesDefaults(String name, byte[] v) {
            super(name);
            this._defaults = v;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder avroDecoder) {
            return parser.setBytes(this._defaults);
        }
    }

    protected static final class StringDefaults
    extends DefaultsBase {
        protected final String _defaults;

        public StringDefaults(String name, String v) {
            super(name);
            this._defaults = v;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder avroDecoder) {
            return parser.setString(this._defaults);
        }
    }

    protected static final class BooleanDefaults
    extends DefaultsBase {
        protected final JsonToken _defaults;

        public BooleanDefaults(String name, boolean v) {
            super(name);
            this._defaults = v ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder avroDecoder) {
            return this._defaults;
        }
    }

    protected static abstract class DefaultsBase
    extends AvroFieldReader {
        protected DefaultsBase(String name) {
            super(name, false);
        }

        @Override
        public abstract JsonToken readValue(AvroReadContext var1, AvroParserImpl var2, BinaryDecoder var3) throws IOException;

        @Override
        public void skipValue(BinaryDecoder decoder) throws IOException {
        }
    }
}

