/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroFieldReader;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;

public abstract class ScalarDecoder {
    protected abstract JsonToken decodeValue(AvroParserImpl var1, Decoder var2) throws IOException;

    protected abstract void skipValue(Decoder var1) throws IOException;

    public abstract AvroFieldReader asFieldReader(String var1, boolean var2);

    protected static final class FixedDecoder
    extends ScalarDecoder {
        private final int _size;

        public FixedDecoder(int fixedSize) {
            this._size = fixedSize;
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser, Decoder decoder) throws IOException {
            byte[] data = new byte[this._size];
            decoder.readFixed(data);
            return parser.setBytes(data);
        }

        @Override
        protected void skipValue(Decoder decoder) throws IOException {
            decoder.skipFixed(this._size);
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper, this._size);
        }

        private static final class FR
        extends AvroFieldReader {
            private final int _size;

            public FR(String name, boolean skipper, int size) {
                super(name, skipper);
                this._size = size;
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
                byte[] data = new byte[this._size];
                decoder.readFixed(data);
                return parser.setBytes(data);
            }

            @Override
            public void skipValue(BinaryDecoder decoder) throws IOException {
                decoder.skipFixed(this._size);
            }
        }
    }

    protected static final class EnumDecoder
    extends ScalarDecoder {
        protected final String _name;
        protected final String[] _values;

        public EnumDecoder(String name, List<String> enumNames) {
            this._name = name;
            this._values = enumNames.toArray(new String[enumNames.size()]);
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser, Decoder decoder) throws IOException {
            return parser.setString(this._checkIndex(decoder.readEnum()));
        }

        @Override
        protected void skipValue(Decoder decoder) throws IOException {
            this._checkIndex(decoder.readEnum());
        }

        private final String _checkIndex(int index) throws IOException {
            if (index < 0 || index >= this._values.length) {
                throw new IOException(String.format("Invalid Enum index (%s); enum '%s' only has %d types", index, this._name, this._values.length));
            }
            return this._values[index];
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper, this);
        }

        private static final class FR
        extends AvroFieldReader {
            protected final String[] _values;

            public FR(String name, boolean skipper, EnumDecoder base) {
                super(name, skipper);
                this._values = base._values;
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
                return parser.setString(this._checkIndex(decoder.readEnum()));
            }

            @Override
            public void skipValue(BinaryDecoder decoder) throws IOException {
                this._checkIndex(decoder.readEnum());
            }

            private final String _checkIndex(int index) throws IOException {
                if (index < 0 || index >= this._values.length) {
                    throw new IOException(String.format("Invalid Enum index (%s); enum '%s' only has %d types", index, this._name, this._values.length));
                }
                return this._values[index];
            }
        }
    }

    protected static final class ScalarUnionDecoder
    extends ScalarDecoder {
        public final ScalarDecoder[] _readers;

        public ScalarUnionDecoder(ScalarDecoder[] readers) {
            this._readers = readers;
        }

        @Override
        protected JsonToken decodeValue(AvroParserImpl parser, Decoder decoder) throws IOException {
            return this._checkIndex(decoder.readIndex()).decodeValue(parser, decoder);
        }

        @Override
        protected void skipValue(Decoder decoder) throws IOException {
            this._checkIndex(decoder.readIndex()).skipValue(decoder);
        }

        private ScalarDecoder _checkIndex(int index) throws IOException {
            if (index < 0 || index >= this._readers.length) {
                throw new IOException(String.format("Invalid Union index (%s); union only has %d types", index, this._readers.length));
            }
            return this._readers[index];
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper, this._readers);
        }

        private static final class FR
        extends AvroFieldReader {
            public final ScalarDecoder[] _readers;

            public FR(String name, boolean skipper, ScalarDecoder[] readers) {
                super(name, skipper);
                this._readers = readers;
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
                return this._checkIndex(decoder.readIndex()).decodeValue(parser, (Decoder)decoder);
            }

            @Override
            public void skipValue(BinaryDecoder decoder) throws IOException {
                this._checkIndex(decoder.readIndex()).skipValue((Decoder)decoder);
            }

            private ScalarDecoder _checkIndex(int index) throws IOException {
                if (index < 0 || index >= this._readers.length) {
                    throw new IOException(String.format("Invalid Union index (%s); union only has %d types", index, this._readers.length));
                }
                return this._readers[index];
            }
        }
    }

    protected static final class StringReader
    extends ScalarDecoder {
        protected StringReader() {
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser, Decoder decoder) throws IOException {
            return parser.setString(decoder.readString());
        }

        @Override
        protected void skipValue(Decoder decoder) throws IOException {
            decoder.skipString();
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper);
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper) {
                super(name, skipper);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
                return parser.setString(decoder.readString());
            }

            @Override
            public void skipValue(BinaryDecoder decoder) throws IOException {
                decoder.skipString();
            }
        }
    }

    protected static final class NullReader
    extends ScalarDecoder {
        protected NullReader() {
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser, Decoder decoder) {
            return JsonToken.VALUE_NULL;
        }

        @Override
        protected void skipValue(Decoder decoder) throws IOException {
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper);
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper) {
                super(name, skipper);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
                return JsonToken.VALUE_NULL;
            }

            @Override
            public void skipValue(BinaryDecoder decoder) throws IOException {
            }
        }
    }

    protected static final class LongReader
    extends ScalarDecoder {
        protected LongReader() {
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser, Decoder decoder) throws IOException {
            return parser.setNumber(decoder.readLong());
        }

        @Override
        protected void skipValue(Decoder decoder) throws IOException {
            decoder.readLong();
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper);
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper) {
                super(name, skipper);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
                return parser.setNumber(decoder.readLong());
            }

            @Override
            public void skipValue(BinaryDecoder decoder) throws IOException {
                decoder.readLong();
            }
        }
    }

    protected static final class CharReader
    extends ScalarDecoder {
        protected CharReader() {
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser, Decoder decoder) throws IOException {
            return parser.setString(Character.toString((char)decoder.readInt()));
        }

        @Override
        protected void skipValue(Decoder decoder) throws IOException {
            decoder.readInt();
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper);
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper) {
                super(name, skipper);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
                return parser.setString(Character.toString((char)decoder.readInt()));
            }

            @Override
            public void skipValue(BinaryDecoder decoder) throws IOException {
                decoder.readInt();
            }
        }
    }

    protected static final class IntReader
    extends ScalarDecoder {
        protected IntReader() {
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser, Decoder decoder) throws IOException {
            return parser.setNumber(decoder.readInt());
        }

        @Override
        protected void skipValue(Decoder decoder) throws IOException {
            decoder.readInt();
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper);
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper) {
                super(name, skipper);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
                return parser.setNumber(decoder.readInt());
            }

            @Override
            public void skipValue(BinaryDecoder decoder) throws IOException {
                decoder.readInt();
            }
        }
    }

    protected static final class FloatReader
    extends ScalarDecoder {
        protected FloatReader() {
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser, Decoder decoder) throws IOException {
            return parser.setNumber(decoder.readFloat());
        }

        @Override
        protected void skipValue(Decoder decoder) throws IOException {
            decoder.skipFixed(4);
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper);
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper) {
                super(name, skipper);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
                return parser.setNumber(decoder.readFloat());
            }

            @Override
            public void skipValue(BinaryDecoder decoder) throws IOException {
                decoder.skipFixed(4);
            }
        }
    }

    protected static final class DoubleReader
    extends ScalarDecoder {
        protected DoubleReader() {
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser, Decoder decoder) throws IOException {
            return parser.setNumber(decoder.readDouble());
        }

        @Override
        protected void skipValue(Decoder decoder) throws IOException {
            decoder.skipFixed(8);
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper);
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper) {
                super(name, skipper);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
                return parser.setNumber(decoder.readDouble());
            }

            @Override
            public void skipValue(BinaryDecoder decoder) throws IOException {
                decoder.skipFixed(8);
            }
        }
    }

    protected static final class BytesDecoder
    extends ScalarDecoder {
        protected BytesDecoder() {
        }

        @Override
        public JsonToken decodeValue(AvroParserImpl parser, Decoder decoder) throws IOException {
            ByteBuffer bb = parser.borrowByteBuffer();
            bb = decoder.readBytes(bb);
            return parser.setBytes(bb);
        }

        @Override
        protected void skipValue(Decoder decoder) throws IOException {
            decoder.skipBytes();
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper);
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper) {
                super(name, skipper);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
                ByteBuffer bb = parser.borrowByteBuffer();
                bb = decoder.readBytes(bb);
                return parser.setBytes(bb);
            }

            @Override
            public void skipValue(BinaryDecoder decoder) throws IOException {
                decoder.skipBytes();
            }
        }
    }

    protected static final class BooleanDecoder
    extends ScalarDecoder {
        protected BooleanDecoder() {
        }

        @Override
        protected JsonToken decodeValue(AvroParserImpl parser, Decoder decoder) throws IOException {
            return decoder.readBoolean() ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
        }

        @Override
        protected void skipValue(Decoder decoder) throws IOException {
            decoder.skipFixed(1);
        }

        @Override
        public AvroFieldReader asFieldReader(String name, boolean skipper) {
            return new FR(name, skipper);
        }

        private static final class FR
        extends AvroFieldReader {
            public FR(String name, boolean skipper) {
                super(name, skipper);
            }

            @Override
            public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
                return decoder.readBoolean() ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
            }

            @Override
            public void skipValue(BinaryDecoder decoder) throws IOException {
                decoder.skipFixed(1);
            }
        }
    }
}

