/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroFieldReader;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.AvroStructureReader;
import com.fasterxml.jackson.dataformat.avro.deser.DecodeUtil;
import java.io.IOException;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;

abstract class RecordReader
extends AvroStructureReader {
    protected static final int STATE_START = 0;
    protected static final int STATE_NAME = 1;
    protected static final int STATE_VALUE = 2;
    protected static final int STATE_END = 3;
    protected static final int STATE_DONE = 4;
    protected final AvroFieldReader[] _fieldReaders;
    protected final BinaryDecoder _decoder;
    protected final AvroParserImpl _parser;
    protected String _currentName;
    protected int _state;
    protected final int _count;

    protected RecordReader(AvroReadContext parent, AvroFieldReader[] fieldReaders, BinaryDecoder decoder, AvroParserImpl parser) {
        super(parent, 2);
        this._fieldReaders = fieldReaders;
        this._decoder = decoder;
        this._parser = parser;
        this._count = fieldReaders.length;
    }

    @Override
    public abstract RecordReader newReader(AvroReadContext var1, AvroParserImpl var2, BinaryDecoder var3);

    @Override
    public String getCurrentName() {
        return this._currentName;
    }

    @Override
    public final void skipValue(BinaryDecoder decoder) throws IOException {
        int end = this._fieldReaders.length;
        for (int i = 0; i < end; ++i) {
            this._fieldReaders[i].skipValue(decoder);
        }
    }

    protected final JsonToken _nextAtEndObject() throws IOException {
        AvroReadContext parent = this.getParent();
        if (parent.inRoot() && !DecodeUtil.isEnd((Decoder)this._decoder)) {
            this._state = 0;
            this._index = 0;
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        this._state = 4;
        this._parser.setAvroContext(this.getParent());
        this._currToken = JsonToken.END_OBJECT;
        return this._currToken;
    }

    @Override
    public void appendDesc(StringBuilder sb) {
        sb.append('{');
        if (this._currentName != null) {
            sb.append('\"');
            sb.append(this._currentName);
            sb.append('\"');
        } else {
            sb.append('?');
        }
        sb.append('}');
    }

    public static final class Resolving
    extends RecordReader {
        public Resolving(AvroFieldReader[] fieldReaders) {
            super(null, fieldReaders, null, null);
        }

        public Resolving(AvroReadContext parent, AvroFieldReader[] fieldReaders, BinaryDecoder decoder, AvroParserImpl parser) {
            super(parent, fieldReaders, decoder, parser);
        }

        @Override
        public RecordReader newReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
            return new Resolving(parent, this._fieldReaders, decoder, parser);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            JsonToken t;
            switch (this._state) {
                case 0: {
                    JsonToken t2;
                    this._parser.setAvroContext(this);
                    this._state = this._count > 0 ? 1 : 3;
                    this._currToken = t2 = JsonToken.START_OBJECT;
                    return t2;
                }
                case 1: {
                    while (this._index < this._count) {
                        AvroFieldReader r = this._fieldReaders[this._index];
                        if (r.isSkipper()) {
                            ++this._index;
                            r.skipValue(this._decoder);
                            continue;
                        }
                        this._currentName = r.getName();
                        this._state = 2;
                        this._currToken = JsonToken.FIELD_NAME;
                        return this._currToken;
                    }
                    return this._nextAtEndObject();
                }
                case 2: {
                    break;
                }
                case 3: {
                    return this._nextAtEndObject();
                }
                default: {
                    this.throwIllegalState(this._state);
                }
            }
            this._state = 1;
            AvroFieldReader field = this._fieldReaders[this._index];
            ++this._index;
            this._currToken = t = field.readValue(this, this._parser, this._decoder);
            return t;
        }

        @Override
        public String nextFieldName() throws IOException {
            if (this._state == 1) {
                while (this._index < this._count) {
                    String name;
                    AvroFieldReader r = this._fieldReaders[this._index];
                    if (r.isSkipper()) {
                        ++this._index;
                        r.skipValue(this._decoder);
                        continue;
                    }
                    this._currentName = name = r.getName();
                    this._state = 2;
                    this._currToken = JsonToken.FIELD_NAME;
                    return name;
                }
                this._nextAtEndObject();
            } else {
                this.nextToken();
            }
            return null;
        }
    }

    public static final class Std
    extends RecordReader {
        public Std(AvroFieldReader[] fieldReaders) {
            super(null, fieldReaders, null, null);
        }

        public Std(AvroReadContext parent, AvroFieldReader[] fieldReaders, BinaryDecoder decoder, AvroParserImpl parser) {
            super(parent, fieldReaders, decoder, parser);
        }

        @Override
        public RecordReader newReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
            return new Std(parent, this._fieldReaders, decoder, parser);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            JsonToken t;
            switch (this._state) {
                case 0: {
                    JsonToken t2;
                    this._parser.setAvroContext(this);
                    this._state = this._count > 0 ? 1 : 3;
                    this._currToken = t2 = JsonToken.START_OBJECT;
                    return t2;
                }
                case 1: {
                    if (this._index < this._count) {
                        JsonToken t3;
                        this._currentName = this._fieldReaders[this._index].getName();
                        this._state = 2;
                        this._currToken = t3 = JsonToken.FIELD_NAME;
                        return t3;
                    }
                    return this._nextAtEndObject();
                }
                case 2: {
                    break;
                }
                case 3: {
                    return this._nextAtEndObject();
                }
                default: {
                    this.throwIllegalState(this._state);
                }
            }
            this._state = 1;
            AvroFieldReader field = this._fieldReaders[this._index];
            ++this._index;
            this._currToken = t = field.readValue(this, this._parser, this._decoder);
            return t;
        }

        @Override
        public String nextFieldName() throws IOException {
            if (this._state == 1) {
                if (this._index < this._count) {
                    String name;
                    this._currentName = name = this._fieldReaders[this._index].getName();
                    this._state = 2;
                    this._currToken = JsonToken.FIELD_NAME;
                    return name;
                }
                this._nextAtEndObject();
            } else {
                this.nextToken();
            }
            return null;
        }
    }
}

