/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.AvroStructureReader;
import com.fasterxml.jackson.dataformat.avro.deser.DecodeUtil;
import com.fasterxml.jackson.dataformat.avro.deser.ScalarDecoder;
import java.io.IOException;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;

public abstract class MapReader
extends AvroStructureReader {
    protected static final int STATE_START = 0;
    protected static final int STATE_NAME = 1;
    protected static final int STATE_VALUE = 2;
    protected static final int STATE_END = 3;
    protected static final int STATE_DONE = 4;
    protected final BinaryDecoder _decoder;
    protected final AvroParserImpl _parser;
    protected String _currentName;
    protected int _state;

    protected MapReader() {
        this(null, null, null);
    }

    protected MapReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
        super(parent, 2);
        this._decoder = decoder;
        this._parser = parser;
    }

    public static MapReader construct(ScalarDecoder dec) {
        return new Scalar(dec);
    }

    public static MapReader construct(AvroStructureReader reader) {
        return new NonScalar(reader);
    }

    @Override
    public abstract MapReader newReader(AvroReadContext var1, AvroParserImpl var2, BinaryDecoder var3);

    @Override
    public String getCurrentName() {
        return this._currentName;
    }

    @Override
    public abstract JsonToken nextToken() throws IOException;

    @Override
    public abstract void skipValue(BinaryDecoder var1) throws IOException;

    @Override
    public String nextFieldName() throws IOException {
        JsonToken t = this.nextToken();
        if (t == JsonToken.FIELD_NAME) {
            return this._currentName;
        }
        return null;
    }

    @Override
    public void appendDesc(StringBuilder sb) {
        sb.append('{');
        if (this._currentName != null) {
            sb.append('\"');
            sb.append(this._currentName);
            sb.append('\"');
        } else {
            sb.append('?');
        }
        sb.append('}');
    }

    private static final class NonScalar
    extends MapReader {
        private final AvroStructureReader _structureReader;
        protected long _count;

        public NonScalar(AvroStructureReader reader) {
            this._structureReader = reader;
        }

        public NonScalar(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder avroDecoder, AvroStructureReader reader) {
            super(parent, parser, avroDecoder);
            this._structureReader = reader;
        }

        @Override
        public MapReader newReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
            return new NonScalar(parent, parser, decoder, this._structureReader);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._count = this._decoder.readMapStart();
                    this._state = this._count > 0L ? 1 : 3;
                    this._currToken = JsonToken.START_OBJECT;
                    return this._currToken;
                }
                case 1: {
                    if ((long)this._index < this._count) {
                        this._state = 2;
                        this._currentName = this._decoder.readString();
                        this._currToken = JsonToken.FIELD_NAME;
                        return this._currToken;
                    }
                    this._count = this._decoder.mapNext();
                    if (this._count > 0L) {
                        this._index = 0;
                        this._currentName = this._decoder.readString();
                        this._currToken = JsonToken.FIELD_NAME;
                        return this._currToken;
                    }
                }
                case 3: {
                    AvroReadContext parent = this.getParent();
                    if (parent.inRoot() && !DecodeUtil.isEnd((Decoder)this._decoder)) {
                        this._index = 0;
                        this._state = 0;
                        this._currToken = JsonToken.END_OBJECT;
                        return this._currToken;
                    }
                    this._state = 4;
                    this._parser.setAvroContext(parent);
                    this._currToken = JsonToken.END_OBJECT;
                    return this._currToken;
                }
                case 2: {
                    break;
                }
                default: {
                    this.throwIllegalState(this._state);
                }
            }
            this._state = 1;
            ++this._index;
            AvroStructureReader r = this._structureReader.newReader(this, this._parser, this._decoder);
            this._parser.setAvroContext(r);
            this._currToken = r.nextToken();
            return this._currToken;
        }

        @Override
        public void skipValue(BinaryDecoder decoder) throws IOException {
            long l;
            while ((l = decoder.skipMap()) > 0L) {
                while (--l >= 0L) {
                    this._structureReader.skipValue(decoder);
                }
            }
        }
    }

    private static final class Scalar
    extends MapReader {
        private final ScalarDecoder _scalarDecoder;
        protected long _count;

        protected Scalar(ScalarDecoder dec) {
            this._scalarDecoder = dec;
        }

        protected Scalar(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder avroDecoder, ScalarDecoder sd) {
            super(parent, parser, avroDecoder);
            this._scalarDecoder = sd;
        }

        @Override
        public MapReader newReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
            return new Scalar(parent, parser, decoder, this._scalarDecoder);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._count = this._decoder.readMapStart();
                    this._state = this._count > 0L ? 1 : 3;
                    this._currToken = JsonToken.START_OBJECT;
                    return this._currToken;
                }
                case 1: {
                    if ((long)this._index < this._count) {
                        this._state = 2;
                        this._currentName = this._decoder.readString();
                        this._currToken = JsonToken.FIELD_NAME;
                        return this._currToken;
                    }
                    this._count = this._decoder.mapNext();
                    if (this._count > 0L) {
                        this._index = 0;
                        this._currentName = this._decoder.readString();
                        this._currToken = JsonToken.FIELD_NAME;
                        return this._currToken;
                    }
                }
                case 3: {
                    AvroReadContext parent = this.getParent();
                    if (parent.inRoot() && !DecodeUtil.isEnd((Decoder)this._decoder)) {
                        this._index = 0;
                        this._state = 0;
                        this._currToken = JsonToken.END_OBJECT;
                        return this._currToken;
                    }
                    this._state = 4;
                    this._parser.setAvroContext(parent);
                    this._currToken = JsonToken.END_OBJECT;
                    return this._currToken;
                }
                case 2: {
                    break;
                }
                default: {
                    this.throwIllegalState(this._state);
                }
            }
            this._state = 1;
            ++this._index;
            return this._scalarDecoder.decodeValue(this._parser, (Decoder)this._decoder);
        }

        @Override
        public void skipValue(BinaryDecoder decoder) throws IOException {
            long l;
            while ((l = decoder.skipMap()) > 0L) {
                while (--l >= 0L) {
                    this._scalarDecoder.skipValue((Decoder)decoder);
                }
            }
        }
    }
}

