/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.avro.AvroParser;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import com.fasterxml.jackson.dataformat.avro.CodecRecycler;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.AvroStructureReader;
import com.fasterxml.jackson.dataformat.avro.deser.RootReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.avro.io.BinaryDecoder;

public class AvroParserImpl
extends AvroParser {
    protected static final byte[] NO_BYTES = new byte[0];
    protected BinaryDecoder _decoder;
    protected ByteBuffer _byteBuffer;

    public AvroParserImpl(IOContext ctxt, int parserFeatures, int avroFeatures, ObjectCodec codec, InputStream in) {
        super(ctxt, parserFeatures, avroFeatures, codec, in);
        this._decoder = CodecRecycler.decoder(in, AvroParser.Feature.AVRO_BUFFERING.enabledIn(avroFeatures));
    }

    public AvroParserImpl(IOContext ctxt, int parserFeatures, int avroFeatures, ObjectCodec codec, byte[] data, int offset, int len) {
        super(ctxt, parserFeatures, avroFeatures, codec, data, offset, len);
        this._decoder = CodecRecycler.decoder(data, offset, len);
    }

    protected void _releaseBuffers() throws IOException {
        super._releaseBuffers();
        BinaryDecoder d = this._decoder;
        if (d != null) {
            this._decoder = null;
            CodecRecycler.release(d);
        }
    }

    @Override
    public JsonParser overrideFormatFeatures(int values, int mask) {
        int oldF = this._formatFeatures;
        int newF = this._formatFeatures & ~mask | values & mask;
        if (oldF != newF) {
            this._formatFeatures = newF;
        }
        return this;
    }

    @Override
    public JsonToken nextToken() throws IOException {
        JsonToken t;
        this._binaryValue = null;
        if (this._closed) {
            return null;
        }
        this._currToken = t = this._avroContext.nextToken();
        return t;
    }

    public String nextFieldName() throws IOException {
        this._binaryValue = null;
        if (this._closed) {
            return null;
        }
        String name = this._avroContext.nextFieldName();
        if (name == null) {
            this._currToken = this._avroContext.getCurrentToken();
            return null;
        }
        this._currToken = JsonToken.FIELD_NAME;
        return name;
    }

    public boolean nextFieldName(SerializableString sstr) throws IOException {
        this._binaryValue = null;
        if (this._closed) {
            return false;
        }
        String name = this._avroContext.nextFieldName();
        if (name == null) {
            this._currToken = this._avroContext.getCurrentToken();
            return false;
        }
        this._currToken = JsonToken.FIELD_NAME;
        return name.equals(sstr.getValue());
    }

    public String nextTextValue() throws IOException {
        return this.nextToken() == JsonToken.VALUE_STRING ? this._textValue : null;
    }

    @Override
    protected void _initSchema(AvroSchema schema) throws JsonProcessingException {
        AvroStructureReader reader = schema.getReader();
        RootReader root = new RootReader();
        this._avroContext = reader.newReader(root, this, this._decoder);
    }

    protected void setAvroContext(AvroReadContext ctxt) {
        if (ctxt == null) {
            throw new IllegalArgumentException();
        }
        this._avroContext = ctxt;
    }

    protected ByteBuffer borrowByteBuffer() {
        return this._byteBuffer;
    }

    protected JsonToken setBytes(ByteBuffer bb) {
        int len = bb.remaining();
        if (len <= 0) {
            this._binaryValue = NO_BYTES;
        } else {
            this._binaryValue = new byte[len];
            bb.get(this._binaryValue);
            this._byteBuffer = bb;
        }
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    protected JsonToken setBytes(byte[] b) {
        this._binaryValue = b;
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    protected JsonToken setNumber(int v) {
        this._numberInt = v;
        this._numTypesValid = 1;
        return JsonToken.VALUE_NUMBER_INT;
    }

    protected JsonToken setNumber(long v) {
        this._numberLong = v;
        this._numTypesValid = 2;
        return JsonToken.VALUE_NUMBER_INT;
    }

    protected JsonToken setNumber(float v) {
        this._numberDouble = v;
        this._numTypesValid = 8;
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    protected JsonToken setNumber(double v) {
        this._numberDouble = v;
        this._numTypesValid = 8;
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    protected JsonToken setString(String str) {
        this._textValue = str;
        return JsonToken.VALUE_STRING;
    }
}

