/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.AvroStructureReader;
import java.io.IOException;
import org.apache.avro.io.BinaryDecoder;

public abstract class AvroFieldReader {
    protected final String _name;
    protected final boolean _isSkipper;

    protected AvroFieldReader(String name, boolean isSkipper) {
        this._name = name;
        this._isSkipper = isSkipper;
    }

    public static AvroFieldReader construct(String name, AvroStructureReader structureReader) {
        return new Structured(name, false, structureReader);
    }

    public static AvroFieldReader constructSkipper(String name, AvroStructureReader structureReader) {
        return new Structured(name, true, structureReader);
    }

    public final String getName() {
        return this._name;
    }

    public final boolean isSkipper() {
        return this._isSkipper;
    }

    public abstract JsonToken readValue(AvroReadContext var1, AvroParserImpl var2, BinaryDecoder var3) throws IOException;

    public abstract void skipValue(BinaryDecoder var1) throws IOException;

    private static final class Structured
    extends AvroFieldReader {
        protected final AvroStructureReader _reader;

        public Structured(String name, boolean skipper, AvroStructureReader r) {
            super(name, skipper);
            this._reader = r;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
            return this._reader.newReader(parent, parser, decoder).nextToken();
        }

        @Override
        public void skipValue(BinaryDecoder decoder) throws IOException {
            this._reader.skipValue(decoder);
        }
    }
}

