/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.AvroStructureReader;
import com.fasterxml.jackson.dataformat.avro.deser.DecodeUtil;
import com.fasterxml.jackson.dataformat.avro.deser.ScalarDecoder;
import java.io.IOException;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;

abstract class ArrayReader
extends AvroStructureReader {
    protected static final int STATE_START = 0;
    protected static final int STATE_ELEMENTS = 1;
    protected static final int STATE_END = 2;
    protected static final int STATE_DONE = 3;
    protected final BinaryDecoder _decoder;
    protected final AvroParserImpl _parser;
    protected int _state;
    protected long _count;
    protected String _currentName;

    protected ArrayReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
        super(parent, 1);
        this._parser = parser;
        this._decoder = decoder;
    }

    public static ArrayReader construct(ScalarDecoder reader) {
        return new Scalar(reader);
    }

    public static ArrayReader construct(AvroStructureReader reader) {
        return new NonScalar(reader);
    }

    @Override
    public String nextFieldName() throws IOException {
        this.nextToken();
        return null;
    }

    @Override
    public String getCurrentName() {
        if (this._currentName == null) {
            this._currentName = this._parent.getCurrentName();
        }
        return this._currentName;
    }

    @Override
    protected void appendDesc(StringBuilder sb) {
        sb.append('[');
        sb.append(this.getCurrentIndex());
        sb.append(']');
    }

    private static final class NonScalar
    extends ArrayReader {
        private final AvroStructureReader _elementReader;

        public NonScalar(AvroStructureReader reader) {
            this(null, reader, null, null);
        }

        private NonScalar(AvroReadContext parent, AvroStructureReader reader, AvroParserImpl parser, BinaryDecoder decoder) {
            super(parent, parser, decoder);
            this._elementReader = reader;
        }

        @Override
        public NonScalar newReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
            return new NonScalar(parent, this._elementReader, parser, decoder);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._count = this._decoder.readArrayStart();
                    this._state = this._count > 0L ? 1 : 2;
                    this._currToken = JsonToken.START_ARRAY;
                    return this._currToken;
                }
                case 1: {
                    if ((long)this._index < this._count) break;
                    this._count = this._decoder.arrayNext();
                    if (this._count > 0L) {
                        this._index = 0;
                        break;
                    }
                }
                case 2: {
                    AvroReadContext parent = this.getParent();
                    if (parent.inRoot() && !DecodeUtil.isEnd((Decoder)this._decoder)) {
                        this._index = 0;
                        this._state = 0;
                        this._currToken = JsonToken.END_ARRAY;
                        return this._currToken;
                    }
                    this._state = 3;
                    this._parser.setAvroContext(parent);
                    this._currToken = JsonToken.END_ARRAY;
                    return this._currToken;
                }
                default: {
                    this.throwIllegalState(this._state);
                }
            }
            ++this._index;
            AvroStructureReader r = this._elementReader.newReader(this, this._parser, this._decoder);
            this._parser.setAvroContext(r);
            this._currToken = r.nextToken();
            return this._currToken;
        }

        @Override
        public void skipValue(BinaryDecoder decoder) throws IOException {
            long l;
            while ((l = decoder.skipArray()) > 0L) {
                while (--l >= 0L) {
                    this._elementReader.skipValue(decoder);
                }
            }
        }
    }

    private static final class Scalar
    extends ArrayReader {
        private final ScalarDecoder _elementReader;

        public Scalar(ScalarDecoder reader) {
            this(null, reader, null, null);
        }

        private Scalar(AvroReadContext parent, ScalarDecoder reader, AvroParserImpl parser, BinaryDecoder decoder) {
            super(parent, parser, decoder);
            this._elementReader = reader;
        }

        @Override
        public Scalar newReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
            return new Scalar(parent, this._elementReader, parser, decoder);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            JsonToken t;
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._index = 0;
                    this._count = this._decoder.readArrayStart();
                    this._state = this._count > 0L ? 1 : 2;
                    this._currToken = JsonToken.START_ARRAY;
                    return this._currToken;
                }
                case 1: {
                    if ((long)this._index < this._count) break;
                    this._count = this._decoder.arrayNext();
                    if (this._count > 0L) {
                        this._index = 0;
                        break;
                    }
                }
                case 2: {
                    AvroReadContext parent = this.getParent();
                    if (parent.inRoot() && !DecodeUtil.isEnd((Decoder)this._decoder)) {
                        this._index = 0;
                        this._state = 0;
                        this._currToken = JsonToken.END_ARRAY;
                        return this._currToken;
                    }
                    this._state = 3;
                    this._parser.setAvroContext(parent);
                    this._currToken = JsonToken.END_ARRAY;
                    return this._currToken;
                }
                default: {
                    this.throwIllegalState(this._state);
                    return null;
                }
            }
            ++this._index;
            this._currToken = t = this._elementReader.decodeValue(this._parser, (Decoder)this._decoder);
            return t;
        }

        @Override
        public void skipValue(BinaryDecoder decoder) throws IOException {
            long l;
            while ((l = decoder.skipArray()) > 0L) {
                while (--l >= 0L) {
                    this._elementReader.skipValue((Decoder)decoder);
                }
            }
        }
    }
}

