/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;

public final class CodecRecycler {
    protected static final DecoderFactory DECODER_FACTORY = DecoderFactory.get();
    protected static final EncoderFactory ENCODER_FACTORY = EncoderFactory.get();
    protected static final ThreadLocal<SoftReference<CodecRecycler>> _recycler = new ThreadLocal();
    private BinaryDecoder decoder;
    private BinaryEncoder encoder;

    private CodecRecycler() {
    }

    public static BinaryDecoder decoder(InputStream in, boolean buffering) {
        BinaryDecoder prev = CodecRecycler._recycler().claimDecoder();
        return buffering ? DECODER_FACTORY.binaryDecoder(in, prev) : DECODER_FACTORY.directBinaryDecoder(in, prev);
    }

    public static BinaryDecoder decoder(byte[] buffer, int offset, int len) {
        BinaryDecoder prev = CodecRecycler._recycler().claimDecoder();
        return DECODER_FACTORY.binaryDecoder(buffer, offset, len, prev);
    }

    public static BinaryEncoder encoder(OutputStream out, boolean buffering) {
        BinaryEncoder prev = CodecRecycler._recycler().claimEncoder();
        return buffering ? ENCODER_FACTORY.binaryEncoder(out, prev) : ENCODER_FACTORY.directBinaryEncoder(out, prev);
    }

    public static void release(BinaryDecoder dec) {
        CodecRecycler._recycler().decoder = dec;
    }

    public static void release(BinaryEncoder enc) {
        CodecRecycler._recycler().encoder = enc;
    }

    private static CodecRecycler _recycler() {
        CodecRecycler r;
        SoftReference<CodecRecycler> ref = _recycler.get();
        CodecRecycler codecRecycler = r = ref == null ? null : ref.get();
        if (r == null) {
            r = new CodecRecycler();
            _recycler.set(new SoftReference<CodecRecycler>(r));
        }
        return r;
    }

    private BinaryDecoder claimDecoder() {
        BinaryDecoder d = this.decoder;
        this.decoder = null;
        return d;
    }

    private BinaryEncoder claimEncoder() {
        BinaryEncoder e = this.encoder;
        this.encoder = null;
        return e;
    }

    public static class BadSchemaException
    extends JsonProcessingException {
        private static final long serialVersionUID = 1L;

        public BadSchemaException(String msg, Throwable src) {
            super(msg, src);
        }
    }
}

