/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonReadContext;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import com.fasterxml.jackson.dataformat.avro.PackageVersion;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.MissingReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

public abstract class AvroParser
extends ParserBase {
    protected ObjectCodec _objectCodec;
    protected AvroSchema _rootSchema;
    protected int _formatFeatures;
    protected final InputStream _input;
    protected AvroReadContext _avroContext;
    protected String _textValue;

    protected AvroParser(IOContext ctxt, int parserFeatures, int avroFeatures, ObjectCodec codec, InputStream in) {
        super(ctxt, parserFeatures);
        this._objectCodec = codec;
        this._formatFeatures = avroFeatures;
        this._input = in;
        this._avroContext = MissingReader.instance;
    }

    protected AvroParser(IOContext ctxt, int parserFeatures, int avroFeatures, ObjectCodec codec, byte[] data, int offset, int len) {
        super(ctxt, parserFeatures);
        this._objectCodec = codec;
        this._formatFeatures = avroFeatures;
        this._input = null;
        this._avroContext = MissingReader.instance;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    public Object getInputSource() {
        return this._input;
    }

    public abstract JsonParser overrideFormatFeatures(int var1, int var2);

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected void _finishString() throws IOException {
        this._reportUnsupportedOperation();
    }

    protected void _closeInput() throws IOException {
        if (this._input != null) {
            this._input.close();
        }
    }

    public JsonParser enable(Feature f) {
        this._formatFeatures |= f.getMask();
        return this;
    }

    public JsonParser disable(Feature f) {
        this._formatFeatures &= ~f.getMask();
        return this;
    }

    public JsonParser configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public boolean isEnabled(Feature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof AvroSchema;
    }

    public AvroSchema getSchema() {
        return this._rootSchema;
    }

    public void setSchema(FormatSchema schema) {
        if (this._rootSchema == schema) {
            return;
        }
        if (schema instanceof AvroSchema) {
            try {
                this._initSchema((AvroSchema)schema);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            super.setSchema(schema);
        }
    }

    protected abstract void _initSchema(AvroSchema var1) throws JsonProcessingException;

    public JsonLocation getTokenLocation() {
        return null;
    }

    public JsonLocation getCurrentLocation() {
        return null;
    }

    public abstract JsonToken nextToken() throws IOException;

    public boolean hasTextCharacters() {
        return false;
    }

    public String getText() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textValue;
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._avroContext.getCurrentName();
        }
        if (this._currToken != null) {
            if (this._currToken.isScalarValue()) {
                return this._textValue;
            }
            return this._currToken.asString();
        }
        return null;
    }

    public int getText(Writer writer) throws IOException {
        JsonToken t = this._currToken;
        if (t == JsonToken.VALUE_STRING) {
            writer.write(this._textValue);
            return this._textValue.length();
        }
        if (t == JsonToken.FIELD_NAME) {
            String n = this._parsingContext.getCurrentName();
            writer.write(n);
            return n.length();
        }
        if (t != null) {
            if (t.isNumeric()) {
                return this._textBuffer.contentsToWriter(writer);
            }
            char[] ch = t.asCharArray();
            writer.write(ch);
            return ch.length;
        }
        return 0;
    }

    public String getCurrentName() throws IOException {
        return this._avroContext.getCurrentName();
    }

    public void overrideCurrentName(String name) {
        JsonReadContext ctxt = this._parsingContext;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            ctxt = ctxt.getParent();
        }
        try {
            ctxt.setCurrentName(name);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public char[] getTextCharacters() throws IOException {
        String text = this.getText();
        return text == null ? null : text.toCharArray();
    }

    public int getTextLength() throws IOException {
        String text = this.getText();
        return text == null ? 0 : text.length();
    }

    public int getTextOffset() throws IOException {
        return 0;
    }

    public Object getEmbeddedObject() throws IOException {
        return this._binaryValue;
    }

    public byte[] getBinaryValue(Base64Variant variant) throws IOException {
        if (this._binaryValue == null) {
            if (this._currToken != JsonToken.VALUE_STRING) {
                this._reportError("Current token (" + this._currToken + ") not VALUE_STRING, can not access as binary");
            }
            ByteArrayBuilder builder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), builder, variant);
            this._binaryValue = builder.toByteArray();
        }
        return this._binaryValue;
    }

    public static enum Feature implements FormatFeature
    {
        AVRO_BUFFERING(true);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }
    }
}

