/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.avro.AvroAnnotationIntrospector;
import com.fasterxml.jackson.dataformat.avro.AvroSerializerModifier;
import com.fasterxml.jackson.dataformat.avro.PackageVersion;
import java.io.IOException;
import org.apache.avro.Schema;

public class AvroModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    protected static final AvroAnnotationIntrospector INTR = new AvroAnnotationIntrospector();
    protected boolean _cfgAddIntrospector = true;
    @Deprecated
    public Schema schema;

    public AvroModule() {
        super(PackageVersion.VERSION);
        this.addSerializer((JsonSerializer)new SchemaSerializer());
        this.setSerializerModifier(new AvroSerializerModifier());
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        if (this._cfgAddIntrospector) {
            context.insertAnnotationIntrospector((AnnotationIntrospector)INTR);
        }
    }

    public AvroModule withAnnotationIntrospector(boolean state) {
        this._cfgAddIntrospector = state;
        return this;
    }

    public static class SchemaSerializer
    extends StdSerializer<Schema> {
        private static final long serialVersionUID = 1L;

        public SchemaSerializer() {
            super(Schema.class);
        }

        public void serialize(Schema value, JsonGenerator gen, SerializerProvider prov) throws IOException {
            gen.writeString(value.toString());
        }
    }
}

