/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.ser;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.avro.AvroGenerator;
import com.fasterxml.jackson.dataformat.avro.ser.ArrayWriteContext;
import com.fasterxml.jackson.dataformat.avro.ser.AvroWriteContext;
import com.fasterxml.jackson.dataformat.avro.ser.NonBSGenericDatumWriter;
import com.fasterxml.jackson.dataformat.avro.ser.ObjectWriteContext;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;

class RootContext
extends AvroWriteContext {
    protected GenericContainer _rootValue;

    public RootContext(AvroGenerator generator, Schema schema) {
        super(0, null, generator, schema);
    }

    @Override
    public Object rawValue() {
        return this._rootValue;
    }

    @Override
    public final AvroWriteContext createChildArrayContext() throws JsonMappingException {
        GenericArray<Object> arr;
        switch (this._schema.getType()) {
            case ARRAY: 
            case UNION: {
                break;
            }
            default: {
                throw new IllegalStateException("Can not write START_ARRAY; schema type is " + this._schema.getType());
            }
        }
        this._rootValue = arr = this._createArray(this._schema);
        return new ArrayWriteContext(this, this._generator, arr);
    }

    @Override
    public final AvroWriteContext createChildObjectContext() throws JsonMappingException {
        switch (this._schema.getType()) {
            case UNION: 
            case RECORD: {
                break;
            }
            case MAP: {
                throw new UnsupportedOperationException("Root-level Maps not supported: Avro Codec has no way to create these");
            }
            default: {
                throw new IllegalStateException("Can not write START_OBJECT; schema type is " + this._schema.getType());
            }
        }
        GenericRecord rec = this._createRecord(this._schema);
        this._rootValue = rec;
        return new ObjectWriteContext((AvroWriteContext)this, this._generator, rec);
    }

    @Override
    public void writeValue(Object value) {
        this._reportError();
    }

    @Override
    public void writeString(String value) {
        this._reportError();
    }

    @Override
    public void complete(BinaryEncoder encoder) throws IOException {
        new NonBSGenericDatumWriter(this._schema).write(this._rootValue, (Encoder)encoder);
    }

    @Override
    public void appendDesc(StringBuilder sb) {
        sb.append("/");
    }

    protected void _reportError() {
        throw new IllegalStateException("Can not write values directly in root context, outside of Records/Arrays");
    }
}

