/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.schema;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.dataformat.avro.AvroFixedSize;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaHelper;
import com.fasterxml.jackson.dataformat.avro.schema.DefinedSchemas;
import com.fasterxml.jackson.dataformat.avro.schema.SchemaBuilder;
import com.fasterxml.jackson.dataformat.avro.schema.VisitorFormatWrapperImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;

public class RecordVisitor
extends JsonObjectFormatVisitor.Base
implements SchemaBuilder {
    protected final JavaType _type;
    protected final DefinedSchemas _schemas;
    protected Schema _avroSchema;
    protected List<Schema.Field> _fields = new ArrayList<Schema.Field>();

    public RecordVisitor(SerializerProvider p, JavaType type, DefinedSchemas schemas) {
        super(p);
        this._type = type;
        this._schemas = schemas;
        this._avroSchema = Schema.createRecord((String)AvroSchemaHelper.getName(type), (String)("Schema for " + type.toCanonical()), (String)AvroSchemaHelper.getNamespace(type), (boolean)false);
        schemas.addSchema(type, this._avroSchema);
    }

    @Override
    public Schema builtAvroSchema() {
        this._avroSchema.setFields(this._fields);
        return this._avroSchema;
    }

    public void property(BeanProperty writer) throws JsonMappingException {
        Schema schema = this.schemaForWriter(writer);
        this._fields.add(new Schema.Field(writer.getName(), schema, null, null));
    }

    public void property(String name, JsonFormatVisitable handler, JavaType type) throws JsonMappingException {
        VisitorFormatWrapperImpl wrapper = new VisitorFormatWrapperImpl(this._schemas, this.getProvider());
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)wrapper, type);
        Schema schema = wrapper.getAvroSchema();
        this._fields.add(new Schema.Field(name, schema, null, null));
    }

    public void optionalProperty(BeanProperty writer) throws JsonMappingException {
        Schema schema = this.schemaForWriter(writer);
        if (!writer.getType().isPrimitive()) {
            schema = AvroSchemaHelper.unionWithNull(schema);
        }
        this._fields.add(new Schema.Field(writer.getName(), schema, null, null));
    }

    public void optionalProperty(String name, JsonFormatVisitable handler, JavaType type) throws JsonMappingException {
        VisitorFormatWrapperImpl wrapper = new VisitorFormatWrapperImpl(this._schemas, this.getProvider());
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)wrapper, type);
        Schema schema = wrapper.getAvroSchema();
        if (!type.isPrimitive()) {
            schema = AvroSchemaHelper.unionWithNull(schema);
        }
        this._fields.add(new Schema.Field(name, schema, null, null));
    }

    protected Schema schemaForWriter(BeanProperty prop) throws JsonMappingException {
        AvroFixedSize fixedSize = (AvroFixedSize)prop.getAnnotation(AvroFixedSize.class);
        if (fixedSize != null) {
            return Schema.createFixed((String)fixedSize.typeName(), null, (String)fixedSize.typeNamespace(), (int)fixedSize.size());
        }
        JsonSerializer ser = null;
        if (prop instanceof BeanPropertyWriter) {
            BeanPropertyWriter bpw = (BeanPropertyWriter)prop;
            ser = bpw.getSerializer();
        }
        SerializerProvider prov = this.getProvider();
        if (ser == null) {
            if (prov == null) {
                throw new JsonMappingException("SerializerProvider missing for RecordVisitor");
            }
            ser = prov.findValueSerializer(prop.getType(), prop);
        }
        VisitorFormatWrapperImpl visitor = new VisitorFormatWrapperImpl(this._schemas, prov);
        ser.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, prop.getType());
        return visitor.getAvroSchema();
    }
}

